/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnElementHolder;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.ColumnPairElementHolder;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.DBMemoryCollection;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;

public final class TableElement
extends DBElement
implements ColumnElementHolder,
ColumnPairElementHolder {
    public static final boolean TABLE = true;
    public static final boolean VIEW = false;
    private transient SchemaElement declaringSchema;

    public TableElement() {
        this(new Memory(), null);
    }

    public TableElement(Impl impl, SchemaElement declaringSchema) {
        super(impl);
        this.declaringSchema = declaringSchema;
    }

    final Impl getTableImpl() {
        return (Impl)this.getElementImpl();
    }

    public static TableElement forName(String name, SchemaElement schema) {
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            return null;
        }
        name = name.substring(pos + 1);
        TableElement[] tes = schema.getTables();
        for (int i = 0; i < tes.length; ++i) {
            if (!tes[i].getName().getName().trim().equals(name)) continue;
            return tes[i];
        }
        return null;
    }

    public static TableElement forName(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("FullyQualifiedName"));
            }
            return null;
        }
        SchemaElement se = SchemaElement.forName(name.substring(0, index));
        if (se == null) {
            return null;
        }
        return TableElement.forName(name, se);
    }

    public void setTableOrView(boolean isTable) throws DBException {
        this.getTableImpl().setTableOrView(isTable);
    }

    public boolean isTableOrView() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isTable() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isView() {
        return !this.getTableImpl().isTableOrView();
    }

    public final SchemaElement getDeclaringSchema() {
        return this.declaringSchema;
    }

    public final void setDeclaringSchema(SchemaElement se) {
        if (this.declaringSchema == null) {
            this.declaringSchema = se;
        }
    }

    public void addColumn(ColumnElement el) throws DBException {
        this.addColumns(new ColumnElement[]{el});
    }

    public void addColumns(ColumnElement[] els) throws DBException {
        for (int i = 0; i < els.length; ++i) {
            if (this.getColumn(els[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", els[i]);
            }
            if (els[i].getDeclaringTable() != null) continue;
            els[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeColumns(els, 1);
    }

    public void removeColumn(ColumnElement el) throws DBException {
        this.removeColumns(new ColumnElement[]{el});
    }

    public void removeColumns(ColumnElement[] els) throws DBException {
        this.getTableImpl().changeColumns(els, -1);
    }

    public void setColumns(ColumnElement[] els) throws DBException {
        this.getTableImpl().changeColumns(els, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getTableImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier name) {
        return this.getTableImpl().getColumn(name);
    }

    public void addIndex(IndexElement el) throws DBException {
        this.addIndexes(new IndexElement[]{el});
    }

    public void addIndexes(IndexElement[] els) throws DBException {
        for (int i = 0; i < els.length; ++i) {
            if (this.getIndex(els[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", els[i]);
            }
            if (els[i].getDeclaringTable() != null) continue;
            els[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeIndexes(els, 1);
    }

    public void removeIndex(IndexElement el) throws DBException {
        this.removeIndexes(new IndexElement[]{el});
    }

    public void removeIndexes(IndexElement[] els) throws DBException {
        this.getTableImpl().changeIndexes(els, -1);
    }

    public void setIndexes(IndexElement[] els) throws DBException {
        this.getTableImpl().changeIndexes(els, 0);
    }

    public IndexElement[] getIndexes() {
        return this.getTableImpl().getIndexes();
    }

    public IndexElement getIndex(DBIdentifier name) {
        return this.getTableImpl().getIndex(name);
    }

    public void addKey(KeyElement el) throws DBException {
        this.addKeys(new KeyElement[]{el});
    }

    public void addKeys(KeyElement[] els) throws DBException {
        for (int i = 0; i < els.length; ++i) {
            if (this.getKey(els[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", els[i]);
            }
            if (els[i].getDeclaringTable() == null) {
                els[i].setDeclaringTable(this);
            }
            if (!(els[i] instanceof UniqueKeyElement) || ((UniqueKeyElement)els[i]).getAssociatedIndex() != null) continue;
            IndexElement ie = new IndexElement();
            try {
                ie.setName(els[i].getName());
                ie.setColumns(els[i].getColumns());
                this.addIndex(ie);
            }
            catch (DBException exc) {
                exc.printStackTrace();
            }
            ((UniqueKeyElement)els[i]).setAssociatedIndex(ie);
        }
        this.getTableImpl().changeKeys(els, 1);
    }

    public void removeKey(KeyElement el) throws DBException {
        this.removeKeys(new KeyElement[]{el});
    }

    public void removeKeys(KeyElement[] els) throws DBException {
        this.getTableImpl().changeKeys(els, -1);
    }

    public void setKeys(KeyElement[] els) throws DBException {
        this.getTableImpl().changeKeys(els, 0);
    }

    public KeyElement[] getKeys() {
        return this.getTableImpl().getKeys();
    }

    public KeyElement getKey(DBIdentifier name) {
        return this.getTableImpl().getKey(name);
    }

    private ArrayList getKeys(Class subtype) {
        KeyElement[] keys = this.getKeys();
        if (keys == null) {
            return null;
        }
        int count = keys.length;
        ArrayList<KeyElement> subKeys = new ArrayList<KeyElement>(count);
        for (int i = 0; i < count; ++i) {
            KeyElement key = keys[i];
            if (!subtype.isInstance(key)) continue;
            subKeys.add(key);
        }
        return subKeys;
    }

    public ForeignKeyElement[] getForeignKeys() {
        ArrayList keys = this.getKeys(ForeignKeyElement.class);
        if (keys == null) {
            return null;
        }
        int count = keys.size();
        return keys.toArray(new ForeignKeyElement[count]);
    }

    public ForeignKeyElement getForeignKey(DBIdentifier name) {
        ForeignKeyElement[] fks = this.getForeignKeys();
        int count = fks.length;
        for (int i = 0; i < count; ++i) {
            ForeignKeyElement fk = fks[i];
            if (!name.equals(fk.getName())) continue;
            return fk;
        }
        return null;
    }

    public UniqueKeyElement[] getUniqueKeys() {
        ArrayList keys = this.getKeys(UniqueKeyElement.class);
        if (keys == null) {
            return null;
        }
        return keys.toArray(new UniqueKeyElement[keys.size()]);
    }

    public UniqueKeyElement getUniqueKey(DBIdentifier name) {
        UniqueKeyElement[] uks = this.getUniqueKeys();
        int count = uks.length;
        for (int i = 0; i < count; ++i) {
            UniqueKeyElement uk = uks[i];
            if (!name.equals(uk.getName())) continue;
            return uk;
        }
        return null;
    }

    public UniqueKeyElement getPrimaryKey() {
        UniqueKeyElement[] uks = this.getUniqueKeys();
        if (uks == null) {
            return null;
        }
        for (int i = 0; i < uks.length; ++i) {
            UniqueKeyElement uk = uks[i];
            if (!uk.isPrimaryKey()) continue;
            return uk;
        }
        return null;
    }

    private void throwAddException(String formatKey, DBMemberElement element) throws DBException {
        String msg = element.getName().getName();
        throw new DBException(msg);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName().toString();
        }
        return null;
    }

    public void addColumnPair(ColumnPairElement pair) throws DBException {
        this.addColumnPairs(new ColumnPairElement[]{pair});
    }

    public void addColumnPairs(ColumnPairElement[] pairs) throws DBException {
        for (int i = 0; i < pairs.length; ++i) {
            if (this.getColumnPair(pairs[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", pairs[i]);
            }
            if (pairs[i].getDeclaringTable() != null) continue;
            pairs[i].setDeclaringTable(this);
        }
        this.getTableImpl().changeColumnPairs(pairs, 1);
    }

    public void removeColumnPair(ColumnPairElement pair) throws DBException {
        this.removeColumnPairs(new ColumnPairElement[]{pair});
    }

    public void removeColumnPairs(ColumnPairElement[] pairs) throws DBException {
        this.getTableImpl().changeColumnPairs(pairs, -1);
    }

    public void setColumnPairs(ColumnPairElement[] pairs) throws DBException {
        this.getTableImpl().changeColumnPairs(pairs, 0);
    }

    public ColumnPairElement[] getColumnPairs() {
        return this.getTableImpl().getColumnPairs();
    }

    public ColumnPairElement getColumnPair(DBIdentifier name) {
        return this.getTableImpl().getColumnPair(name);
    }

    public DBMemberElement getMember(DBIdentifier name) {
        int index = name.getName().indexOf(";");
        if (index == -1) {
            return this.getColumn(name);
        }
        return this.getColumnPair(name);
    }

    static final class Memory
    extends DBElement.Memory
    implements Impl {
        private boolean _isTable;
        private DBMemoryCollection.Column columns;
        private DBMemoryCollection.Index indexes;
        private DBMemoryCollection.Key keys;
        private DBMemoryCollection.ColumnPair pairs;

        public Memory() {
            this._isTable = true;
        }

        public Memory(TableElement el) {
            super(el);
            this._isTable = el.isTableOrView();
        }

        public void setTableOrView(boolean isTable) {
            boolean old = this._isTable;
            this._isTable = isTable;
            this.firePropertyChange("tableOrView", old, isTable);
        }

        public boolean isTableOrView() {
            return this._isTable;
        }

        public synchronized void changeColumns(ColumnElement[] elems, int action) throws DBException {
            this.initColumns();
            this.columns.change(elems, action);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier name) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(name);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }

        public synchronized void changeIndexes(IndexElement[] elems, int action) throws DBException {
            this.initIndexes();
            this.indexes.change(elems, action);
        }

        public synchronized IndexElement[] getIndexes() {
            this.initIndexes();
            return (IndexElement[])this.indexes.getElements();
        }

        public synchronized IndexElement getIndex(DBIdentifier name) {
            this.initIndexes();
            return (IndexElement)this.indexes.getElement(name);
        }

        void initIndexes() {
            if (this.indexes == null) {
                this.indexes = new DBMemoryCollection.Index(this);
            }
        }

        public synchronized void changeKeys(KeyElement[] elems, int action) throws DBException {
            this.initKeys();
            this.keys.change(elems, action);
        }

        public synchronized KeyElement[] getKeys() {
            this.initKeys();
            return (KeyElement[])this.keys.getElements();
        }

        public synchronized KeyElement getKey(DBIdentifier name) {
            this.initKeys();
            return (KeyElement)this.keys.getElement(name);
        }

        void initKeys() {
            if (this.keys == null) {
                this.keys = new DBMemoryCollection.Key(this);
            }
        }

        final TableElement getTableElement() {
            return (TableElement)this._element;
        }

        public synchronized ColumnPairElement[] getColumnPairs() {
            this.initColumnPairs();
            return (ColumnPairElement[])this.pairs.getElements();
        }

        public synchronized ColumnPairElement getColumnPair(DBIdentifier name) {
            this.initColumnPairs();
            return (ColumnPairElement)this.pairs.getElement(name);
        }

        public synchronized void changeColumnPairs(ColumnPairElement[] pairs, int action) throws DBException {
            this.initColumnPairs();
            this.pairs.change(pairs, action);
        }

        void initColumnPairs() {
            if (this.pairs == null) {
                this.pairs = new DBMemoryCollection.ColumnPair(this);
            }
        }
    }

    public static interface Impl
    extends DBElement.Impl {
        public void setTableOrView(boolean var1) throws DBException;

        public boolean isTableOrView();

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);

        public void changeIndexes(IndexElement[] var1, int var2) throws DBException;

        public IndexElement[] getIndexes();

        public IndexElement getIndex(DBIdentifier var1);

        public void changeKeys(KeyElement[] var1, int var2) throws DBException;

        public KeyElement[] getKeys();

        public KeyElement getKey(DBIdentifier var1);

        public void changeColumnPairs(ColumnPairElement[] var1, int var2) throws DBException;

        public ColumnPairElement[] getColumnPairs();

        public ColumnPairElement getColumnPair(DBIdentifier var1);
    }
}

