/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.ObjectStreamException;
import java.sql.Timestamp;

public class SqlTimestamp
extends Timestamp
implements SCODate {
    private transient PersistenceCapable owner;
    private transient String fieldName;

    public SqlTimestamp(Object owner, String fieldName) {
        super(0L);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
    }

    public SqlTimestamp(Object owner, String fieldName, long date) {
        super(date);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
    }

    public void setTime(long time) {
        this.makeDirty();
        super.setTime(time);
    }

    public void setNanos(int n) {
        this.makeDirty();
        super.setNanos(n);
    }

    public Object clone() {
        SqlTimestamp obj = (SqlTimestamp)super.clone();
        obj.owner = null;
        obj.fieldName = null;
        return obj;
    }

    public void setYear(int year) {
        this.makeDirty();
        super.setYear(year);
    }

    public void setMonth(int month) {
        this.makeDirty();
        super.setMonth(month);
    }

    public void setDate(int date) {
        this.makeDirty();
        super.setDate(date);
    }

    public void setHours(int hours) {
        this.makeDirty();
        super.setHours(hours);
    }

    public void setMinutes(int minutes) {
        this.makeDirty();
        super.setMinutes(minutes);
    }

    public void setSeconds(int seconds) {
        this.makeDirty();
        super.setSeconds(seconds);
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void setTimeInternal(long time) {
        super.setTime(time);
    }

    public void setNanosInternal(int n) {
        super.setNanos(n);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager makeDirty() {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                StateManager stateManager2 = stateManager;
                synchronized (stateManager2) {
                    block9: {
                        if (this.owner == null) break block9;
                        stateManager.makeDirty(this.fieldName);
                        StateManager stateManager3 = stateManager;
                        return stateManager3;
                    }
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return null;
    }

    public void applyUpdates(StateManager sm, boolean modified) {
    }

    Object writeReplace() throws ObjectStreamException {
        Timestamp t = new Timestamp(this.getTime());
        t.setNanos(this.getNanos());
        return t;
    }
}

