/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class AnnotatedClassAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "filter.annotatedClass";
    public static final short expectedAttrVersion = 1;
    public static final short generatedFlag = 1;
    public static final short annotatedFlag = 2;
    public static final short modifiedFlag = 4;
    private short attrVersion;
    private short annotationFlags;
    private long classModTime;
    private long classAnnotationTime;

    public short getVersion() {
        return this.attrVersion;
    }

    public void setVersion(short version) {
        this.attrVersion = version;
    }

    public short getFlags() {
        return this.annotationFlags;
    }

    public void setFlags(short flags) {
        this.annotationFlags = flags;
    }

    public long getModTime() {
        return this.classModTime;
    }

    public void setModTime(long time) {
        this.classModTime = time;
    }

    public long getAnnotationTime() {
        return this.classAnnotationTime;
    }

    public void setAnnotationTime(long time) {
        this.classAnnotationTime = time;
    }

    public AnnotatedClassAttribute(ConstUtf8 nameAttr, short version, short annFlags, long modTime, long annTime) {
        super(nameAttr);
        this.attrVersion = version;
        this.annotationFlags = annFlags;
        this.classModTime = modTime;
        this.classAnnotationTime = annTime;
    }

    static AnnotatedClassAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        short version = data.readShort();
        short annFlags = data.readShort();
        long modTime = data.readLong();
        long annTime = data.readLong();
        return new AnnotatedClassAttribute(attrName, version, annFlags, modTime, annTime);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        out.writeShort(20);
        out.writeShort(this.attrVersion);
        out.writeShort(this.annotationFlags);
        out.writeLong(this.classModTime);
        out.writeLong(this.classAnnotationTime);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("version: " + this.attrVersion);
        out.println(" flags: " + this.annotationFlags);
        out.println(" modTime: " + this.classModTime);
        out.println(" annTime: " + this.classAnnotationTime);
    }
}

