/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.model;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.jdo.api.persistence.model.RuntimeModel;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DeploymentDescriptorModel
extends RuntimeModel {
    private ClassLoader _classLoader;
    private NameMapper _nameMapper;
    public static final String SIGNATURE = "$RCSfile: DeploymentDescriptorModel.java,v $ $Revision: 1.2 $";

    public DeploymentDescriptorModel(NameMapper nameMapper, ClassLoader classLoader) {
        this._classLoader = classLoader;
        this._nameMapper = nameMapper;
    }

    private ClassLoader getClassLoader() {
        return this._classLoader;
    }

    private NameMapper getNameMapper() {
        return this._nameMapper;
    }

    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        return super.getInputStreamForResource(className, this.getClassLoader(), resourceName);
    }

    protected String findPenultimateSuperclass(String className) {
        return this.isPCClassName(className) ? className : super.findPenultimateSuperclass(className);
    }

    protected String getSuperclass(String className) {
        return this.isPCClassName(className) ? "java.lang.Object" : super.getSuperclass(className);
    }

    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        BufferedOutputStream outputStream = super.createFile(className, baseFileName, extension);
        if (outputStream != null) {
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    protected void deleteFile(String className, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object getClass(String className, ClassLoader classLoader) {
        String testClass = className;
        if (className != null) {
            String ejbName;
            NameMapper nameMapper = this.getNameMapper();
            String string = ejbName = this.isPCClassName(className) ? this.getEjbName(className) : className;
            if (nameMapper.isEjbName(ejbName)) {
                testClass = nameMapper.getAbstractBeanClassForEjbName(ejbName);
            } else {
                String keyClass = nameMapper.getKeyClassForPersistenceKeyClass(className);
                if (keyClass != null) {
                    if (2 == this.getPersistenceKeyClassType(className)) {
                        if (this.isPrimitive(keyClass)) {
                            return JavaTypeHelper.getPrimitiveClass((String)keyClass);
                        }
                        if (this.isByteArray(keyClass) || keyClass.endsWith("[]")) {
                            return byte[].class;
                        }
                    }
                    testClass = keyClass;
                }
            }
        }
        return super.getClass(testClass, this.getClassLoader());
    }

    public Object getConstructor(String className, String[] argTypeNames) {
        Object returnObject = null;
        if (2 == this.getPersistenceKeyClassType(className) && Arrays.equals(argTypeNames, NO_ARGS)) {
            returnObject = new MemberWrapper(className, null, 1, (Class)this.getClass(className));
        }
        if (returnObject == null && (returnObject = super.getConstructor(className, argTypeNames)) instanceof Constructor) {
            returnObject = new MemberWrapper((Constructor)returnObject);
        }
        return returnObject;
    }

    public Object getMethod(String className, String methodName, String[] argTypeNames) {
        int keyClassType = this.getPersistenceKeyClassType(className);
        Object returnObject = null;
        if (this.isPCClassName(className) && (methodName.equals("readObject") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getReadObjectArgs()) || methodName.equals("writeObject") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getWriteObjectArgs()))) {
            returnObject = new MemberWrapper(methodName, Void.TYPE, 2, (Class)this.getClass(className));
        }
        if (3 == keyClassType || 2 == keyClassType) {
            if (methodName.equals("equals") && Arrays.equals(argTypeNames, DeploymentDescriptorModel.getEqualsArgs())) {
                returnObject = new MemberWrapper(methodName, Boolean.TYPE, 1, (Class)this.getClass(className));
            } else if (methodName.equals("hashCode") && Arrays.equals(argTypeNames, NO_ARGS)) {
                returnObject = new MemberWrapper(methodName, Integer.TYPE, 1, (Class)this.getClass(className));
            }
        }
        if (returnObject == null && (returnObject = super.getMethod(className, methodName, argTypeNames)) instanceof Method) {
            returnObject = new MemberWrapper((Method)returnObject);
        }
        return returnObject;
    }

    public Object getInheritedMethod(String className, String methodName, String[] argTypeNames) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getMethod(className, methodName, argTypeNames) : super.getInheritedMethod(className, methodName, argTypeNames);
    }

    public List getFields(String className) {
        EjbCMPEntityDescriptor descriptor = this.getCMPDescriptor(className);
        String testClass = className;
        if (descriptor != null) {
            Iterator iterator = descriptor.getFieldDescriptors().iterator();
            ArrayList<String> returnList = new ArrayList<String>();
            while (iterator.hasNext()) {
                returnList.add(((FieldDescriptor)iterator.next()).getName());
            }
            return returnList;
        }
        NameMapper nameMapper = this.getNameMapper();
        String ejbName = nameMapper.getEjbNameForPersistenceKeyClass(className);
        switch (this.getPersistenceKeyClassType(className)) {
            case 1: {
                testClass = nameMapper.getKeyClassForEjbName(ejbName);
                break;
            }
            case 2: {
                return Arrays.asList(this.getCMPDescriptor(ejbName).getPrimaryKeyFieldDesc().getName());
            }
            case 3: {
                String pcClassName = nameMapper.getPersistenceClassForEjbName(ejbName);
                PersistenceFieldElement[] fields = this.getPersistenceClass(pcClassName).getFields();
                int count = fields != null ? fields.length : 0;
                for (int i = 0; i < count; ++i) {
                    PersistenceFieldElement pfe = fields[i];
                    if (!pfe.isKey()) continue;
                    return Arrays.asList(pfe.getName());
                }
                break;
            }
        }
        return super.getFields(testClass);
    }

    public List getAllFields(String className) {
        return 2 == this.getPersistenceKeyClassType(className) ? this.getFields(className) : super.getAllFields(className);
    }

    public Object getField(String className, String fieldName) {
        String testClass = className;
        Object returnObject = null;
        if (className != null) {
            NameMapper nameMapper = this.getNameMapper();
            boolean isPCClass = this.isPCClassName(className);
            boolean isPKClassName = false;
            String searchClassName = className;
            String searchFieldName = fieldName;
            if (isPCClass) {
                searchFieldName = nameMapper.getEjbFieldForPersistenceField(className, fieldName);
                searchClassName = this.getEjbName(className);
            } else {
                String ejbName = nameMapper.getEjbNameForPersistenceKeyClass(className);
                switch (this.getPersistenceKeyClassType(className)) {
                    case 2: {
                        testClass = ejbName;
                        searchClassName = ejbName;
                        isPKClassName = true;
                        break;
                    }
                    case 3: {
                        testClass = nameMapper.getPersistenceClassForEjbName(ejbName);
                        isPCClass = true;
                        isPKClassName = true;
                    }
                }
            }
            if (nameMapper.isEjbName(searchClassName)) {
                searchClassName = nameMapper.getAbstractBeanClassForEjbName(searchClassName);
            }
            if ((returnObject = super.getField(searchClassName, searchFieldName)) == null) {
                returnObject = this.getFieldWrapper(testClass, searchFieldName);
            } else if (returnObject instanceof Field) {
                returnObject = new MemberWrapper((Field)returnObject);
            }
            if (isPCClass) {
                returnObject = this.updateFieldWrapper((MemberWrapper)returnObject, testClass, fieldName);
            }
            if (isPKClassName && returnObject instanceof MemberWrapper) {
                ((MemberWrapper)returnObject)._modifiers = 1;
            }
        }
        return returnObject;
    }

    public String getFieldType(String className, String fieldName) {
        String returnType = super.getFieldType(className, fieldName);
        if (!this.isCollection(returnType) && this.isPCClassName(className)) {
            String ejbField;
            String ejbName;
            NameMapper nameMapper = this.getNameMapper();
            if (nameMapper.isGeneratedEjbRelationship(ejbName = nameMapper.getEjbNameForPersistenceClass(className), ejbField = nameMapper.getEjbFieldForPersistenceField(className, fieldName))) {
                String[] inverse = nameMapper.getEjbFieldForGeneratedField(ejbName, ejbField);
                returnType = nameMapper.getPersistenceClassForEjbName(inverse[0]);
            }
            if (nameMapper.isLocalInterface(returnType)) {
                returnType = nameMapper.getPersistenceClassForLocalInterface(className, fieldName, returnType);
            }
        }
        return returnType;
    }

    public String getDeclaringClass(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            Class classElement = ((MemberWrapper)memberElement).getDeclaringClass();
            return classElement != null ? classElement.getName() : null;
        }
        return super.getDeclaringClass(memberElement);
    }

    public int getModifiers(Object memberElement) {
        if (memberElement != null && memberElement instanceof MemberWrapper) {
            return ((MemberWrapper)memberElement).getModifiers();
        }
        return super.getModifiers(memberElement);
    }

    public int getModifiersForClass(String className) {
        int modifiers = super.getModifiersForClass(className);
        if (this.isPCClassName(className)) {
            modifiers &= 0xFFFFFBFF;
        } else if (this.getNameMapper().getKeyClassForPersistenceKeyClass(className) != null) {
            modifiers |= 8;
        }
        return modifiers;
    }

    public boolean isValidKeyType(String className, String fieldName) {
        return 2 == this.getPersistenceKeyClassType(className) && this.isPrimitive(className, fieldName) ? false : super.isValidKeyType(className, fieldName);
    }

    protected Class getTypeObject(Object element) {
        Class type = super.getTypeObject(element);
        if (element != null && element instanceof MemberWrapper) {
            type = ((MemberWrapper)element).getType();
        }
        return type;
    }

    protected ClassLoader findClassLoader(String className, ClassLoader classLoader) {
        return this.getClassLoader();
    }

    private boolean isPCClassName(String className) {
        return this.getEjbName(className) != null;
    }

    private String getEjbName(String className) {
        return this.getNameMapper().getEjbNameForPersistenceClass(className);
    }

    private EjbCMPEntityDescriptor getCMPDescriptor(String className) {
        String descriptorName = this.isPCClassName(className) ? this.getEjbName(className) : className;
        return this.getNameMapper().getDescriptorForEjbName(descriptorName);
    }

    private int getPersistenceKeyClassType(String className) {
        NameMapper nameMapper;
        String ejbName;
        int returnValue = -1;
        if (this.getCMPDescriptor(className) == null && (ejbName = (nameMapper = this.getNameMapper()).getEjbNameForPersistenceKeyClass(className)) != null) {
            returnValue = nameMapper.getKeyClassTypeForEjbName(ejbName);
        }
        return returnValue;
    }

    private MemberWrapper getFieldWrapper(String className, String fieldName) {
        PersistenceDescriptor persistenceDescriptor;
        EjbCMPEntityDescriptor descriptor = this.getCMPDescriptor(className);
        MemberWrapper returnObject = null;
        if (descriptor != null && (persistenceDescriptor = descriptor.getPersistenceDescriptor()) != null) {
            Class fieldType = null;
            try {
                fieldType = persistenceDescriptor.getTypeFor(fieldName);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            returnObject = fieldType == null ? null : new MemberWrapper(fieldName, fieldType, 2, (Class)this.getClass(className));
        }
        return returnObject;
    }

    private MemberWrapper updateFieldWrapper(MemberWrapper returnObject, String className, String fieldName) {
        PersistenceFieldElement field;
        NameMapper nameMapper = this.getNameMapper();
        if (returnObject == null && (field = this.getPersistenceFieldInternal(className, fieldName)) != null) {
            String ejbName = this.getEjbName(className);
            String ejbFieldName = nameMapper.getEjbFieldForPersistenceField(className, fieldName);
            if (field.isKey() && ejbName != null && nameMapper.getKeyClassTypeForEjbName(ejbName) == 3) {
                returnObject = new MemberWrapper(ejbFieldName, Long.class, 2, (Class)this.getClass(className));
            } else if (field instanceof RelationshipElement && nameMapper.isGeneratedEjbRelationship(ejbName, ejbFieldName)) {
                RelationshipElement rel = (RelationshipElement)field;
                Class classType = null;
                if (rel.getUpperBound() > 1) {
                    classType = HashSet.class;
                } else {
                    String[] inverse = nameMapper.getEjbFieldForGeneratedField(ejbName, ejbFieldName);
                    classType = (Class)this.getClass(inverse[0]);
                }
                if (classType != null) {
                    returnObject = new MemberWrapper(ejbFieldName, classType, 2, (Class)this.getClass(className));
                }
            } else if (ejbFieldName.startsWith("thisVersionFieldWasGeneratedByTheNameMapper") && nameMapper.isGeneratedField(ejbName, ejbFieldName)) {
                returnObject = new MemberWrapper(ejbFieldName, Long.TYPE, 2, (Class)this.getClass(className));
            }
        }
        if (!this.isPersistentTypeAllowed(this.getType(returnObject), this.getClassLoader()) && this.isSerializable(returnObject)) {
            returnObject.setType(byte[].class);
        }
        return returnObject;
    }

    private class MemberWrapper {
        private String _name;
        private Class _type;
        private int _modifiers;
        private Class _declaringClass;

        private MemberWrapper(Member member) {
            this(member.getName(), member instanceof Field ? ((Field)member).getType() : (member instanceof Method ? ((Method)member).getReturnType() : null), member.getModifiers(), member.getDeclaringClass());
        }

        private MemberWrapper(String name, Class type, int modifiers, Class declaringClass) {
            this._name = name;
            this._type = type;
            this._modifiers = modifiers;
            this._declaringClass = declaringClass;
        }

        private Class getType() {
            return this._type;
        }

        private void setType(Class type) {
            this._type = type;
        }

        private String getName() {
            return this._name;
        }

        private int getModifiers() {
            return this._modifiers;
        }

        private Class getDeclaringClass() {
            return this._declaringClass;
        }

        public String toString() {
            return this.getName();
        }
    }
}

