/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.argparser;

import com.sun.corba.ee.spi.orbutil.argparser.ElementParser;
import com.sun.corba.ee.spi.orbutil.argparser.Separator;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ElementParserImpl
implements ElementParser {
    private UnaryFunction<String, Object> func;
    private String[] description;

    @Override
    public Object evaluate(String str) {
        return this.func.evaluate(str);
    }

    @Override
    public String[] describe() {
        return this.description;
    }

    public ElementParserImpl(Method m) {
        ResultData result = this.getData(m);
        this.func = (UnaryFunction)result.first();
        this.description = (String[])result.second();
    }

    String[] append(String str, String[] strs) {
        String[] result = new String[strs.length + 1];
        int rctr = 0;
        result[rctr++] = str;
        for (String s : strs) {
            result[rctr++] = s;
        }
        return result;
    }

    private ResultData getData(Method meth) {
        UnaryFunction<String, Object> func = null;
        String[] description = null;
        Class<?> type = meth.getReturnType();
        if (type.isArray()) {
            final String sep = this.getSeparator(meth);
            final Class<?> elementClass = type.getComponentType();
            final ResultData elementResultData = this.getSimpleData(elementClass);
            description = this.append("A " + sep + "-separated list of ", (String[])elementResultData.second());
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String value) {
                    String[] elements = value.split(sep);
                    Object result = Array.newInstance(elementClass, elements.length);
                    int ctr = 0;
                    for (String str : elements) {
                        Object val = ((UnaryFunction)elementResultData.first()).evaluate(str);
                        Array.set(result, ctr++, val);
                    }
                    return result;
                }
            };
        } else if (type.equals(List.class)) {
            final String sep = this.getSeparator(meth);
            Class elementClass = this.getListElementClass(meth);
            final ResultData elementResultData = this.getSimpleData(elementClass);
            description = this.append("A " + sep + "-separated list of ", (String[])elementResultData.second());
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String value) {
                    String[] elements = value.split(sep);
                    ArrayList result = new ArrayList(elements.length);
                    for (String str : elements) {
                        Object val = ((UnaryFunction)elementResultData.first()).evaluate(str);
                        result.add(val);
                    }
                    return result;
                }
            };
        } else {
            return this.getSimpleData(type);
        }
        return new ResultData(func, description);
    }

    private ResultData getSimpleData(final Class type) {
        UnaryFunction<String, Object> func = null;
        String[] description = null;
        if (type.isPrimitive()) {
            description = new String[]{"A valid " + type.getName()};
            func = this.getPrimitiveParser(type);
        } else if (type == String.class) {
            description = new String[]{"A String"};
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return str;
                }
            };
        } else if (type.isEnum()) {
            description = new String[]{"One of: " + this.getEnumElements(type)};
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    try {
                        return Enum.valueOf(type, str);
                    }
                    catch (IllegalArgumentException exc) {
                        throw new RuntimeException(str + " is not in enum " + type.getName());
                    }
                }
            };
        } else {
            description = new String[]{"A string that can create a " + type.getName()};
            func = this.makeClassConverter(type);
        }
        return new ResultData(func, description);
    }

    private String getEnumElements(Class cls) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Object obj : cls.getEnumConstants()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(' ');
            }
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    private UnaryFunction<String, Object> getPrimitiveParser(Class type) {
        UnaryFunction<String, Object> func = null;
        if (type == Boolean.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Boolean.valueOf(str);
                }
            };
        } else if (type == Byte.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Byte.valueOf(str);
                }
            };
        } else if (type == Character.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    if (str.length() != 1) {
                        throw new RuntimeException("String \"" + str + "\" cannot be converted to a Character");
                    }
                    return Character.valueOf(str.charAt(0));
                }
            };
        } else if (type == Short.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Short.valueOf(str);
                }
            };
        } else if (type == Integer.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Integer.valueOf(str);
                }
            };
        } else if (type == Long.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Long.valueOf(str);
                }
            };
        } else if (type == Float.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Float.valueOf(str);
                }
            };
        } else if (type == Double.TYPE) {
            func = new UnaryFunction<String, Object>(){

                @Override
                public Object evaluate(String str) {
                    return Double.valueOf(str);
                }
            };
        }
        return func;
    }

    private UnaryFunction<String, Object> makeClassConverter(final Class type) {
        Constructor cons = null;
        try {
            cons = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(type.getName() + " does not have a constructor (String)");
        }
        catch (SecurityException e2) {
            throw new RuntimeException(type.getName() + " constructor (String) is not accessible");
        }
        final Constructor fcons = cons;
        return new UnaryFunction<String, Object>(){

            @Override
            public Object evaluate(String str) {
                try {
                    return fcons.newInstance(str);
                }
                catch (InvocationTargetException e1) {
                    throw new RuntimeException(type.getName() + "(String) constructor threw exception: " + e1.getTargetException());
                }
                catch (Exception e2) {
                    throw new RuntimeException("Exception " + e2 + " occured in calling constructor " + type.getName() + "(String)");
                }
            }
        };
    }

    private Class getListElementClass(Method meth) {
        Type rtype = meth.getGenericReturnType();
        if (rtype instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)rtype;
            Type[] typeArgs = ptype.getActualTypeArguments();
            assert (typeArgs.length == 1);
            Type etype = typeArgs[0];
            if (etype instanceof Class) {
                return (Class)etype;
            }
            throw new RuntimeException("Method " + meth + " has a List<> return type " + " that is not parameterized by a class");
        }
        throw new RuntimeException("Method " + meth + " does not have a parameterized List return type");
    }

    private String getSeparator(Method meth) {
        Separator sep = meth.getAnnotation(Separator.class);
        String result = ",";
        if (sep != null) {
            result = sep.value();
        }
        return result;
    }

    private class ResultData
    extends Pair<UnaryFunction<String, Object>, String[]> {
        public ResultData(UnaryFunction<String, Object> func, String[] desc) {
            super(func, desc);
        }
    }
}

