/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.copyobject;

import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopier;
import com.sun.corba.ee.impl.orbutil.copyobject.ClassCopierOrdinaryImpl;
import com.sun.corba.ee.impl.orbutil.copyobject.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.orbutil.copyobject.ReflectiveCopyException;
import java.security.Permission;
import java.util.Map;
import sun.corba.Bridge;
import sun.corba.BridgePermission;

public abstract class CodegenCopierBase
implements ClassCopierOrdinaryImpl.ClassFieldCopier {
    private static final Bridge bridge = Bridge.get();
    private static final Permission getBridgePermission = new BridgePermission("getBridge");
    private PipelineClassCopierFactory factory;

    public CodegenCopierBase(PipelineClassCopierFactory factory) {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(getBridgePermission);
        }
        this.factory = factory;
    }

    protected final void copyObject(Map oldToNew, long offset, Object src, Object dest) throws ReflectiveCopyException {
        Object obj = bridge.getObject(src, offset);
        Object result = null;
        if (obj != null) {
            ClassCopier copier = this.factory.getClassCopier(obj.getClass());
            result = copier.copy(oldToNew, obj);
        }
        bridge.putObject(dest, offset, result);
    }

    protected final void copyByte(long offset, Object src, Object dest) {
        bridge.putByte(dest, offset, bridge.getByte(src, offset));
    }

    protected final void copyChar(long offset, Object src, Object dest) {
        bridge.putChar(dest, offset, bridge.getChar(src, offset));
    }

    protected final void copyShort(long offset, Object src, Object dest) {
        bridge.putShort(dest, offset, bridge.getShort(src, offset));
    }

    protected final void copyInt(long offset, Object src, Object dest) {
        bridge.putInt(dest, offset, bridge.getInt(src, offset));
    }

    protected final void copyLong(long offset, Object src, Object dest) {
        bridge.putLong(dest, offset, bridge.getLong(src, offset));
    }

    protected final void copyFloat(long offset, Object src, Object dest) {
        bridge.putFloat(dest, offset, bridge.getFloat(src, offset));
    }

    protected final void copyDouble(long offset, Object src, Object dest) {
        bridge.putDouble(dest, offset, bridge.getDouble(src, offset));
    }

    protected final void copyBoolean(long offset, Object src, Object dest) {
        bridge.putBoolean(dest, offset, bridge.getBoolean(src, offset));
    }
}

