/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.jmx;

import com.sun.corba.ee.spi.orbutil.generic.Algorithms;
import com.sun.corba.ee.spi.orbutil.generic.BinaryFunction;
import com.sun.corba.ee.spi.orbutil.generic.BinaryVoidFunction;
import com.sun.corba.ee.spi.orbutil.generic.Graph;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.generic.UnaryBooleanFunction;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import com.sun.corba.ee.spi.orbutil.jmx.InheritedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.InheritedAttributes;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObjectManager;
import com.sun.corba.ee.spi.orbutil.jmx.TypeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AnnotationUtil {
    private static Graph.Finder<Class<?>> finder = new Graph.Finder<Class<?>>(){

        @Override
        public List<Class<?>> evaluate(Class<?> arg) {
            ArrayList result = new ArrayList();
            Class<?> sclass = arg.getSuperclass();
            if (sclass != null) {
                result.add(sclass);
            }
            for (Class<?> cls : arg.getInterfaces()) {
                result.add(cls);
            }
            return result;
        }
    };
    private static Map<Class<?>, List<Class<?>>> inheritanceMap = new WeakHashMap();

    private static List<Class<?>> makeInheritanceChain(Class<?> cls) {
        Graph gr = new Graph(cls, finder);
        ArrayList result = new ArrayList(gr.getPostorderList());
        Collections.reverse(result);
        return result;
    }

    public static List<Class<?>> getInheritanceChain(Class<?> cls) {
        List<Class<?>> result = inheritanceMap.get(cls);
        if (result == null) {
            result = AnnotationUtil.makeInheritanceChain(cls);
            inheritanceMap.put(cls, result);
        }
        return result;
    }

    private AnnotationUtil() {
    }

    public static Method findMethod(Class<?> cls, UnaryBooleanFunction<Method> predicate) {
        List<Class<?>> classes = AnnotationUtil.getInheritanceChain(cls);
        for (Class<?> c : classes) {
            for (Method m : c.getDeclaredMethods()) {
                if (!predicate.evaluate(m)) continue;
                return m;
            }
        }
        return null;
    }

    public static List<Method> getAnnotatedMethods(Class<?> cls, Class<? extends Annotation> annotation) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Class<?>> classes = AnnotationUtil.getInheritanceChain(cls);
        for (Class<?> c : classes) {
            for (Method m : c.getDeclaredMethods()) {
                Annotation ann = m.getAnnotation(annotation);
                if (ann == null) continue;
                result.add(m);
            }
        }
        return result;
    }

    public static <T extends Annotation> List<Pair<Class<?>, T>> getClassAnnotations(Class<?> cls, final Class<T> annotation) {
        List<Class<?>> classes = AnnotationUtil.getInheritanceChain(cls);
        UnaryFunction func = new UnaryFunction<Class<?>, Pair<Class<?>, T>>(){

            @Override
            public Pair<Class<?>, T> evaluate(Class<?> cls) {
                Object aval = cls.getAnnotation(annotation);
                return aval == null ? null : new Pair(cls, aval);
            }
        };
        return Algorithms.map(classes, func);
    }

    public static boolean isSetter(Method m, String id) {
        Class<?> rt = m.getReturnType();
        if (rt != Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 1) {
            return false;
        }
        String mname = m.getName();
        String initCapId = id.substring(0, 1).toUpperCase() + id.substring(1);
        if (mname.equals(id)) {
            return true;
        }
        return mname.equals("set" + initCapId);
    }

    public static boolean isGetter(Method m, String id) {
        Class<?> rt = m.getReturnType();
        if (rt == Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        String mname = m.getName();
        String initCapId = id.substring(0, 1).toUpperCase() + id.substring(1);
        if (mname.equals(id)) {
            return true;
        }
        if (mname.equals("get" + initCapId)) {
            return true;
        }
        return (rt.equals(Boolean.TYPE) || rt.equals(Boolean.class)) && mname.equals("is" + initCapId);
    }

    public static Method getSetterMethod(Class<?> cls, final String id) {
        return AnnotationUtil.findMethod(cls, new UnaryBooleanFunction<Method>(){

            @Override
            public boolean evaluate(Method m) {
                return AnnotationUtil.isSetter(m, id);
            }
        });
    }

    public static Method getGetterMethod(Class<?> cls, final String id) {
        return AnnotationUtil.findMethod(cls, new UnaryBooleanFunction<Method>(){

            @Override
            public boolean evaluate(Method m) {
                return AnnotationUtil.isGetter(m, id);
            }
        });
    }

    private static boolean startsWithNotEquals(String str, String prefix) {
        return str.startsWith(str) && !str.equals(prefix);
    }

    private static String stripPrefix(String str, String prefix) {
        int prefixLength = prefix.length();
        String first = str.substring(prefixLength, prefixLength + 1).toLowerCase();
        if (str.length() == prefixLength + 1) {
            return first;
        }
        return first + str.substring(prefixLength + 1);
    }

    public static Setter makeSetter(final Method m, final TypeConverter tc) {
        return new Setter(){

            @Override
            public void evaluate(Object target, Object value) {
                try {
                    m.invoke(target, tc.fromManagedEntity(value));
                }
                catch (Exception exc) {
                    throw new WrappedException(exc);
                }
            }
        };
    }

    public static Getter makeGetter(final Method m, final TypeConverter tc) {
        return new Getter(){

            @Override
            public Object evaluate(Object target) {
                try {
                    return tc.toManagedEntity(m.invoke(target, new Object[0]));
                }
                catch (Exception exc) {
                    throw new WrappedException(exc);
                }
            }
        };
    }

    public static InheritedAttribute[] getInheritedAttributes(Class<?> cls) {
        InheritedAttribute ia = cls.getAnnotation(InheritedAttribute.class);
        InheritedAttributes ias = cls.getAnnotation(InheritedAttributes.class);
        if (ia != null && ias != null) {
            throw new IllegalArgumentException("Only one of the annotations InheritedAttribute or InheritedAttributes may appear on a class");
        }
        InheritedAttribute[] iaa = null;
        if (ia != null) {
            iaa = new InheritedAttribute[]{ia};
        } else if (ias != null) {
            iaa = ias.attributes();
        }
        return iaa;
    }

    public static enum AttributeType {
        SETTER,
        GETTER;

    }

    public static interface Getter
    extends UnaryFunction<Object, Object> {
    }

    public static final class MethodInfo {
        private Method method;
        private String id;
        private String description;
        private AttributeType atype;
        private Type type;
        private TypeConverter tc;

        public final Method method() {
            return this.method;
        }

        public final String id() {
            return this.id;
        }

        public final String description() {
            return this.description;
        }

        public final AttributeType atype() {
            return this.atype;
        }

        public final Type type() {
            return this.type;
        }

        public final TypeConverter tc() {
            return this.tc;
        }

        public boolean isApplicable(Object obj) {
            return this.method.getDeclaringClass().isInstance(obj);
        }

        public Object get(Object obj) {
            try {
                return this.tc.toManagedEntity(this.method.invoke(obj, new Object[0]));
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }

        public MethodInfo(ManagedObjectManager mom, Method m, String extId, String description) {
            this.method = m;
            this.id = extId;
            this.description = description;
            String name = m.getName();
            if (AnnotationUtil.startsWithNotEquals(name, "get")) {
                if (extId.equals("")) {
                    this.id = AnnotationUtil.stripPrefix(name, "get");
                }
                this.atype = AttributeType.GETTER;
                if (m.getGenericReturnType() == Void.TYPE) {
                    throw new IllegalArgumentException(m + " is an illegal setter method");
                }
                if (m.getGenericParameterTypes().length != 0) {
                    throw new IllegalArgumentException(m + " is an illegal getter method");
                }
                this.type = m.getGenericReturnType();
            } else if (AnnotationUtil.startsWithNotEquals(name, "set")) {
                if (extId.equals("")) {
                    this.id = AnnotationUtil.stripPrefix(name, "set");
                }
                this.atype = AttributeType.SETTER;
                if (m.getGenericReturnType() != Void.TYPE) {
                    throw new IllegalArgumentException(m + " is an illegal setter method");
                }
                if (m.getGenericParameterTypes().length != 1) {
                    throw new IllegalArgumentException(m + " is an illegal setter method");
                }
                this.type = m.getGenericParameterTypes()[0];
            } else if (AnnotationUtil.startsWithNotEquals(name, "is")) {
                if (extId.equals("")) {
                    this.id = AnnotationUtil.stripPrefix(name, "is");
                }
                this.atype = AttributeType.GETTER;
                if (m.getGenericParameterTypes().length != 0) {
                    throw new IllegalArgumentException(m + " is an illegal \"is\" method");
                }
                this.type = m.getGenericReturnType();
                if (!this.type.equals(Boolean.TYPE) && !this.type.equals(Boolean.class)) {
                    throw new IllegalArgumentException(m + " is an illegal \"is\" method");
                }
            } else {
                if (extId.equals("")) {
                    this.id = name;
                }
                Type rtype = m.getGenericReturnType();
                Type[] ptypes = m.getGenericParameterTypes();
                if (rtype.equals(Void.TYPE) && ptypes.length == 1) {
                    this.type = ptypes[0];
                    this.atype = AttributeType.SETTER;
                } else if (!rtype.equals(Void.TYPE) && ptypes.length == 0) {
                    this.type = rtype;
                    this.atype = AttributeType.GETTER;
                } else {
                    throw new IllegalArgumentException(m + " is not a valid attribute method");
                }
            }
            this.tc = mom.getTypeConverter(this.type);
        }

        public MethodInfo(ManagedObjectManager mom, Method m) {
            this(mom, m, m.getAnnotation(ManagedAttribute.class).id(), m.getAnnotation(ManagedAttribute.class).description());
        }
    }

    public static interface Operation
    extends BinaryFunction<Object, List<Object>, Object> {
    }

    public static interface Setter
    extends BinaryVoidFunction<Object, Object> {
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(Exception exc) {
            super(exc);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

