/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.jmx;

import com.sun.corba.ee.impl.orbutil.jmx.AnnotationUtil;
import com.sun.corba.ee.spi.orbutil.jmx.IncludeSubclass;
import com.sun.corba.ee.spi.orbutil.jmx.InheritedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedData;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObject;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedObjectManager;
import com.sun.corba.ee.spi.orbutil.jmx.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class TypeConverterImpl
implements TypeConverter {
    private static Map<Type, OpenType> simpleTypeMap = new HashMap<Type, OpenType>();
    private static Map<OpenType, Type> simpleOpenTypeMap = new HashMap<OpenType, Type>();
    protected final Type dataType;
    protected final OpenType managedType;

    private static void initMaps(Type type, OpenType otype) {
        simpleTypeMap.put(type, otype);
        simpleOpenTypeMap.put(otype, type);
    }

    public static Class getJavaClass(OpenType ot) {
        if (ot instanceof SimpleType) {
            SimpleType st = (SimpleType)ot;
            return (Class)simpleOpenTypeMap.get(st);
        }
        if (ot instanceof ArrayType) {
            ArrayType at = (ArrayType)ot;
            OpenType<?> cot = at.getElementOpenType();
            Class cjt = TypeConverterImpl.getJavaClass(cot);
            Object temp = Array.newInstance(cjt, 0);
            return temp.getClass();
        }
        if (ot instanceof TabularData) {
            return TabularData.class;
        }
        if (ot instanceof CompositeData) {
            return CompositeData.class;
        }
        throw new IllegalArgumentException("Unsupported OpenType " + ot);
    }

    public static Class getJavaClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type ctype = gat.getGenericComponentType();
            Class cclass = TypeConverterImpl.getJavaClass(ctype);
            Object temp = Array.newInstance(cclass, 0);
            return temp.getClass();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rpt = pt.getRawType();
            return (Class)rpt;
        }
        throw new IllegalArgumentException(type + " cannot be converted into a Java class");
    }

    public static TypeConverter makeTypeConverter(Type type, ManagedObjectManager mom) {
        OpenType stype = simpleTypeMap.get(type);
        if (stype != null) {
            return TypeConverterImpl.handleSimpleType((Class)type, mom, stype);
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            ManagedObject mo = cls.getAnnotation(ManagedObject.class);
            ManagedData md = cls.getAnnotation(ManagedData.class);
            if (mo != null) {
                return TypeConverterImpl.handleManagedObject(cls, mom, mo);
            }
            if (md != null) {
                return TypeConverterImpl.handleManagedData(cls, mom, md);
            }
            if (cls.isEnum()) {
                return TypeConverterImpl.handleEnum(cls, mom);
            }
            return TypeConverterImpl.handleAsString(cls, mom);
        }
        if (type instanceof ParameterizedType) {
            return TypeConverterImpl.handleParameterizedType((ParameterizedType)type, mom);
        }
        if (type instanceof GenericArrayType) {
            return TypeConverterImpl.handleArrayType((GenericArrayType)type, mom);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("TypeVariable " + type + " not supported");
        }
        if (type instanceof WildcardType) {
            throw new IllegalArgumentException("WildcardType " + type + " not supported");
        }
        throw new IllegalArgumentException("Unknown kind of Type " + type);
    }

    private static TypeConverter handleManagedObject(Class type, final ManagedObjectManager mom, ManagedObject mo) {
        return new TypeConverterImpl(type, SimpleType.OBJECTNAME){

            @Override
            public Object toManagedEntity(Object obj) {
                return mom.getObjectName(obj);
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (!(entity instanceof ObjectName)) {
                    throw new IllegalArgumentException("Management entity " + entity + " is not an ObjectName");
                }
                ObjectName oname = (ObjectName)entity;
                return mom.getObject(oname);
            }
        };
    }

    private static TypeConverter handleArrayType(GenericArrayType type, ManagedObjectManager mom) {
        final Type ctype = type.getGenericComponentType();
        final TypeConverter ctypeTc = mom.getTypeConverter(ctype);
        final OpenType cotype = ctypeTc.getManagedType();
        ArrayType ot = null;
        try {
            ot = new ArrayType(1, cotype);
        }
        catch (OpenDataException exc) {
            throw new IllegalArgumentException("Arrays of arrays not supported: " + cotype, exc);
        }
        ArrayType myManagedType = ot;
        return new TypeConverterImpl(type, myManagedType){

            @Override
            public Object toManagedEntity(Object obj) {
                if (this.isIdentity()) {
                    return obj;
                }
                Class cclass = 2.getJavaClass(ctype);
                int length = Array.getLength(obj);
                Object result = Array.newInstance(cclass, length);
                for (int ctr = 0; ctr < length; ++ctr) {
                    Object elem = Array.get(obj, ctr);
                    Object relem = ctypeTc.toManagedEntity(elem);
                    Array.set(result, ctr, relem);
                }
                return result;
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (this.isIdentity()) {
                    return entity;
                }
                Class cclass = 2.getJavaClass(cotype);
                int length = Array.getLength(entity);
                Object result = Array.newInstance(cclass, length);
                for (int ctr = 0; ctr < length; ++ctr) {
                    Object elem = Array.get(entity, ctr);
                    Object relem = ctypeTc.fromManagedEntity(elem);
                    Array.set(result, ctr, relem);
                }
                return result;
            }

            @Override
            public boolean isIdentity() {
                return ctypeTc.isIdentity();
            }
        };
    }

    private static TypeConverter handleEnum(final Class cls, ManagedObjectManager mom) {
        return new TypeConverterImpl(cls, SimpleType.STRING){

            @Override
            public Object toManagedEntity(Object obj) {
                return obj.toString();
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (!(entity instanceof String)) {
                    throw new IllegalArgumentException(entity + " is not a String");
                }
                return Enum.valueOf(cls, (String)entity);
            }
        };
    }

    private static TypeConverter handleAsString(final Class cls, ManagedObjectManager mom) {
        Constructor cs = null;
        try {
            cs = cls.getDeclaredConstructor(String.class);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error in obtaining (String) constructor for " + cls, exc);
        }
        final Constructor cons = cs;
        return new TypeConverterImpl(cls, SimpleType.STRING){

            @Override
            public Object toManagedEntity(Object obj) {
                return obj.toString();
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (cons != null) {
                    try {
                        String str = (String)entity;
                        return cons.newInstance(str);
                    }
                    catch (Exception exc) {
                        throw new IllegalArgumentException("Error in converting from String to " + cls, exc);
                    }
                }
                throw new UnsupportedOperationException("There is no <init>(String) constructor available to convert a String into a " + cls);
            }
        };
    }

    private static TypeConverter handleSimpleType(Class cls, ManagedObjectManager mom, OpenType stype) {
        return new TypeConverterImpl(cls, stype){

            @Override
            public Object toManagedEntity(Object obj) {
                return obj;
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                return entity;
            }

            @Override
            public boolean isIdentity() {
                return true;
            }
        };
    }

    private static List<AnnotationUtil.MethodInfo> analyzeManagedData(Class<?> cls, ManagedObjectManager mom) {
        IncludeSubclass is;
        ArrayList<AnnotationUtil.MethodInfo> minfos = new ArrayList<AnnotationUtil.MethodInfo>();
        InheritedAttribute[] ias = AnnotationUtil.getInheritedAttributes(cls);
        if (ias != null) {
            for (InheritedAttribute attr : ias) {
                String name = attr.id();
                String desc = attr.description();
                Method getter = AnnotationUtil.getGetterMethod(cls.getSuperclass(), name);
                AnnotationUtil.MethodInfo minfo = new AnnotationUtil.MethodInfo(mom, getter, name, desc);
                minfos.add(minfo);
            }
        }
        if ((is = cls.getAnnotation(IncludeSubclass.class)) != null) {
            for (Class klass : is.cls()) {
                List<AnnotationUtil.MethodInfo> klassInfos = TypeConverterImpl.analyzeManagedData(klass, mom);
                minfos.addAll(klassInfos);
            }
        }
        List<Method> attributes = AnnotationUtil.getAnnotatedMethods(cls, ManagedAttribute.class);
        for (Method m : attributes) {
            AnnotationUtil.MethodInfo minfo = new AnnotationUtil.MethodInfo(mom, m);
            if (minfo.atype() == AnnotationUtil.AttributeType.GETTER) {
                minfos.add(minfo);
                continue;
            }
            throw new IllegalArgumentException("Method " + m + " is an illegal setter in a @ManagedData class");
        }
        return minfos;
    }

    private static CompositeType makeCompositeType(Class cls, ManagedData md, List<AnnotationUtil.MethodInfo> minfos) {
        String name = md.name();
        if (name.equals("")) {
            name = cls.getName();
        }
        String mdDescription = md.description();
        int length = minfos.size();
        String[] attrNames = new String[length];
        String[] attrDescriptions = new String[length];
        OpenType[] attrOTypes = new OpenType[length];
        int ctr = 0;
        for (AnnotationUtil.MethodInfo minfo : minfos) {
            attrNames[ctr] = minfo.id();
            attrDescriptions[ctr] = minfo.description();
            attrOTypes[ctr] = minfo.tc().getManagedType();
            ++ctr;
        }
        try {
            return new CompositeType(name, mdDescription, attrNames, attrDescriptions, attrOTypes);
        }
        catch (OpenDataException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    private static TypeConverter handleManagedData(Class cls, ManagedObjectManager mom, ManagedData md) {
        final List<AnnotationUtil.MethodInfo> minfos = TypeConverterImpl.analyzeManagedData(cls, mom);
        final CompositeType myType = TypeConverterImpl.makeCompositeType(cls, md, minfos);
        return new TypeConverterImpl(cls, myType){

            @Override
            public Object toManagedEntity(Object obj) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (AnnotationUtil.MethodInfo minfo : minfos) {
                    if (!minfo.isApplicable(obj)) continue;
                    Object value = minfo.get(obj);
                    data.put(minfo.id(), value);
                }
                try {
                    return new CompositeDataSupport(myType, data);
                }
                catch (OpenDataException exc) {
                    throw new IllegalArgumentException(exc);
                }
            }
        };
    }

    private static TypeConverter handleParameterizedType(ParameterizedType type, ManagedObjectManager mom) {
        TypeConverterImpl result = null;
        Class cls = (Class)type.getRawType();
        Type[] args = type.getActualTypeArguments();
        if (args.length < 1) {
            throw new IllegalArgumentException(cls + " must have at least 1 type argument");
        }
        Type firstType = args[0];
        TypeConverter firstTc = mom.getTypeConverter(firstType);
        if (Iterable.class.isAssignableFrom(cls)) {
            result = new TypeConverterListBase((Type)type, firstTc){

                @Override
                protected Iterator getIterator(Object obj) {
                    return ((Collection)obj).iterator();
                }
            };
        } else if (Iterator.class.isAssignableFrom(cls)) {
            result = new TypeConverterListBase((Type)type, firstTc){

                @Override
                protected Iterator getIterator(Object obj) {
                    return (Iterator)obj;
                }
            };
        } else if (Enumeration.class.isAssignableFrom(cls)) {
            result = new TypeConverterListBase((Type)type, firstTc){

                @Override
                protected Iterator getIterator(Object obj) {
                    return new EnumerationAdapter((Enumeration)obj);
                }
            };
        } else {
            if (args.length != 2) {
                throw new IllegalArgumentException(cls + " must have 2 type arguments");
            }
            Type secondType = args[0];
            TypeConverter secondTc = mom.getTypeConverter(secondType);
            if (Map.class.isAssignableFrom(cls)) {
                result = new TypeConverterMapBase(type, firstTc, secondTc){

                    @Override
                    protected Table getTable(Object obj) {
                        return new TableMapImpl((Map)obj);
                    }
                };
            } else if (Dictionary.class.isAssignableFrom(cls)) {
                result = new TypeConverterMapBase(type, firstTc, secondTc){

                    @Override
                    protected Table getTable(Object obj) {
                        return new TableDictionaryImpl((Dictionary)obj);
                    }
                };
            } else {
                throw new IllegalArgumentException(type + " is not supported");
            }
        }
        return result;
    }

    protected TypeConverterImpl(Type dataType, OpenType managedType) {
        this.dataType = dataType;
        this.managedType = managedType;
    }

    @Override
    public final Type getDataType() {
        return this.dataType;
    }

    @Override
    public final OpenType getManagedType() {
        return this.managedType;
    }

    @Override
    public abstract Object toManagedEntity(Object var1);

    @Override
    public Object fromManagedEntity(Object entity) {
        throw new UnsupportedOperationException("Converting from managed type " + this.managedType + " to java type " + this.dataType + " is not supported.");
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    static {
        TypeConverterImpl.initMaps(Boolean.TYPE, SimpleType.BOOLEAN);
        TypeConverterImpl.initMaps(Boolean.class, SimpleType.BOOLEAN);
        TypeConverterImpl.initMaps(Character.TYPE, SimpleType.CHARACTER);
        TypeConverterImpl.initMaps(Character.class, SimpleType.CHARACTER);
        TypeConverterImpl.initMaps(Byte.TYPE, SimpleType.BYTE);
        TypeConverterImpl.initMaps(Byte.class, SimpleType.BYTE);
        TypeConverterImpl.initMaps(Short.TYPE, SimpleType.SHORT);
        TypeConverterImpl.initMaps(Short.class, SimpleType.SHORT);
        TypeConverterImpl.initMaps(Integer.TYPE, SimpleType.INTEGER);
        TypeConverterImpl.initMaps(Integer.class, SimpleType.INTEGER);
        TypeConverterImpl.initMaps(Long.TYPE, SimpleType.LONG);
        TypeConverterImpl.initMaps(Long.class, SimpleType.LONG);
        TypeConverterImpl.initMaps(Float.TYPE, SimpleType.FLOAT);
        TypeConverterImpl.initMaps(Float.class, SimpleType.FLOAT);
        TypeConverterImpl.initMaps(Double.TYPE, SimpleType.DOUBLE);
        TypeConverterImpl.initMaps(Double.class, SimpleType.DOUBLE);
        TypeConverterImpl.initMaps(String.class, SimpleType.STRING);
        TypeConverterImpl.initMaps(Void.TYPE, SimpleType.VOID);
        TypeConverterImpl.initMaps(Date.class, SimpleType.DATE);
        TypeConverterImpl.initMaps(ObjectName.class, SimpleType.OBJECTNAME);
        TypeConverterImpl.initMaps(BigDecimal.class, SimpleType.BIGDECIMAL);
        TypeConverterImpl.initMaps(BigInteger.class, SimpleType.BIGINTEGER);
    }

    private static class EnumerationAdapter<T>
    implements Iterator<T> {
        private final Enumeration<T> enumeration;

        public EnumerationAdapter(Enumeration<T> en) {
            this.enumeration = en;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    private static interface Table<K, V>
    extends Iterable<K> {
        public V get(K var1);
    }

    private static class TableDictionaryImpl<K, V>
    implements Table<K, V> {
        private final Dictionary<K, V> dict;

        public TableDictionaryImpl(Dictionary<K, V> dict) {
            this.dict = dict;
        }

        @Override
        public Iterator<K> iterator() {
            return new EnumerationAdapter<V>(this.dict.elements());
        }

        @Override
        public V get(K key) {
            return this.dict.get(key);
        }
    }

    private static class TableMapImpl<K, V>
    implements Table<K, V> {
        private final Map<K, V> map;

        public TableMapImpl(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }
    }

    private static abstract class TypeConverterListBase
    extends TypeConverterImpl {
        final TypeConverter memberTc;

        public TypeConverterListBase(Type dataType, TypeConverter memberTc) {
            super(dataType, TypeConverterListBase.makeArrayType(memberTc.getManagedType()));
            this.memberTc = memberTc;
        }

        private static ArrayType makeArrayType(OpenType ot) {
            try {
                return new ArrayType(1, ot);
            }
            catch (OpenDataException exc) {
                throw new IllegalArgumentException(ot + " caused an OpenType exception", exc);
            }
        }

        protected abstract Iterator getIterator(Object var1);

        @Override
        public Object toManagedEntity(Object obj) {
            Iterator iter = this.getIterator(obj);
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            Class cclass = TypeConverterListBase.getJavaClass(this.memberTc.getManagedType());
            Object result = Array.newInstance(cclass, list.size());
            int ctr = 0;
            for (Object elem : list) {
                Object mappedElem = this.memberTc.toManagedEntity(elem);
                Array.set(result, ctr++, mappedElem);
            }
            return result;
        }
    }

    private static abstract class TypeConverterMapBase
    extends TypeConverterImpl {
        private final TypeConverter keyTypeConverter;
        private final TypeConverter valueTypeConverter;

        public TypeConverterMapBase(Type dataType, TypeConverter keyTypeConverter, TypeConverter valueTypeConverter) {
            super(dataType, TypeConverterMapBase.makeMapTabularType(keyTypeConverter, valueTypeConverter));
            this.keyTypeConverter = keyTypeConverter;
            this.valueTypeConverter = valueTypeConverter;
        }

        private static TabularType makeMapTabularType(TypeConverter firstTc, TypeConverter secondTc) {
            String mapType = firstTc + "->" + secondTc;
            String[] itemNames = new String[]{"key", "value"};
            String description = "row type for " + mapType;
            String[] itemDescriptions = new String[]{"Key of map " + mapType, "Value of map " + mapType};
            OpenType[] itemTypes = new OpenType[]{firstTc.getManagedType(), secondTc.getManagedType()};
            try {
                CompositeType rowType = new CompositeType(mapType, "Row type for map " + mapType, itemNames, itemDescriptions, itemTypes);
                String[] keys = new String[]{"key"};
                TabularType result = new TabularType("Table:" + mapType, "Table for map " + mapType, rowType, keys);
                return result;
            }
            catch (OpenDataException exc) {
                throw new IllegalArgumentException(exc);
            }
        }

        protected abstract Table getTable(Object var1);

        @Override
        public Object toManagedEntity(Object obj) {
            try {
                Table table = this.getTable(obj);
                TabularType ttype = (TabularType)this.getManagedType();
                CompositeType ctype = ttype.getRowType();
                TabularDataSupport result = new TabularDataSupport(ttype);
                for (Object key : table) {
                    Object value = table.get(key);
                    Object mappedKey = this.keyTypeConverter.toManagedEntity(key);
                    Object mappedValue = this.valueTypeConverter.toManagedEntity(value);
                    HashMap<String, Object> items = new HashMap<String, Object>();
                    items.put("key", mappedKey);
                    items.put("value", mappedValue);
                    CompositeDataSupport cdata = new CompositeDataSupport(ctype, items);
                    result.put(cdata);
                }
                return result;
            }
            catch (OpenDataException exc) {
                throw new IllegalArgumentException(exc);
            }
        }
    }
}

