/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.argparser;

import com.sun.corba.ee.spi.orbutil.argparser.DefaultValue;
import com.sun.corba.ee.spi.orbutil.argparser.ElementParser;
import com.sun.corba.ee.spi.orbutil.argparser.Help;
import com.sun.corba.ee.spi.orbutil.argparser.Separator;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgParser<T> {
    private Class<T> interfaceClass;
    private Map<String, String> helpText;
    private Map<String, Object> defaultValues;
    private Map<String, ElementParser> parserData;

    public ArgParser(Class<T> cls) {
        if (!cls.isInterface()) {
            this.error(cls.getName() + " is not an interface");
        }
        this.interfaceClass = cls;
        this.parserData = new HashMap<String, ElementParser>();
        this.helpText = new HashMap<String, String>();
        HashMap<String, String> defaultValueData = new HashMap<String, String>();
        for (Method m : this.interfaceClass.getMethods()) {
            String keyword = this.checkMethod(m);
            ElementParser ep = ElementParser.factory.evaluate(m);
            this.parserData.put(keyword, ep);
            DefaultValue dv = m.getAnnotation(DefaultValue.class);
            if (dv == null) {
                this.error("Method " + m.getName() + " does not have a DefaultValue annotation");
            } else {
                defaultValueData.put(keyword, dv.value());
            }
            Help help = m.getAnnotation(Help.class);
            if (help == null) continue;
            this.helpText.put(keyword, help.value());
        }
        this.defaultValues = this.internalParse(defaultValueData);
    }

    private String display(Object obj) {
        if (obj.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int ctr = 0; ctr < Array.getLength(obj); ++ctr) {
                Object element = Array.get(obj, ctr);
                if (ctr > 0) {
                    sb.append(",");
                }
                sb.append(element.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        if (obj instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object element : (Collection)obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(element.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public String getHelpText() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Legal arguments are:\n");
        Set<String> keys = this.parserData.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        for (String keyword : keyList) {
            ElementParser ep = this.parserData.get(keyword);
            sb.append("\t-" + keyword + " <");
            boolean first = true;
            for (String str : ep.describe()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n\t    ");
                }
                sb.append(str);
            }
            sb.append(">\n");
            String defaultValue = this.display(this.defaultValues.get(keyword));
            sb.append("\t    (default " + defaultValue + ")\n");
            String help = this.helpText.get(keyword);
            if (help != null) {
                sb.append("\t    " + help + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public T parse(String[] args) {
        Map<String, String> data = this.makeMap(args);
        Map<String, Object> pdata = this.internalParse(data);
        T result = this.makeProxy(pdata, this.defaultValues);
        return result;
    }

    private void error(String msg) {
        System.out.println("Error in argument parser: " + msg);
        System.out.println(this.getHelpText());
        throw new RuntimeException(msg);
    }

    private String checkMethod(Method m) {
        if (m.getParameterTypes().length == 0) {
            return m.getName();
        }
        this.error("Method " + m.getName() + " must not have any parameters");
        return null;
    }

    private Map<String, Object> internalParse(Map<String, String> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String keyword = entry.getKey();
            ElementParser ep = this.parserData.get(keyword);
            if (ep == null) {
                this.error(keyword + " is not a valid keyword");
            }
            Object val = ep.evaluate(entry.getValue());
            result.put(keyword, val);
        }
        return result;
    }

    private String getKeyword(String arg) {
        if (arg.charAt(0) == '-') {
            return arg.substring(1);
        }
        this.error(arg + " is not a valid keyword");
        return null;
    }

    private Map<String, String> makeMap(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String keyword = null;
        for (String arg : args) {
            if (keyword == null) {
                keyword = this.getKeyword(arg);
                continue;
            }
            result.put(keyword, arg);
            keyword = null;
        }
        if (keyword != null) {
            this.error("No argument supplied for keyword " + keyword);
        }
        return result;
    }

    private T makeProxy(final Map<String, Object> data, final Map<String, Object> defaultData) {
        InvocationHandler ih = new InvocationHandler(){

            private Object getValue(String keyword) {
                Object result = data.get(keyword);
                if (result == null) {
                    result = defaultData.get(keyword);
                }
                return result;
            }

            private String getString(Object obj) {
                Class<?> cls = obj.getClass();
                if (cls.isArray()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    for (int ctr = 0; ctr < Array.getLength(obj); ++ctr) {
                        if (ctr > 0) {
                            sb.append(",");
                        }
                        Object element = Array.get(obj, ctr);
                        sb.append(element.toString());
                    }
                    sb.append("]");
                    return sb.toString();
                }
                return obj.toString();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String name = method.getName();
                if (name == "toString") {
                    StringBuilder sb = new StringBuilder();
                    for (String keyword : ArgParser.this.parserData.keySet()) {
                        sb.append(keyword);
                        sb.append("=");
                        sb.append(this.getString(this.getValue(keyword)));
                        sb.append("\n");
                    }
                    return sb.toString();
                }
                return this.getValue(name);
            }
        };
        Class[] interfaces = new Class[]{this.interfaceClass};
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, ih));
    }

    public static void main(String[] args) {
        ArgParser<TestInterface> ap = new ArgParser<TestInterface>(TestInterface.class);
        System.out.println("Help text for this parser:\n" + ap.getHelpText());
        TestInterface result = ap.parse(args);
        System.out.println("Result is:\n" + result);
    }

    private static interface TestInterface {
        @DefaultValue(value="27")
        @Help(value="An integer value")
        public int value();

        @DefaultValue(value="Michigan")
        @Help(value="The name of a lake")
        public String lake();

        @DefaultValue(value="RED")
        @Help(value="Pick a color")
        public PrimaryColor color();

        @DefaultValue(value="http://www.sun.com")
        @Help(value="your favorite URL")
        public URL url();

        @DefaultValue(value="funny:thing,another:thing,something:else")
        @Help(value="A list of pairs of the form xxx:yyy")
        @Separator(value=",")
        public StringPair[] arrayData();

        @DefaultValue(value="funny:thing,another:thing,something:else")
        @Help(value="A list of pairs of the form xxx:yyy")
        @Separator(value=",")
        public List<StringPair> listData();
    }

    public static class StringPair
    extends Pair<String, String> {
        public StringPair(String data) {
            super(null, null);
            int index = data.indexOf(58);
            if (index < 0) {
                throw new IllegalArgumentException(data + " does not contain a :");
            }
            this.first = data.substring(0, index);
            this.second = data.substring(index + 1);
        }
    }

    private static enum PrimaryColor {
        RED,
        GREEN,
        BLUE;

    }
}

