/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.file;

import com.sun.corba.ee.spi.orbutil.argparser.ArgParser;
import com.sun.corba.ee.spi.orbutil.argparser.DefaultValue;
import com.sun.corba.ee.spi.orbutil.argparser.Help;
import com.sun.corba.ee.spi.orbutil.file.ActionFactory;
import com.sun.corba.ee.spi.orbutil.file.Block;
import com.sun.corba.ee.spi.orbutil.file.BlockParser;
import com.sun.corba.ee.spi.orbutil.file.FileWrapper;
import com.sun.corba.ee.spi.orbutil.file.Recognizer;
import com.sun.corba.ee.spi.orbutil.file.Scanner;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class CopyrightProcessor {
    private static boolean validate;
    private static int verbose;
    private static final String[] JAVA_LIKE_SUFFIXES;
    private static final String JAVA_COMMENT_START = "/*";
    private static final String JAVA_COMMENT_PREFIX = " *";
    private static final String JAVA_COMMENT_END = "*/";
    private static final String[] XML_LIKE_SUFFIXES;
    private static final String XML_COMMENT_START = "<!--";
    private static final String XML_COMMENT_PREFIX = " ";
    private static final String XML_COMMENT_END = "-->";
    private static final String[] JAVA_LINE_LIKE_SUFFIXES;
    private static final String JAVA_LINE_PREFIX = "// ";
    private static final String[] SCHEME_LIKE_SUFFIXES;
    private static final String SCHEME_PREFIX = "; ";
    private static final String[] SHELL_SCRIPT_LIKE_SUFFIXES;
    private static final String[] SHELL_LIKE_SUFFIXES;
    private static final String SHELL_PREFIX = "# ";
    private static final String[] MAKEFILE_NAMES;
    private static final String[] BINARY_LIKE_SUFFIXES;
    private static final String[] IGNORE_FILE_NAMES;
    private static final String COPYRIGHT_BLOCK_TAG = "CopyrightBlock";
    private static final String SUN_COPYRIGHT_TAG = "SunCopyright";
    private static final String CORRECT_COPYRIGHT_TAG = "CorrectCopyright";
    private static final String JAVA_FORMAT_TAG = "JavaFormat";
    private static final String JAVA_LINE_FORMAT_TAG = "JavaLineFormat";
    private static final String XML_FORMAT_TAG = "XmlFormat";
    private static final String SCHEME_FORMAT_TAG = "SchemeFormat";
    private static final String SHELL_FORMAT_TAG = "ShellFormat";
    private static final String COPYRIGHT = "Copyright";
    private static final String START_YEAR = "StartYear";

    private CopyrightProcessor() {
    }

    private static void trace(String msg) {
        System.out.println(msg);
    }

    private static Block makeCopyrightLineCommentBlock(Block copyrightText, String prefix, String tag) {
        Block result = new Block(copyrightText);
        result.addPrefixToAll(prefix);
        result.addTag(tag);
        result.addTag(CORRECT_COPYRIGHT_TAG);
        return result;
    }

    private static Block makeCopyrightBlockCommentBlock(Block copyrightText, String start, String prefix, String end, String tag) {
        Block result = new Block(copyrightText);
        result.addPrefixToAll(prefix);
        result.addBeforeFirst(start);
        result.addAfterLast(end);
        result.addTag(tag);
        result.addTag(CORRECT_COPYRIGHT_TAG);
        return result;
    }

    private static String getSunCopyrightStart(String str) {
        int index = str.indexOf(COPYRIGHT);
        if (index == -1) {
            return null;
        }
        int pos = index + COPYRIGHT.length();
        char ch = str.charAt(pos);
        while (Character.isWhitespace(ch) && pos < str.length()) {
            ch = str.charAt(++pos);
        }
        int start = pos;
        ch = str.charAt(pos);
        while (Character.isDigit(ch) && pos < str.length()) {
            ch = str.charAt(++pos);
        }
        if (pos == start) {
            return null;
        }
        return str.substring(start, pos);
    }

    private static Block makeCopyrightBlock(String startYear, Block copyrightText) throws IOException {
        if (verbose > 1) {
            CopyrightProcessor.trace("makeCopyrightBlock: startYear = " + startYear);
            CopyrightProcessor.trace("makeCopyrightBlock: copyrightText = " + copyrightText);
            CopyrightProcessor.trace("Contents of copyrightText block:");
            for (String str : copyrightText.contents()) {
                CopyrightProcessor.trace("\t" + str);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(START_YEAR, startYear);
        Block withStart = copyrightText.instantiateTemplate(map);
        if (verbose > 1) {
            CopyrightProcessor.trace("Contents of copyrightText block withStart date:");
            for (String str : withStart.contents()) {
                CopyrightProcessor.trace("\t" + str);
            }
        }
        return withStart;
    }

    private static BlockParserCall makeBlockCommentParser(final String start, final String end) {
        return new BlockParserCall(){

            public String toString() {
                return "BlockCommentBlockParserCall[start=," + start + ",end=" + end + "]";
            }

            @Override
            public List<Block> evaluate(FileWrapper fw) {
                try {
                    return BlockParser.parseBlocks(fw, start, end);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
        };
    }

    private static BlockParserCall makeLineCommentParser(final String prefix) {
        return new BlockParserCall(){

            public String toString() {
                return "LineCommentBlockParserCall[prefix=," + prefix + "]";
            }

            @Override
            public List<Block> evaluate(FileWrapper fw) {
                try {
                    return BlockParser.parseBlocks(fw, prefix);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
        };
    }

    private static void validationError(Block block, String msg, FileWrapper fw) {
        CopyrightProcessor.trace("Copyright validation error: " + msg + " for " + fw);
        if (verbose > 0 && block != null) {
            CopyrightProcessor.trace("Block=" + block);
            CopyrightProcessor.trace("Block contents:");
            for (String str : block.contents()) {
                CopyrightProcessor.trace("\"" + str + "\"");
            }
        }
    }

    private static Scanner.Action makeCopyrightBlockAction(final Block copyrightText, final BlockParserCall parserCall, final String defaultStartYear, final boolean afterFirstBlock) {
        if (verbose > 0) {
            CopyrightProcessor.trace("makeCopyrightBlockAction: copyrightText = " + copyrightText);
            CopyrightProcessor.trace("makeCopyrightBlockAction: parserCall = " + parserCall);
            CopyrightProcessor.trace("makeCopyrightBlockAction: defaultStartYear = " + defaultStartYear);
            CopyrightProcessor.trace("makeCopyrightBlockAction: afterFirstBlock = " + afterFirstBlock);
        }
        return new Scanner.Action(){

            public String toString() {
                return "CopyrightBlockAction[copyrightText=" + copyrightText + ",parserCall=" + parserCall + ",defaultStartYear=" + defaultStartYear + ",afterFirstBlock=" + afterFirstBlock + "]";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean evaluate(FileWrapper fw) {
                try {
                    String startYear = defaultStartYear;
                    boolean hadAnOldSunCopyright = false;
                    List fileBlocks = (List)parserCall.evaluate(fw);
                    for (Block block : fileBlocks) {
                        String str = block.find(CopyrightProcessor.COPYRIGHT);
                        if (str == null) continue;
                        block.addTag(CopyrightProcessor.COPYRIGHT_BLOCK_TAG);
                        if (!str.contains("Sun")) continue;
                        startYear = CopyrightProcessor.getSunCopyrightStart(str);
                        block.addTag(CopyrightProcessor.SUN_COPYRIGHT_TAG);
                        hadAnOldSunCopyright = true;
                    }
                    if (verbose > 1) {
                        CopyrightProcessor.trace("copyrightBlockAction: blocks in file " + fw);
                        for (Block block : fileBlocks) {
                            CopyrightProcessor.trace("\t" + block);
                            for (String str : block.contents()) {
                                CopyrightProcessor.trace("\t\t" + str);
                            }
                        }
                    }
                    Block cb = CopyrightProcessor.makeCopyrightBlock(startYear, copyrightText);
                    if (validate) {
                        int count = 0;
                        for (Block block : fileBlocks) {
                            if (!afterFirstBlock && count == 0) {
                                if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock")) {
                                    if (!cb.equals(block)) {
                                        CopyrightProcessor.validationError(block, "First block has incorrect copyright text", fw);
                                    }
                                } else {
                                    CopyrightProcessor.validationError(block, "First block should be copyright but isn't", fw);
                                }
                                boolean bl = true;
                                return bl;
                            }
                            if (afterFirstBlock && count == 1) {
                                if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock")) {
                                    if (!cb.equals(block)) {
                                        CopyrightProcessor.validationError(block, "Second block has incorrect copyright text", fw);
                                    }
                                } else {
                                    CopyrightProcessor.validationError(block, "Second block should be copyright but isn't", fw);
                                }
                                boolean bl = true;
                                return bl;
                            }
                            if (count > 1) {
                                CopyrightProcessor.validationError(null, "Neither first nor second block checked", fw);
                                boolean bl = false;
                                return bl;
                            }
                            ++count;
                        }
                    } else if (fw.canWrite()) {
                        CopyrightProcessor.trace("Updating copyright/license header on file " + fw);
                        fw.delete();
                        fw.open(FileWrapper.OpenMode.WRITE);
                        boolean firstMatch = true;
                        boolean firstBlock = true;
                        for (Block block : fileBlocks) {
                            if (!hadAnOldSunCopyright && firstBlock) {
                                if (afterFirstBlock) {
                                    block.write(fw);
                                    cb.write(fw);
                                } else {
                                    cb.write(fw);
                                    block.write(fw);
                                }
                                firstBlock = false;
                                continue;
                            }
                            if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock") && firstMatch) {
                                firstMatch = false;
                                if (!hadAnOldSunCopyright) continue;
                                cb.write(fw);
                                continue;
                            }
                            block.write(fw);
                        }
                    } else if (verbose > 1) {
                        CopyrightProcessor.trace("Skipping file " + fw + " because is is not writable");
                    }
                }
                catch (IOException exc) {
                    CopyrightProcessor.trace("Exception while processing file " + fw + ": " + exc);
                    exc.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    fw.close();
                }
                return true;
            }
        };
    }

    public static void main(String[] strs) {
        ArgParser<Arguments> ap = new ArgParser<Arguments>(Arguments.class);
        Arguments args = ap.parse(strs);
        String startYear = args.startyear();
        verbose = args.verbose();
        validate = args.validate();
        if (verbose > 0) {
            CopyrightProcessor.trace("Main: args:\n" + args);
        }
        try {
            Block copyrightText = BlockParser.getBlock(args.copyright());
            Block javaCopyrightText = CopyrightProcessor.makeCopyrightBlockCommentBlock(copyrightText, JAVA_COMMENT_START, JAVA_COMMENT_PREFIX, " */", JAVA_FORMAT_TAG);
            Block xmlCopyrightText = CopyrightProcessor.makeCopyrightBlockCommentBlock(copyrightText, XML_COMMENT_START, XML_COMMENT_PREFIX, XML_COMMENT_END, XML_FORMAT_TAG);
            Block javaLineCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, JAVA_LINE_PREFIX, JAVA_LINE_FORMAT_TAG);
            Block schemeCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, SCHEME_PREFIX, SCHEME_FORMAT_TAG);
            Block shellCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, SHELL_PREFIX, SHELL_FORMAT_TAG);
            if (verbose > 0) {
                CopyrightProcessor.trace("Main: copyrightText = " + copyrightText);
                CopyrightProcessor.trace("Main: javaCopyrightText = " + javaCopyrightText);
                CopyrightProcessor.trace("Main: xmlCopyrightText = " + xmlCopyrightText);
                CopyrightProcessor.trace("Main: javaLineCopyrightText = " + javaLineCopyrightText);
                CopyrightProcessor.trace("Main: schemeCopyrightText = " + schemeCopyrightText);
                CopyrightProcessor.trace("Main: shellCopyrightText = " + shellCopyrightText);
            }
            ActionFactory af = new ActionFactory(args.verbose(), args.dryrun());
            Recognizer recognizer = af.getRecognizerAction();
            BlockParserCall javaBlockParserCall = CopyrightProcessor.makeBlockCommentParser(JAVA_COMMENT_START, JAVA_COMMENT_END);
            BlockParserCall xmlBlockParserCall = CopyrightProcessor.makeBlockCommentParser(XML_COMMENT_START, XML_COMMENT_END);
            BlockParserCall javaLineParserCall = CopyrightProcessor.makeLineCommentParser(JAVA_LINE_PREFIX);
            BlockParserCall schemeLineParserCall = CopyrightProcessor.makeLineCommentParser(SCHEME_PREFIX);
            BlockParserCall shellLineParserCall = CopyrightProcessor.makeLineCommentParser(SHELL_PREFIX);
            Scanner.Action skipAction = af.getSkipAction();
            Scanner.Action javaAction = CopyrightProcessor.makeCopyrightBlockAction(javaCopyrightText, javaBlockParserCall, startYear, false);
            Scanner.Action xmlAction = CopyrightProcessor.makeCopyrightBlockAction(xmlCopyrightText, xmlBlockParserCall, startYear, true);
            Scanner.Action schemeAction = CopyrightProcessor.makeCopyrightBlockAction(schemeCopyrightText, schemeLineParserCall, startYear, false);
            Scanner.Action javaLineAction = CopyrightProcessor.makeCopyrightBlockAction(javaLineCopyrightText, javaLineParserCall, startYear, false);
            Scanner.Action shellAction = CopyrightProcessor.makeCopyrightBlockAction(shellCopyrightText, shellLineParserCall, startYear, false);
            Scanner.Action shellScriptAction = CopyrightProcessor.makeCopyrightBlockAction(shellCopyrightText, shellLineParserCall, startYear, true);
            for (String str : JAVA_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, javaAction);
            }
            for (String str : JAVA_LINE_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, javaLineAction);
            }
            for (String str : XML_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, xmlAction);
            }
            for (String str : SCHEME_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, schemeAction);
            }
            for (String str : SHELL_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, shellAction);
            }
            for (String str : MAKEFILE_NAMES) {
                recognizer.addKnownName(str, shellAction);
            }
            for (String str : SHELL_SCRIPT_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, shellScriptAction);
            }
            recognizer.setShellScriptAction(shellScriptAction);
            for (String str : BINARY_LIKE_SUFFIXES) {
                recognizer.addKnownSuffix(str, skipAction);
            }
            for (String str : IGNORE_FILE_NAMES) {
                recognizer.addKnownName(str, skipAction);
            }
            if (verbose > 0) {
                CopyrightProcessor.trace("Main: contents of recognizer:");
                recognizer.dump();
            }
            Scanner scanner = new Scanner(verbose, args.roots());
            for (String str : args.skipdirs()) {
                scanner.addDirectoryToSkip(str);
            }
            scanner.scan(recognizer);
        }
        catch (IOException exc) {
            System.out.println("Exception while processing: " + exc);
            exc.printStackTrace();
        }
    }

    static {
        JAVA_LIKE_SUFFIXES = new String[]{"c", "h", "java", "sjava", "idl"};
        XML_LIKE_SUFFIXES = new String[]{"htm", "html", "xml", "dtd"};
        JAVA_LINE_LIKE_SUFFIXES = new String[]{"tdesc", "policy", "secure"};
        SCHEME_LIKE_SUFFIXES = new String[]{"mc", "mcd", "scm", "vthought"};
        SHELL_SCRIPT_LIKE_SUFFIXES = new String[]{"ksh", "sh"};
        SHELL_LIKE_SUFFIXES = new String[]{"classlist", "config", "jmk", "properties", "prp", "xjmk", "set", "data", "txt", "text"};
        MAKEFILE_NAMES = new String[]{"Makefile.corba", "Makefile.example", "ExampleMakefile", "Makefile"};
        BINARY_LIKE_SUFFIXES = new String[]{"bnd", "sxc", "sxi", "sxw", "odp", "gif", "png", "jar", "zip", "jpg", "pom", "pdf", "doc", "mif", "fm", "book", "zargo", "zuml", "cvsignore", "hgignore", "list", "old", "orig", "rej", "swp", "swo", "class", "o", "javaref", "idlref", "css"};
        IGNORE_FILE_NAMES = new String[]{"NORENAME", "errorfile", "sed_pattern_file.version"};
    }

    private static interface BlockParserCall
    extends UnaryFunction<FileWrapper, List<Block>> {
    }

    private static interface Arguments {
        @DefaultValue(value="true")
        @Help(value="Set to true to validate copyright header; if false, generate/update/insert copyright headers as needed")
        public boolean validate();

        @DefaultValue(value="0")
        @Help(value="Set to >0 to get information about actions taken for every file.  Larger values give more detail.")
        public int verbose();

        @DefaultValue(value="true")
        @Help(value="Set to true to avoid modifying any files")
        public boolean dryrun();

        @Help(value="List of directories to process")
        @DefaultValue(value="")
        public List<File> roots();

        @Help(value="List of directory names that should be skipped")
        @DefaultValue(value="")
        public List<String> skipdirs();

        @Help(value="File containing text of copyright header.  This must not include any comment characters")
        @DefaultValue(value="")
        public FileWrapper copyright();

        @DefaultValue(value="1997")
        @Help(value="Default copyright start year, if not otherwise specified")
        public String startyear();
    }
}

