/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.mejb.MEJBUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MEJBBean
implements SessionBean {
    private static final boolean debug = true;
    private volatile SessionContext ctx;
    private final MBeanServer mbeanServer = MEJBUtility.getInstance().getMBeanServer();
    private volatile String mDomain = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    public MEJBBean() {
        MEJBBean.debug("MEJBBean.MEJBBean()");
    }

    public void setSessionContext(SessionContext context) {
        this.ctx = context;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void ejbCreate() throws CreateException {
        ObjectName domainRoot = AMXBooter.bootAMX((MBeanServerConnection)this.mbeanServer);
        this.mDomain = domainRoot.getDomain();
    }

    private Set<ObjectName> restrict(Set<ObjectName> candidates) {
        HashSet<ObjectName> allowed = new HashSet<ObjectName>();
        for (ObjectName candidate : candidates) {
            if (!this.oneOfOurs(candidate)) continue;
            allowed.add(candidate);
        }
        return allowed;
    }

    private boolean oneOfOurs(ObjectName candidate) {
        return candidate != null && candidate.getDomain().equals(this.mDomain) && candidate.getKeyProperty("j2eeType") != null && candidate.getKeyProperty("name") != null;
    }

    private ObjectName bounce(ObjectName o) throws InstanceNotFoundException {
        if (!this.oneOfOurs(o)) {
            throw new InstanceNotFoundException("" + o);
        }
        return o;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws RemoteException {
        try {
            return this.restrict(this.mbeanServer.queryNames(name, query));
        }
        catch (Exception ex) {
            throw new RemoteException(this.toString() + "::queryNames", ex);
        }
    }

    public boolean isRegistered(ObjectName name) throws RemoteException {
        try {
            return this.mbeanServer.isRegistered(name);
        }
        catch (Exception ex) {
            throw new RemoteException(this.toString() + "::isRegistered", ex);
        }
    }

    public Integer getMBeanCount() throws RemoteException {
        try {
            ObjectName pattern = new ObjectName(this.mDomain + ":*");
            return this.queryNames(pattern, null).size();
        }
        catch (Exception ex) {
            throw new RemoteException(this.toString() + "::getMBeanCount", ex);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, RemoteException {
        return this.mbeanServer.getMBeanInfo(this.bounce(name));
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mbeanServer.getAttribute(this.bounce(name), attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mbeanServer.getAttributes(this.bounce(name), attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
        this.mbeanServer.setAttribute(this.bounce(name), attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mbeanServer.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        return this.mbeanServer.invoke(this.bounce(name), operationName, params, signature);
    }

    public String getDefaultDomain() throws RemoteException {
        return this.mDomain;
    }

    public ListenerRegistration getListenerRegistry() throws RemoteException {
        return MEJBUtility.getInstance().getListenerRegistry();
    }
}

