/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.full.deployment.EarClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class EarDeployer
implements Deployer {
    private static final String GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME = "org.glassfish.appclient.client.AppClientGroupFacade";
    private static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    @Inject
    Habitat habitat;
    @Inject
    Deployment deployment;
    @Inject
    ServerEnvironment env;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Events events;
    @Inject
    private DownloadableArtifacts artifacts;
    static final Logger logger = LogDomains.getLogger(EarDeployer.class, (String)"javax.enterprise.system.tools.deployment");

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public Object loadMetaData(Class type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        Application application = (Application)context.getModuleMetaData(Application.class);
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        final CompositeApplicationInfo appInfo = new CompositeApplicationInfo(context.getSource(), appName);
        for (Object m : context.getModuleMetadata()) {
            appInfo.addMetaData(m);
        }
        final Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = this.initSubContext(application, context);
        try {
            this.doOnAllBundles(application, new BundleBlock<ModuleInfo>(){

                @Override
                public ModuleInfo doBundle(ModuleDescriptor bundle) throws Exception {
                    ModuleInfo info = EarDeployer.this.prepareBundle(bundle, (ExtendedDeploymentContext)contextPerModules.get(bundle));
                    appInfo.addModule(info);
                    return info;
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        context.addModuleMetaData((Object)appInfo);
        this.generateArtifacts(context);
        return true;
    }

    protected void generateArtifacts(DeploymentContext context) throws DeploymentException {
        Application application = (Application)context.getModuleMetaData(Application.class);
        Collection appClients = application.getModuleDescriptorsByType(XModuleType.CAR);
        StringBuilder appClientGroupListSB = new StringBuilder();
        for (ModuleDescriptor md : appClients) {
            appClientGroupListSB.append(appClientGroupListSB.length() > 0 ? " " : "").append(this.earDirUserURI(context)).append(this.appClientFacadeUserURI(md.getArchiveUri()));
        }
        try {
            this.generateAndRecordEARFacade(application.getRegistrationName(), context.getScratchDir("xml"), this.generatedEARFacadeName(application.getRegistrationName()), appClientGroupListSB.toString());
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private String earDirUserURI(DeploymentContext dc) {
        DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        return appName + "Client/";
    }

    private String appClientFacadeUserURI(String appClientModuleURIText) {
        if (appClientModuleURIText.endsWith("_jar")) {
            appClientModuleURIText = appClientModuleURIText.substring(0, appClientModuleURIText.lastIndexOf("_jar")) + ".jar";
        }
        int dotJar = appClientModuleURIText.lastIndexOf(".jar");
        String appClientFacadePath = appClientModuleURIText.substring(0, dotJar) + "Client.jar";
        return appClientFacadePath;
    }

    private String generatedEARFacadeName(String earName) {
        return earName + "Client.jar";
    }

    private void generateAndRecordEARFacade(String earName, File appScratchDir, String facadeFileName, String appClientGroupList) throws IOException {
        File generatedJar = new File(appScratchDir, facadeFileName);
        OutputJarArchive facadeArchive = new OutputJarArchive();
        facadeArchive.create(generatedJar.toURI());
        Manifest manifest = facadeArchive.getManifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.put(Attributes.Name.MAIN_CLASS, GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME);
        mainAttrs.put(GLASSFISH_APPCLIENT_GROUP, appClientGroupList);
        OutputStream os = facadeArchive.putNextEntry("META-INF/MANIFEST.MF");
        manifest.write(os);
        facadeArchive.closeEntry();
        String mainClassResourceName = GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME.replace('.', '/') + ".class";
        os = facadeArchive.putNextEntry(mainClassResourceName);
        try {
            InputStream is = this.openByteCodeStream("/" + mainClassResourceName);
            FileUtils.copyStream((InputStream)is, (OutputStream)os);
            is.close();
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        HashSet<DownloadableArtifacts.FullAndPartURIs> downloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
        downloads.add(new DownloadableArtifacts.FullAndPartURIs(generatedJar.toURI(), facadeFileName));
        this.artifacts.addArtifacts(earName, downloads);
    }

    private InputStream openByteCodeStream(String classResourceName) throws URISyntaxException, MalformedURLException, IOException {
        URI currentModule = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        URI classURI = currentModule.resolve("gf-client-module.jar!" + classResourceName);
        return URI.create("jar:" + classURI.toString()).toURL().openStream();
    }

    private Collection<ModuleDescriptor<BundleDescriptor>> doOnAllTypedBundles(Application application, XModuleType type, BundleBlock runnable) throws Exception {
        Collection typedBundles = application.getModuleDescriptorsByType(type);
        for (ModuleDescriptor module : typedBundles) {
            runnable.doBundle(module);
        }
        return typedBundles;
    }

    private void doOnAllBundles(Application application, BundleBlock runnable) throws Exception {
        HashSet bundles = new HashSet();
        bundles.addAll(application.getModules());
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.RAR, runnable));
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.EJB, runnable));
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.WAR, runnable));
        for (ModuleDescriptor bundle : bundles) {
            runnable.doBundle(bundle);
        }
    }

    private ModuleInfo prepareBundle(ModuleDescriptor md, final ExtendedDeploymentContext bundleContext) throws Exception {
        List orderedContainers = null;
        ProgressTracker tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                for (EngineRef module : this.get("prepared", EngineRef.class)) {
                    module.clean(bundleContext, logger);
                }
            }
        };
        try {
            orderedContainers = this.deployment.setupContainerInfos((DeploymentContext)bundleContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.deployment.prepareModule(orderedContainers, md.getArchiveUri(), (DeploymentContext)bundleContext, tracker);
    }

    public ApplicationContainer load(Container container, DeploymentContext context) {
        return null;
    }

    public void unload(ApplicationContainer appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }

    public Map<ModuleDescriptor, ExtendedDeploymentContext> initSubContext(Application application, final DeploymentContext context) {
        HashMap<ModuleDescriptor, ExtendedDeploymentContext> results = new HashMap<ModuleDescriptor, ExtendedDeploymentContext>();
        for (final BundleDescriptor bd : application.getBundleDescriptors()) {
            ReadableArchive subArchive;
            if (results.containsKey(bd.getModuleDescriptor())) continue;
            final String moduleUri = bd.getModuleDescriptor().getArchiveUri();
            try {
                subArchive = context.getSource().getSubArchive(moduleUri);
                subArchive.setParentArchive(context.getSource());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
            final Properties moduleProps = this.getModuleProps(context, moduleUri);
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            DeploymentContextImpl subContext = new DeploymentContextImpl(subReport, logger, context.getSource(), context.getCommandParameters(OpsParams.class), this.env){

                public ClassLoader getClassLoader() {
                    try {
                        EarClassLoader appCl = (EarClassLoader)EarClassLoader.class.cast(context.getClassLoader());
                        return appCl.getModuleClassLoader(moduleUri);
                    }
                    catch (ClassCastException e) {
                        return context.getClassLoader();
                    }
                }

                public ClassLoader getFinalClassLoader() {
                    try {
                        EarClassLoader finalEarCL = (EarClassLoader)context.getFinalClassLoader();
                        return finalEarCL.getModuleClassLoader(moduleUri);
                    }
                    catch (ClassCastException e) {
                        return context.getClassLoader();
                    }
                }

                public ReadableArchive getSource() {
                    return subArchive;
                }

                public Properties getAppProps() {
                    return context.getAppProps();
                }

                public void addTransientAppMetaData(String metaDataKey, Object metaData) {
                    context.addTransientAppMetaData(metaDataKey, metaData);
                }

                public <T> T getTransientAppMetaData(String metaDataKey, Class<T> metadataType) {
                    return (T)context.getTransientAppMetaData(metaDataKey, metadataType);
                }

                public Properties getModuleProps() {
                    return moduleProps;
                }

                public ReadableArchive getOriginalSource() {
                    try {
                        File appRoot = context.getSourceDir();
                        File origModuleFile = new File(appRoot, moduleUri);
                        return EarDeployer.this.archiveFactory.openArchive(origModuleFile);
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }

                public File getScratchDir(String subDirName) {
                    String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                    return new File(super.getScratchDir(subDirName), modulePortion);
                }

                public <T> T getModuleMetaData(Class<T> metadataType) {
                    try {
                        return metadataType.cast(bd);
                    }
                    catch (Exception e) {
                        if (RootDeploymentDescriptor.class.isAssignableFrom(metadataType)) {
                            for (RootDeploymentDescriptor extension : bd.getExtensionsDescriptors(metadataType)) {
                                if (extension == null) continue;
                                try {
                                    return metadataType.cast(extension);
                                }
                                catch (Exception e1) {
                                }
                            }
                        }
                        return (T)context.getModuleMetaData(metadataType);
                    }
                }
            };
            results.put(bd.getModuleDescriptor(), (ExtendedDeploymentContext)subContext);
        }
        return results;
    }

    private Properties getModuleProps(DeploymentContext context, String moduleUri) {
        Map modulePropsMap = context.getModulePropsMap();
        Properties moduleProps = (Properties)modulePropsMap.get(moduleUri);
        if (moduleProps == null) {
            moduleProps = new Properties();
            modulePropsMap.put(moduleUri, moduleProps);
        }
        return moduleProps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BundleBlock<T> {
        public T doBundle(ModuleDescriptor var1) throws Exception;
    }

    private class CompositeApplicationInfo
    extends ApplicationInfo {
        Application application;

        private CompositeApplicationInfo(ReadableArchive source, String name) {
            super(EarDeployer.this.events, source, name);
            this.application = null;
        }

        public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
            context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
            this.application = (Application)context.getModuleMetaData(Application.class);
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.load(contextPerModules.get(md), tracker);
            }
        }

        public void start(DeploymentContext context, ProgressTracker tracker) throws Exception {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.start((DeploymentContext)contextPerModules.get(md), tracker);
            }
        }

        public void unload(ExtendedDeploymentContext context) {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.unload(contextPerModules.get(md));
            }
        }

        public void clean(ExtendedDeploymentContext context) throws Exception {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.clean(contextPerModules.get(md));
            }
        }
    }
}

