/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee.statistics;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import org.glassfish.admin.amx.j2ee.statistics.BoundaryStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.BoundedRangeStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.CountStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.MapGetterInvocationHandler;
import org.glassfish.admin.amx.j2ee.statistics.MapStatistic;
import org.glassfish.admin.amx.j2ee.statistics.MapStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.NumberStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.RangeStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.StatisticFactory;
import org.glassfish.admin.amx.j2ee.statistics.StringStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.TimeStatisticImpl;
import org.glassfish.admin.amx.j2ee.util.J2EEUtil;
import org.glassfish.admin.amx.util.SetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsImpl
extends MapGetterInvocationHandler<Statistic>
implements Stats,
Serializable {
    static final long serialVersionUID = 6228973710059979557L;

    public StatsImpl(CompositeData compositeData) {
        this(StatsImpl.createStatisticsMap(compositeData));
    }

    private static Map<String, Statistic> requireSerializableMap(Map<String, Statistic> m) {
        for (Statistic s : m.values()) {
            if (s instanceof Statistic) continue;
            throw new IllegalArgumentException();
        }
        Map<String, Statistic> sMap = null;
        sMap = m instanceof Serializable ? m : new HashMap<String, Statistic>(m);
        return sMap;
    }

    private static Statistic requireStatisticImpl(Statistic statisticIn) {
        Statistic statisticOut = null;
        if (statisticIn instanceof CountStatisticImpl || statisticIn instanceof RangeStatisticImpl || statisticIn instanceof BoundedRangeStatisticImpl || statisticIn instanceof BoundaryStatisticImpl || statisticIn instanceof TimeStatisticImpl || statisticIn instanceof NumberStatisticImpl || statisticIn instanceof StringStatisticImpl) {
            statisticOut = statisticIn;
        } else if (statisticIn instanceof MapStatistic) {
            Class<? extends Statistic> theInterface = StatisticFactory.getInterface(statisticIn);
            if (theInterface != MapStatistic.class) {
                statisticOut = StatisticFactory.create(theInterface, J2EEUtil.statisticToMap(statisticIn));
            } else if (!(statisticIn instanceof MapStatisticImpl)) {
                statisticOut = new MapStatisticImpl(statisticIn);
            }
        } else {
            assert (false) : "requireStatisticImpl: unsupported Statistic type of class " + statisticIn.getClass().getName();
            statisticOut = new MapStatisticImpl(statisticIn);
        }
        return statisticOut;
    }

    private static Statistic[] requireStatisticImpl(Statistic[] statisticsIn) {
        boolean convert = false;
        for (int i = 0; i < statisticsIn.length; ++i) {
            if (statisticsIn[i] instanceof MapStatistic) continue;
            convert = true;
            break;
        }
        Statistic[] statisticsOut = null;
        if (convert) {
            statisticsOut = new Statistic[statisticsIn.length];
            for (int i = 0; i < statisticsIn.length; ++i) {
                statisticsOut[i] = StatsImpl.requireStatisticImpl(statisticsIn[i]);
            }
        } else {
            statisticsOut = statisticsIn;
        }
        return statisticsOut;
    }

    public StatsImpl(Map<String, Statistic> statisticsIn) {
        super(StatsImpl.requireSerializableMap(statisticsIn));
    }

    public StatsImpl(Statistic[] statistics) {
        this(StatsImpl.createStatisticsMap(statistics));
    }

    private static Map<String, Statistic> createStatisticsMap(CompositeData compositeData) {
        CompositeType compositeType = compositeData.getCompositeType();
        Set<String> keySet = compositeType.keySet();
        Iterator<String> iter = keySet.iterator();
        HashMap<String, Statistic> map = new HashMap<String, Statistic>();
        while (iter.hasNext()) {
            String name = iter.next();
            CompositeData data = (CompositeData)compositeData.get(name);
            map.put(name, StatisticFactory.create(data));
        }
        return map;
    }

    private static Map<String, Statistic> createStatisticsMap(Statistic[] statistics) {
        HashMap<String, Statistic> m = new HashMap<String, Statistic>();
        for (int i = 0; i < statistics.length; ++i) {
            Statistic statistic = StatsImpl.requireStatisticImpl(statistics[i]);
            if (statistic == null) continue;
            m.put(statistic.getName(), statistic);
        }
        return m;
    }

    @Override
    public Statistic getStatistic(String statisticName) {
        try {
            return (Statistic)this.getValue(statisticName);
        }
        catch (Exception e) {
            String msg = "NOT a Statistic: " + statisticName + " of class " + ((Statistic)this.getValue(statisticName)).getClass();
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public String[] getStatisticNames() {
        Set<String> names = this.getMap().keySet();
        return SetUtil.toStringArray(names);
    }

    @Override
    public Statistic[] getStatistics() {
        Collection<Statistic> values = this.getMap().values();
        Statistic[] statistics = new Statistic[values.size()];
        return values.toArray(statistics);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Statistic[] statistics = this.getStatistics();
        buf.append(statistics.length + " Statistics:\n");
        for (int i = 0; i < statistics.length; ++i) {
            buf.append(statistics[i].toString() + "\n");
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object rhs) {
        boolean equals = false;
        if (rhs != null && rhs instanceof Stats) {
            String[] rhsNames;
            Stats stats = (Stats)rhs;
            String[] myNames = this.getStatisticNames();
            if (myNames.length == (rhsNames = stats.getStatisticNames()).length) {
                equals = true;
                for (int i = 0; i < myNames.length; ++i) {
                    Statistic rhsStatistic;
                    String statisticName = myNames[i];
                    Statistic myStatistic = this.getStatistic(statisticName);
                    if (myStatistic.equals(rhsStatistic = stats.getStatistic(statisticName))) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    @Override
    public Object invoke(Object myProxy, Method method, Object[] args) throws Throwable {
        int numArgs;
        Object result = null;
        String methodName = method.getName();
        int n = numArgs = args == null ? 0 : args.length;
        result = numArgs == 0 && methodName.equals("getStatisticNames") ? this.getStatisticNames() : (numArgs == 0 && methodName.equals("getStatistics") ? this.getStatistics() : (numArgs == 1 && methodName.equals("getStatistic") && method.getReturnType() == Statistic.class && method.getParameterTypes()[0] == String.class ? this.getStatistic((String)args[0]) : super.invoke(myProxy, method, args)));
        return result;
    }
}

