/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee.util;

import java.util.TreeMap;
import javax.management.j2ee.statistics.Statistic;
import org.glassfish.admin.amx.j2ee.util.J2EEUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public class StatisticStringifier
implements Stringifier {
    public static final StatisticStringifier DEFAULT = new StatisticStringifier();
    private static final String DELIM = ", ";
    private static final String GET = "get";
    private static final String[] ORDERED_VALUES = new String[]{"Name", "Description", "Unit", "StartTime", "LastSampleTime", "Count", "Low", "Current", "High", "LowerBound", "UpperBound", "Current"};

    private static String createNameValuePair(String name, Object value) {
        String valueString = value instanceof String ? StringUtil.quote((Object)((String)value)) : SmartStringifier.toString((Object)value);
        return name + "=" + valueString;
    }

    public String stringify(Object o) {
        Object value;
        Statistic statistic = (Statistic)o;
        StringBuffer buf = new StringBuffer();
        buf.append(statistic.getName() + ": ");
        TreeMap<String, Object> pairs = new TreeMap<String, Object>(J2EEUtil.statisticToMap(statistic));
        for (int i = 0; i < ORDERED_VALUES.length; ++i) {
            String name = ORDERED_VALUES[i];
            if (!pairs.containsKey(name)) continue;
            value = pairs.get(name);
            buf.append(StatisticStringifier.createNameValuePair(name, value));
            buf.append(DELIM);
            pairs.remove(name);
        }
        for (String name : pairs.keySet()) {
            value = pairs.get(name);
            buf.append(StatisticStringifier.createNameValuePair(name, value));
            buf.append(DELIM);
        }
        String result = buf.toString();
        if (result.endsWith(DELIM)) {
            result = result.substring(0, result.length() - DELIM.length());
        }
        return result;
    }
}

