/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.ListenerRegistration;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import org.glassfish.admin.mejb.MEJB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEJBTest {
    private final MEJB mMEJB;

    public MEJBTest(MEJB mejb) {
        this.mMEJB = mejb;
    }

    private void test() {
        try {
            this._test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testMBean(ObjectName objectName) throws Exception {
        MEJBTest.println("");
        MEJBTest.println("" + objectName);
        MEJB mejb = this.mMEJB;
        MBeanInfo info = mejb.getMBeanInfo(objectName);
        String[] attrNames = MEJBTest.getAttributeNames(info.getAttributes());
        MEJBTest.println("attributes: " + MEJBTest.toString(MEJBTest.newListFromArray(attrNames), ", "));
        AttributeList list = mejb.getAttributes(objectName, attrNames);
        for (String attrName : attrNames) {
            try {
                Object value = mejb.getAttribute(objectName, attrName);
            }
            catch (Exception e) {
                MEJBTest.println("Attribute failed: " + attrName);
            }
        }
    }

    private void _test() throws Exception {
        MEJB mejb = this.mMEJB;
        String defaultDomain = mejb.getDefaultDomain();
        MEJBTest.println("MEJB default domain = " + defaultDomain + ", MBeanCount = " + mejb.getMBeanCount());
        ListenerRegistration reg = mejb.getListenerRegistry();
        MEJBTest.println("Got ListenerRegistration: " + reg);
        NotifListener listener = new NotifListener();
        String domain = "v3";
        ObjectName pattern = MEJBTest.newObjectName("v3:*");
        Set<ObjectName> items = mejb.queryNames(pattern, null);
        MEJBTest.println("Queried " + pattern + ", got mbeans: " + items.size());
        for (ObjectName objectName : items) {
            if (!mejb.isRegistered(objectName)) continue;
            this.testMBean(objectName);
        }
        for (ObjectName objectName : items) {
            if (!mejb.isRegistered(objectName)) continue;
            NotificationFilter filter = null;
            Object handback = null;
            reg.addNotificationListener(objectName, (NotificationListener)listener, filter, handback);
        }
    }

    public static String toString(Collection<?> c, String delim) {
        StringBuffer buf = new StringBuffer();
        for (Object item : c) {
            buf.append("" + item);
            buf.append(delim);
        }
        if (c.size() != 0) {
            buf.setLength(buf.length() - delim.length());
        }
        return buf.toString();
    }

    public static <T> List<T> newListFromArray(T[] items) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < items.length; ++i) {
            list.add(items[i]);
        }
        return list;
    }

    public static String[] getAttributeNames(MBeanAttributeInfo[] infos) {
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].getName();
        }
        return names;
    }

    static ObjectName newObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        try {
            InitialContext initial = new InitialContext();
            String mejbName = "java:global/MEJB/MEJBBean";
            MEJBTest.println("Looking up: java:global/MEJB/MEJBBean");
            Object objref = initial.lookup("java:global/MEJB/MEJBBean");
            ManagementHome home = (ManagementHome)objref;
            MEJB mejb = (MEJB)home.create();
            MEJBTest.println("Got the MEJB");
            new MEJBTest(mejb).test();
            mejb.remove();
        }
        catch (Exception ex) {
            System.err.println("Caught an unexpected exception!");
            ex.printStackTrace();
        }
    }

    private static final void println(Object o) {
        System.out.println("" + o);
    }

    private static final class NotifListener
    implements NotificationListener {
        public void handleNotification(Notification notif, Object handback) {
            System.out.println("NotifListener: " + notif);
        }
    }
}

