/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.j2ee.J2EELogicalServerImplBase;
import org.glassfish.admin.amx.impl.j2ee.J2EEManagedObjectImplBase;
import org.glassfish.admin.amx.impl.j2ee.JCAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JDBCResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JMSResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JNDIResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JTAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JavaMailResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.RMI_IIOPResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.URLResourceImpl;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.Resources;
import org.glassfish.admin.amx.j2ee.J2EELogicalServer;
import org.glassfish.admin.amx.j2ee.J2EEManagedObject;
import org.glassfish.admin.amx.j2ee.J2EEServer;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEServerImpl
extends J2EELogicalServerImplBase {
    public static final Class<J2EEServer> INTF = J2EEServer.class;
    private static final Map<ObjectName, ObjectName> mConfigTo77 = new HashMap<ObjectName, ObjectName>();
    private static final String serverVendor = "Sun Microsystems, Inc.";
    private volatile ResourceListener mResourceListener;
    private static final Map<String, Class> RESOURCE_TYPES = MapUtil.toMap((Object[])new Object[]{"jdbc-resource", JDBCResourceImpl.class, "java-mail-resource", JavaMailResourceImpl.class, "jca-resource", JCAResourceImpl.class, "jms-resource", JMSResourceImpl.class, "jndi-resource", JNDIResourceImpl.class, "jta-resource", JTAResourceImpl.class, "rmi-iiop-resource", RMI_IIOPResourceImpl.class, "url-resource", URLResourceImpl.class}, String.class, Class.class);

    public J2EEServerImpl(ObjectName parentObjectName) {
        super(parentObjectName, (Class<? extends J2EELogicalServer>)INTF);
    }

    public String[] getjavaVMs() {
        String[] stringArray;
        ObjectName child = this.child("JVM");
        if (child == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = child.toString();
        }
        return stringArray;
    }

    public String[] getresources() {
        return this.getChildrenAsStrings(RESOURCE_TYPES.keySet());
    }

    public String getserverVersion() {
        Issues.getAMXIssues().notDone("How to get the server version");
        return "Glassfish V3";
    }

    public String getserverVendor() {
        return serverVendor;
    }

    public String getjvm() {
        return "" + this.getAncestorByType("JVM");
    }

    protected void registerChildren() {
        super.registerChildren();
        FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", "J2EEServerImpl.registerChildren()");
        Resources resourcesConfig = this.getDomainConfig().getResources();
        this.mResourceListener = new ResourceListener(this.getMBeanServer(), this.getObjectName(), resourcesConfig.objectName());
        this.mResourceListener.startListening();
        Set candidates = resourcesConfig.childrenSet();
        for (AMXProxy amx : candidates) {
            this.mResourceListener.register(amx);
        }
    }

    protected void unregisterChildren() {
        this.mResourceListener.stopListening();
        this.mResourceListener = null;
        super.unregisterChildren();
    }

    protected <I extends J2EEManagedObject, C extends J2EEManagedObjectImplBase> ObjectName registerJ2EEChild(ObjectName parent, Class<I> intf, Class<C> clazz, String name) {
        ObjectName on = null;
        try {
            Constructor<C> c = clazz.getConstructor(ObjectName.class);
            J2EEManagedObjectImplBase impl = (J2EEManagedObjectImplBase)((Object)c.newInstance(parent));
            String j2eeType = Util.deduceType(intf);
            on = new ObjectNameBuilder(this.getMBeanServer(), parent).buildChildObjectName(j2eeType, name);
            on = this.registerChild((Object)impl, on);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return on;
    }

    final class ResourceListener
    implements NotificationListener {
        private final MBeanServer mServer;
        private final ObjectName mJ2EEServer;
        private final ObjectName mResourcesConfig;

        public ResourceListener(MBeanServer server, ObjectName j2eeServer, ObjectName resourcesConfig) {
            this.mServer = server;
            this.mJ2EEServer = j2eeServer;
            this.mResourcesConfig = resourcesConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(AMXProxy amxConfig) {
            if (!this.mResourcesConfig.equals(amxConfig.parent().objectName())) {
                return;
            }
            String configType = amxConfig.type();
            Class implClass = (Class)RESOURCE_TYPES.get(configType);
            if (implClass == null) {
                ImplUtil.getLogger().info("Unrecognized resource type for JSR 77 purposes: " + amxConfig.objectName());
                return;
            }
            Class intf = (Class)ClassUtil.getFieldValue((Class)implClass, (String)"INTF");
            String j2eeType = Util.deduceType((Class)intf);
            try {
                ObjectName mbean77 = J2EEServerImpl.this.registerJ2EEChild(this.mJ2EEServer, intf, implClass, amxConfig.getName());
                Map map = mConfigTo77;
                synchronized (map) {
                    mConfigTo77.put(amxConfig.objectName(), mbean77);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notifIn, Object handback) {
            if (!(notifIn instanceof MBeanServerNotification)) {
                return;
            }
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (!this.mJ2EEServer.getDomain().equals(objectName.getDomain())) {
                return;
            }
            if (notif.getType().equals("JMX.mbean.registered")) {
                AMXProxy amx = J2EEServerImpl.this.getProxyFactory().getProxy(objectName);
                this.register(amx);
            } else if (notif.getType().equals("JMX.mbean.unregistered")) {
                Map map = mConfigTo77;
                synchronized (map) {
                    ObjectName mbean77 = (ObjectName)mConfigTo77.remove(objectName);
                    if (mbean77 != null) {
                        try {
                            J2EEServerImpl.this.getMBeanServer().unregisterMBean(mbean77);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        public void startListening() {
            try {
                this.mServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
        }

        public void stopListening() {
            try {
                this.mServer.removeNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

