/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee.loader;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.j2ee.J2EEDomainImpl;
import org.glassfish.admin.amx.impl.j2ee.loader.AMXJ2EEStartupServiceMBean;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.j2ee.J2EEDomain;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXJ2EEStartupService
implements PostConstruct,
PreDestroy,
AMXJ2EEStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        try {
            this.mMBeanServer.registerMBean(this, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    public void preDestroy() {
        this.unloadAMXMBeans();
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootProxy();
    }

    public ObjectName getJ2EEDomain() {
        return this.getDomainRootProxy().child("J2EEDomain").extra().objectName();
    }

    private J2EEDomain getJ2EEDomainProxy() {
        return (J2EEDomain)ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getProxy(this.getJ2EEDomain(), J2EEDomain.class);
    }

    public synchronized ObjectName loadAMXMBeans() {
        FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", "" + this);
        ObjectName domainRoot = ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootObjectName();
        J2EEDomainImpl impl = new J2EEDomainImpl(domainRoot);
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.mMBeanServer, domainRoot);
        String domainName = Util.getNameProp((ObjectName)domainRoot);
        ObjectName objectName = objectNames.buildChildObjectName(J2EEDomain.class);
        try {
            objectName = this.mMBeanServer.registerMBean((Object)impl, objectName).getObjectName();
        }
        catch (JMException e) {
            throw new Error(e);
        }
        return objectName;
    }

    public synchronized void unloadAMXMBeans() {
        J2EEDomain j2eeDomain = this.getJ2EEDomainProxy();
        if (j2eeDomain != null) {
            ImplUtil.unregisterAMXMBeans((AMXProxy)j2eeDomain);
        }
    }
}

