/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.javaee.full.deployment.EarClassLoader;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PreDestroy;
import org.xml.sax.SAXParseException;

@Service(name="ear")
public class EarHandler
extends AbstractArchiveHandler
implements CompositeHandler {
    @Inject
    Deployment deployment;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig dasConfig;
    private static final String EAR_LIB = "ear_lib";
    private static final String EMBEDDED_RAR = "embedded_rar";
    private static LocalStringsImpl strings = new LocalStringsImpl(EarHandler.class);

    public String getArchiveType() {
        return "ear";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return DeploymentUtils.isEAR((ReadableArchive)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        super.expand(source, target, context);
        ReadableArchive source2 = null;
        try {
            source2 = this.archiveFactory.openArchive(target.getURI());
            ApplicationHolder holder = this.getApplicationHolder(source2, context, false);
            for (ModuleDescriptor md : holder.app.getModules()) {
                String moduleUri = md.getArchiveUri();
                ReadableArchive subArchive = null;
                WritableArchive subTarget = null;
                try {
                    subArchive = source.getSubArchive(moduleUri);
                    if (subArchive == null) {
                        this._logger.log(Level.WARNING, "Exception while locating sub archive: " + moduleUri);
                        continue;
                    }
                    ArchiveHandler subHandler = this.deployment.getArchiveHandler(subArchive);
                    context.getModuleArchiveHandlers().put(moduleUri, subHandler);
                    if (subHandler == null) continue;
                    subTarget = target.createSubArchive(FileUtils.makeFriendlyFilenameExtension((String)moduleUri));
                    subHandler.expand(subArchive, subTarget, context);
                }
                catch (IOException ioe) {
                    this._logger.log(Level.FINE, "Exception while processing " + moduleUri, ioe);
                }
                finally {
                    if (subArchive != null) {
                        subArchive.close();
                    }
                    if (subTarget == null) continue;
                    subTarget.close();
                }
            }
        }
        finally {
            if (source2 != null) {
                source2.close();
            }
        }
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        EarClassLoader cl;
        DelegatingClassLoader embeddedConnCl;
        ReadableArchive archive = context.getSource();
        ApplicationHolder holder = this.getApplicationHolder(archive, context, true);
        try {
            String compatProp = context.getAppProps().getProperty("compatibility");
            EarLibClassLoader earLibCl = new EarLibClassLoader(ASClassLoaderUtil.getAppLibDirLibraries((File)context.getSourceDir(), (String)holder.app.getLibraryDirectory(), (String)compatProp), parent);
            embeddedConnCl = new DelegatingClassLoader((ClassLoader)((Object)earLibCl));
            cl = new EarClassLoader((ClassLoader)embeddedConnCl);
            cl.addModuleClassLoader(EAR_LIB, (ClassLoader)((Object)earLibCl));
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, strings.get("errAddLibs"), e);
            throw new RuntimeException(e);
        }
        for (ModuleDescriptor md : holder.app.getModules()) {
            ReadableArchive sub = null;
            String moduleUri = md.getArchiveUri();
            try {
                sub = archive.getSubArchive(moduleUri);
                if (sub instanceof InputJarArchive) {
                    throw new IllegalArgumentException(strings.get("wrongArchType", new Object[]{moduleUri}));
                }
            }
            catch (IOException e) {
                this._logger.log(Level.FINE, "Sub archive " + moduleUri + " seems unreadable", e);
            }
            if (sub == null) continue;
            try {
                URL[] moduleURLs;
                ArchiveHandler handler = (ArchiveHandler)context.getModuleArchiveHandlers().get(moduleUri);
                if (handler == null) {
                    handler = this.deployment.getArchiveHandler(sub);
                    context.getModuleArchiveHandlers().put(moduleUri, handler);
                }
                if (handler == null) continue;
                ActionReport subReport = context.getActionReport().addSubActionsReport();
                DeploymentContextImpl subContext = new DeploymentContextImpl(subReport, context.getLogger(), sub, context.getCommandParameters(DeployCommandParameters.class), this.env){

                    public File getScratchDir(String subDirName) {
                        String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                        return new File(super.getScratchDir(subDirName), modulePortion);
                    }
                };
                subContext.setArchiveHandler(context.getArchiveHandler());
                sub.setParentArchive(context.getSource());
                ClassLoader subCl = handler.getClassLoader((ClassLoader)((Object)cl), (DeploymentContext)subContext);
                if (md.getModuleType().equals((Object)XModuleType.EJB)) {
                    for (URL moduleURL : moduleURLs = ((URLClassLoader)subCl).getURLs()) {
                        cl.addURL(moduleURL);
                    }
                    cl.addModuleClassLoader(moduleUri, (ClassLoader)((Object)cl));
                    ((PreDestroy)PreDestroy.class.cast(subCl)).preDestroy();
                    continue;
                }
                if (md.getModuleType().equals((Object)XModuleType.RAR)) {
                    embeddedConnCl.addDelegate((DelegatingClassLoader.ClassFinder)subCl);
                    cl.addModuleClassLoader(moduleUri, subCl);
                    continue;
                }
                if (subCl instanceof URLClassLoader && ((Boolean)context.getTransientAppMetaData("isTempClassLoader", Boolean.class)).booleanValue()) {
                    for (URL moduleURL : moduleURLs = ((URLClassLoader)subCl).getURLs()) {
                        cl.addURL(moduleURL);
                    }
                }
                cl.addModuleClassLoader(moduleUri, subCl);
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, strings.get("noClassLoader", new Object[]{moduleUri}), e);
            }
        }
        return cl;
    }

    public boolean accept(ReadableArchive source, String entryName) {
        return entryName.startsWith("META-INF");
    }

    private ApplicationHolder getApplicationHolder(ReadableArchive source, DeploymentContext context, boolean isDirectory) {
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder == null || holder.app == null) {
            try {
                long start = System.currentTimeMillis();
                ApplicationArchivist archivist = (ApplicationArchivist)this.habitat.getComponent(ApplicationArchivist.class);
                archivist.setAnnotationProcessingRequested(true);
                String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
                archivist.setXMLValidationLevel(xmlValidationLevel);
                if (xmlValidationLevel.equals("none")) {
                    archivist.setXMLValidation(false);
                }
                holder = new ApplicationHolder(archivist.createApplication(source, isDirectory));
                this._logger.fine("time to read application.xml " + (System.currentTimeMillis() - start));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXParseException e) {
                throw new RuntimeException(e);
            }
            context.addModuleMetaData((Object)holder);
        }
        if (holder.app == null) {
            throw new RuntimeException(strings.get("errReadMetadata"));
        }
        return holder;
    }
}

