/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb;

import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.mejb.RemoteEventListener;

public final class RemoteListenerConnector
implements NotificationListener,
Serializable {
    private static final boolean debug = true;
    private final String proxyAddress;
    private RemoteEventListener listener = null;
    private MBeanServer server = null;
    private final String id = this.hashCode() + ":" + System.currentTimeMillis();

    private static void debug(String s) {
        System.out.println(s);
    }

    public RemoteListenerConnector(String address) {
        this.proxyAddress = address;
    }

    @Override
    public synchronized void handleNotification(Notification evt, Object h) {
        try {
            RemoteListenerConnector.debug("RemoteListenerConnector.handleNotification()");
            if (this.listener == null) {
                this.listener = (RemoteEventListener)Naming.lookup(this.proxyAddress);
            }
            this.listener.handleNotification(evt, h);
        }
        catch (RemoteException ce) {
            if (this.server != null) {
                RemoteListenerConnector.debug("RemoteListenerConnector.server.removeNotificationListener(" + (ObjectName)evt.getSource() + ", " + this + ")");
                try {
                    this.server.removeNotificationListener((ObjectName)evt.getSource(), this);
                }
                catch (ListenerNotFoundException e) {
                    RemoteListenerConnector.debug(this.toString() + ": " + e);
                }
                catch (Exception e1) {
                    RemoteListenerConnector.debug(this.toString() + ": " + e1);
                }
            }
        }
        catch (Exception e) {
            RemoteListenerConnector.debug(this.toString() + ": " + e);
            try {
                RemoteListenerConnector.debug("Naming.list(\"//localhost:1100\")");
                String[] names = Naming.list("//localhost:1100");
                for (int x = 0; x < names.length; ++x) {
                    RemoteListenerConnector.debug("names[" + x + "] = " + names[x]);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setMBeanServer(MBeanServer s) {
        this.server = s;
    }
}

