/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.javaee.full.deployment.EarClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class EarDeployer
implements Deployer {
    @Inject
    Habitat habitat;
    @Inject
    Deployment deployment;
    @Inject
    ServerEnvironment env;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    protected SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Events events;
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EarDeployer.class);

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public Object loadMetaData(Class type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(final DeploymentContext context) {
        final Application application = (Application)context.getModuleMetaData(Application.class);
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        final CompositeApplicationInfo appInfo = new CompositeApplicationInfo(this.events, application, context.getSource(), appName);
        for (Object m : context.getModuleMetadata()) {
            appInfo.addMetaData(m);
        }
        try {
            this.doOnAllBundles(application, new BundleBlock<ModuleInfo>(){

                @Override
                public ModuleInfo doBundle(ModuleDescriptor bundle) throws Exception {
                    ExtendedDeploymentContext sContext = EarDeployer.this.subContext(application, context, bundle.getArchiveUri());
                    ModuleInfo info = EarDeployer.this.prepareBundle(bundle, application, sContext);
                    if (info == null) {
                        sContext.getActionReport().setActionExitCode(ActionReport.ExitCode.WARNING);
                        String msg = localStrings.getLocalString("skipmoduleprocessing", "Skipped processing for module {0} as its module type was not recognized", new Object[]{bundle.getArchiveUri()});
                        sContext.getActionReport().setMessage(msg);
                        logger.warning(msg);
                        return null;
                    }
                    info.addMetaData((Object)application);
                    BundleDescriptor bundleDesc = application.getModuleByUri(bundle.getArchiveUri());
                    info.addMetaData((Object)bundleDesc);
                    for (RootDeploymentDescriptor ext : bundleDesc.getExtensionsDescriptors()) {
                        info.addMetaData((Object)ext);
                    }
                    appInfo.addModule(info);
                    return info;
                }
            });
        }
        catch (DeploymentException dde) {
            throw dde;
        }
        catch (Exception e) {
            DeploymentException de = new DeploymentException(e.getMessage());
            de.initCause((Throwable)e);
            throw de;
        }
        context.addModuleMetaData((Object)appInfo);
        this.generateArtifacts(context);
        return true;
    }

    protected void generateArtifacts(DeploymentContext context) throws DeploymentException {
    }

    private void doOnBundles(Collection<ModuleDescriptor<BundleDescriptor>> bundles, BundleBlock runnable) throws Exception {
        for (ModuleDescriptor<BundleDescriptor> module : bundles) {
            runnable.doBundle(module);
        }
    }

    private Collection<ModuleDescriptor<BundleDescriptor>> doOnAllTypedBundles(Application application, XModuleType type, BundleBlock runnable) throws Exception {
        Collection typedBundles = application.getModuleDescriptorsByType(type);
        this.doOnBundles(typedBundles, runnable);
        return typedBundles;
    }

    private void doOnAllBundles(Application application, BundleBlock runnable) throws Exception {
        LinkedHashSet bundles = new LinkedHashSet();
        bundles.addAll(application.getModules());
        if (application.isInitializeInOrder()) {
            for (ModuleDescriptor bundle : bundles) {
                runnable.doBundle(bundle);
            }
        } else {
            bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.RAR, runnable));
            bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.EJB, runnable));
            bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.WAR, runnable));
            Collection appClientBundles = application.getModuleDescriptorsByType(XModuleType.CAR);
            bundles.removeAll(appClientBundles);
            for (ModuleDescriptor bundle : bundles) {
                runnable.doBundle(bundle);
            }
            this.doOnBundles(appClientBundles, runnable);
        }
    }

    private ModuleInfo prepareBundle(ModuleDescriptor md, Application application, ExtendedDeploymentContext bundleContext) throws Exception {
        List orderedContainers = null;
        ProgressTracker tracker = (ProgressTracker)bundleContext.getTransientAppMetaData("tracker", ProgressTracker.class);
        try {
            Collection<Sniffer> sniffers = this.getSniffersForModule((DeploymentContext)bundleContext, md, application);
            orderedContainers = this.deployment.setupContainerInfos(null, sniffers, (DeploymentContext)bundleContext);
            if (orderedContainers == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error occurred", e);
            throw e;
        }
        return this.deployment.prepareModule(orderedContainers, md.getArchiveUri(), (DeploymentContext)bundleContext, tracker);
    }

    public ApplicationContainer load(Container container, DeploymentContext context) {
        return new DummyApplication();
    }

    public void unload(ApplicationContainer appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }

    private ExtendedDeploymentContext subContext(final Application application, final DeploymentContext context, final String moduleUri) {
        ReadableArchive subArchive;
        Object moduleContext = (ExtendedDeploymentContext)((ExtendedDeploymentContext)context).getModuleDeploymentContexts().get(moduleUri);
        if (moduleContext != null) {
            return moduleContext;
        }
        try {
            subArchive = context.getSource().getSubArchive(moduleUri);
            subArchive.setParentArchive(context.getSource());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error occurred", ioe);
            return null;
        }
        final Properties moduleProps = this.getModuleProps(context, moduleUri);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        moduleContext = new DeploymentContextImpl(subReport, logger, context.getSource(), context.getCommandParameters(OpsParams.class), this.env){

            public ClassLoader getClassLoader() {
                try {
                    if (context.getClassLoader() == null) {
                        return null;
                    }
                    EarClassLoader appCl = (EarClassLoader)((Object)EarClassLoader.class.cast(context.getClassLoader()));
                    if (((ExtendedDeploymentContext)context).getPhase() == ExtendedDeploymentContext.Phase.PREPARE) {
                        return appCl;
                    }
                    return appCl.getModuleClassLoader(moduleUri);
                }
                catch (ClassCastException e) {
                    return context.getClassLoader();
                }
            }

            public ClassLoader getFinalClassLoader() {
                try {
                    EarClassLoader finalEarCL = (EarClassLoader)((Object)context.getFinalClassLoader());
                    return finalEarCL.getModuleClassLoader(moduleUri);
                }
                catch (ClassCastException e) {
                    return context.getClassLoader();
                }
            }

            public ReadableArchive getSource() {
                return subArchive;
            }

            public Properties getAppProps() {
                return context.getAppProps();
            }

            public <U extends OpsParams> U getCommandParameters(Class<U> commandParametersType) {
                return (U)context.getCommandParameters(commandParametersType);
            }

            public void addTransientAppMetaData(String metaDataKey, Object metaData) {
                context.addTransientAppMetaData(metaDataKey, metaData);
            }

            public <T> T getTransientAppMetaData(String metaDataKey, Class<T> metadataType) {
                return (T)context.getTransientAppMetaData(metaDataKey, metadataType);
            }

            public Properties getModuleProps() {
                return moduleProps;
            }

            public ReadableArchive getOriginalSource() {
                try {
                    File appRoot = context.getSourceDir();
                    File origModuleFile = new File(appRoot, moduleUri);
                    return EarDeployer.this.archiveFactory.openArchive(origModuleFile);
                }
                catch (IOException ioe) {
                    return null;
                }
            }

            public File getScratchDir(String subDirName) {
                String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                return new File(super.getScratchDir(subDirName), modulePortion);
            }

            public <T> T getModuleMetaData(Class<T> metadataType) {
                try {
                    return metadataType.cast(application.getModuleByUri(moduleUri));
                }
                catch (Exception e) {
                    if (RootDeploymentDescriptor.class.isAssignableFrom(metadataType)) {
                        for (RootDeploymentDescriptor extension : application.getModuleByUri(moduleUri).getExtensionsDescriptors(metadataType)) {
                            if (extension == null) continue;
                            try {
                                return metadataType.cast(extension);
                            }
                            catch (Exception e1) {
                            }
                        }
                    }
                    return (T)context.getModuleMetaData(metadataType);
                }
            }
        };
        ((ExtendedDeploymentContext)context).getModuleDeploymentContexts().put(moduleUri, moduleContext);
        moduleContext.setParentContext((ExtendedDeploymentContext)context);
        ArchiveHandler subHandler = (ArchiveHandler)context.getModuleArchiveHandlers().get(moduleUri);
        moduleContext.setArchiveHandler(subHandler);
        return moduleContext;
    }

    private Properties getModuleProps(DeploymentContext context, String moduleUri) {
        Map modulePropsMap = context.getModulePropsMap();
        Properties moduleProps = (Properties)modulePropsMap.get(moduleUri);
        if (moduleProps == null) {
            moduleProps = new Properties();
            modulePropsMap.put(moduleUri, moduleProps);
        }
        return moduleProps;
    }

    private String getTypeFromModuleType(XModuleType moduleType) {
        if (moduleType.equals((Object)XModuleType.WAR)) {
            return "web";
        }
        if (moduleType.equals((Object)XModuleType.EJB)) {
            return "ejb";
        }
        if (moduleType.equals((Object)XModuleType.CAR)) {
            return "appclient";
        }
        if (moduleType.equals((Object)XModuleType.RAR)) {
            return "connector";
        }
        return null;
    }

    private Collection<Sniffer> getSniffersForModule(DeploymentContext bundleContext, ModuleDescriptor md, Application application) {
        Collection sniffers = this.snifferManager.getSniffers(bundleContext);
        String type = this.getTypeFromModuleType(md.getModuleType());
        Sniffer mainSniffer = null;
        for (Sniffer sniffer : sniffers) {
            if (!sniffer.getModuleType().equals(type)) continue;
            mainSniffer = sniffer;
        }
        if (mainSniffer == null) {
            mainSniffer = this.snifferManager.getSniffer(type);
            sniffers.add(mainSniffer);
        }
        String[] incompatibleTypes = mainSniffer.getIncompatibleSnifferTypes();
        ArrayList<Sniffer> sniffersToRemove = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            for (String incompatType : incompatibleTypes) {
                if (!sniffer.getModuleType().equals(incompatType)) continue;
                logger.warning(type + " module [" + md.getArchiveUri() + "] contains characteristics of other module type: " + incompatType);
                sniffersToRemove.add(sniffer);
            }
        }
        sniffers.removeAll(sniffersToRemove);
        return sniffers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BundleBlock<T> {
        public T doBundle(ModuleDescriptor var1) throws Exception;
    }

    private class CompositeApplicationInfo
    extends ApplicationInfo {
        final Application application;

        private CompositeApplicationInfo(Events events, Application application, ReadableArchive source, String name) {
            super(events, source, name);
            this.application = application;
        }

        protected ExtendedDeploymentContext getSubContext(ModuleInfo module, ExtendedDeploymentContext context) {
            return EarDeployer.this.subContext(this.application, (DeploymentContext)context, module.getName());
        }
    }
}

