/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractWebHandler;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.util.net.URLPattern;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebFilterHandler
extends AbstractWebHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return WebFilter.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webCompContexts[0].getDescriptor().getWebBundleDescriptor());
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webBundleContext.getDescriptor());
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleDescriptor webBundleDesc) throws AnnotationProcessorException {
        DispatcherType[] dispatcherTypes;
        String[] servletNames;
        WebInitParam[] initParams;
        Class filterClass = (Class)ainfo.getAnnotatedElement();
        if (!Filter.class.isAssignableFrom(filterClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.needtoimpl", "The Class {0} having annotation {1} need to implement the interface {2}.", new Object[]{filterClass.getName(), WebFilter.class.getName(), Filter.class.getName()}));
            return this.getDefaultFailedResult();
        }
        WebFilter webFilterAn = (WebFilter)ainfo.getAnnotation();
        String filterName = webFilterAn.filterName();
        if (filterName == null || filterName.length() == 0) {
            filterName = filterClass.getName();
        }
        ServletFilter servletFilterDesc = null;
        for (ServletFilter sfDesc : webBundleDesc.getServletFilters()) {
            if (!filterName.equals(sfDesc.getName())) continue;
            servletFilterDesc = sfDesc;
            break;
        }
        if (servletFilterDesc == null) {
            servletFilterDesc = new ServletFilterDescriptor();
            servletFilterDesc.setName(filterName);
            webBundleDesc.addServletFilter(servletFilterDesc);
        } else {
            String filterImpl = servletFilterDesc.getClassName();
            if (filterImpl != null && filterImpl.length() > 0 && !filterImpl.equals(filterClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.filternamedontmatch", "The filter '{0}' has implementation '{1}' in xml. It does not match with '{2}' from annotation @{3}.", new Object[]{filterName, filterImpl, filterClass.getName(), WebFilter.class.getName()}));
                return this.getDefaultFailedResult();
            }
        }
        servletFilterDesc.setClassName(filterClass.getName());
        if (servletFilterDesc.getDescription() == null) {
            servletFilterDesc.setDescription(webFilterAn.description());
        }
        if (servletFilterDesc.getDisplayName() == null) {
            servletFilterDesc.setDisplayName(webFilterAn.displayName());
        }
        if (servletFilterDesc.getInitializationParameters().size() == 0 && (initParams = webFilterAn.initParams()) != null && initParams.length > 0) {
            for (WebInitParam initParam : initParams) {
                servletFilterDesc.addInitializationParameter(new EnvironmentProperty(initParam.name(), initParam.value(), initParam.description()));
            }
        }
        if (servletFilterDesc.getSmallIconUri() == null) {
            servletFilterDesc.setSmallIconUri(webFilterAn.smallIcon());
        }
        if (servletFilterDesc.getLargeIconUri() == null) {
            servletFilterDesc.setLargeIconUri(webFilterAn.largeIcon());
        }
        if (servletFilterDesc.isAsyncSupported() == null) {
            servletFilterDesc.setAsyncSupported(webFilterAn.asyncSupported());
        }
        ServletFilterMapping servletFilterMappingDesc = null;
        boolean hasUrlPattern = false;
        boolean hasServletName = false;
        for (ServletFilterMapping sfm : webBundleDesc.getServletFilterMappings()) {
            if (!filterName.equals(sfm.getName())) continue;
            servletFilterMappingDesc = sfm;
            hasUrlPattern = hasUrlPattern || sfm.getURLPatterns().size() > 0;
            hasServletName = hasServletName || sfm.getServletNames().size() > 0;
        }
        if (servletFilterMappingDesc == null) {
            servletFilterMappingDesc = new ServletFilterMappingDescriptor();
            servletFilterMappingDesc.setName(filterName);
            webBundleDesc.addServletFilterMapping(servletFilterMappingDesc);
        }
        if (!hasUrlPattern) {
            Object[] urlPatterns = webFilterAn.urlPatterns();
            if (urlPatterns == null || urlPatterns.length == 0) {
                urlPatterns = webFilterAn.value();
            }
            boolean validUrlPatterns = true;
            if (urlPatterns != null && urlPatterns.length > 0) {
                for (Object up : urlPatterns) {
                    if (!URLPattern.isValid((String)up)) {
                        validUrlPatterns = false;
                        break;
                    }
                    servletFilterMappingDesc.addURLPattern((String)up);
                }
            }
            if (!validUrlPatterns) {
                String urlPatternString = urlPatterns != null ? Arrays.toString(urlPatterns) : "";
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidUrlPatterns", "Invalid url patterns: {0}.", new Object[]{urlPatternString}));
            }
        }
        if (!hasServletName && (servletNames = webFilterAn.servletNames()) != null && servletNames.length > 0) {
            String[] arr$ = servletNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String sn = arr$[i$];
                servletFilterMappingDesc.addServletName(sn);
            }
        }
        if (servletFilterMappingDesc.getDispatchers().size() == 0 && (dispatcherTypes = webFilterAn.dispatcherTypes()) != null && dispatcherTypes.length > 0) {
            for (DispatcherType dType : dispatcherTypes) {
                servletFilterMappingDesc.addDispatcher(dType.name());
            }
        }
        return this.getDefaultProcessedResult();
    }
}

