/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsProviderRegistry {
    List<StatsProviderRegistryElement> regElements = new ArrayList<StatsProviderRegistryElement>();
    private Map<String, List<StatsProviderRegistryElement>> configToRegistryElementMap = new HashMap<String, List<StatsProviderRegistryElement>>();
    private Map<Object, StatsProviderRegistryElement> statsProviderToRegistryElementMap = new HashMap<Object, StatsProviderRegistryElement>();
    private Map<String, Boolean> configEnabledMap = new HashMap<String, Boolean>();
    private MonitoringRuntimeDataRegistry mrdr;
    private boolean isAMXReady = false;
    private boolean isMBeanEnabled = true;

    public StatsProviderRegistry(MonitoringRuntimeDataRegistry mrdr) {
        this.mrdr = mrdr;
    }

    public void registerStatsProvider(String configStr, PluginPoint pp, String subTreePath, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider, String mbeanName, ManagedObjectManager mom) {
        StatsProviderRegistryElement spre = new StatsProviderRegistryElement(configStr, pp, subTreePath, parentTreeNodePath, childTreeNodeNames, handles, statsProvider, mbeanName, mom);
        if (this.configToRegistryElementMap.containsKey(configStr)) {
            List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configStr);
            spreList.add(spre);
        } else {
            ArrayList<StatsProviderRegistryElement> spreList = new ArrayList<StatsProviderRegistryElement>();
            spreList.add(spre);
            this.configToRegistryElementMap.put(configStr, spreList);
        }
        this.statsProviderToRegistryElementMap.put(statsProvider, spre);
    }

    public void unregisterStatsProvider(Object statsProvider) throws Exception {
        StatsProviderRegistryElement spre = this.statsProviderToRegistryElementMap.get(statsProvider);
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(spre.getConfigStr());
        if (spreList != null) {
            spreList.remove(spre);
            if (spreList.isEmpty()) {
                this.configToRegistryElementMap.remove(spre.getConfigStr());
            }
        }
        this.statsProviderToRegistryElementMap.remove(statsProvider);
        spre.setStatsProvider(null);
    }

    StatsProviderRegistryElement getStatsProviderRegistryElement(Object statsProvider) {
        return this.statsProviderToRegistryElementMap.get(statsProvider);
    }

    List<StatsProviderRegistryElement> getStatsProviderRegistryElement(String configElement) {
        return this.configToRegistryElementMap.get(configElement);
    }

    Collection<StatsProviderRegistryElement> getSpreList() {
        return this.statsProviderToRegistryElementMap.values();
    }

    Collection<String> getConfigElementList() {
        return this.configToRegistryElementMap.keySet();
    }

    void setAMXReady(boolean ready) {
        this.isAMXReady = ready;
    }

    boolean isAMXReady() {
        return this.isAMXReady;
    }

    void setMBeanEnabled(boolean enabled) {
        this.isMBeanEnabled = enabled;
    }

    boolean isMBeanEnabled() {
        return this.isMBeanEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatsProviderRegistryElement {
        String configStr;
        PluginPoint pp;
        String subTreePath;
        String parentTreeNodePath;
        List<String> childTreeNodeNames;
        Collection<ProbeClientMethodHandle> handles;
        Object statsProvider;
        String mbeanName;
        ManagedObjectManager mom;
        boolean isEnabled = false;

        public StatsProviderRegistryElement(String configStr, PluginPoint pp, String subTreePath, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider, String mbeanName, ManagedObjectManager mom) {
            this.configStr = configStr;
            this.pp = pp;
            this.subTreePath = subTreePath;
            this.handles = handles;
            this.parentTreeNodePath = parentTreeNodePath;
            this.childTreeNodeNames = childTreeNodeNames;
            this.statsProvider = statsProvider;
            this.mbeanName = mbeanName;
            this.mom = mom;
        }

        public String getConfigStr() {
            return this.configStr;
        }

        public PluginPoint getPluginPoint() {
            return this.pp;
        }

        public String getSubTreePath() {
            return this.subTreePath;
        }

        public List<String> getChildTreeNodeNames() {
            return this.childTreeNodeNames;
        }

        public String getParentTreeNodePath() {
            return this.parentTreeNodePath;
        }

        public Collection<ProbeClientMethodHandle> getHandles() {
            return this.handles;
        }

        public Object getStatsProvider() {
            return this.statsProvider;
        }

        private void setStatsProvider(Object statsProvider) {
            this.statsProvider = statsProvider;
        }

        public String getMBeanName() {
            return this.mbeanName;
        }

        public ManagedObjectManager getManagedObjectManager() {
            return this.mom;
        }

        void setManagedObjectManager(ManagedObjectManager mom) {
            this.mom = mom;
        }

        boolean isEnabled() {
            return this.isEnabled;
        }

        void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public void setParentTreeNodePath(String completePathName) {
            this.parentTreeNodePath = completePathName;
        }

        public void setChildNodeNames(List<String> childNodeNames) {
            this.childTreeNodeNames = childNodeNames;
        }

        public void setHandles(Collection<ProbeClientMethodHandle> handles) {
            this.handles = handles;
        }

        public String toString() {
            this.pp = this.pp;
            this.subTreePath = this.subTreePath;
            this.handles = this.handles;
            this.parentTreeNodePath = this.parentTreeNodePath;
            String str = "    configStr = " + this.configStr + "\n" + "    statsProvider = " + this.statsProvider.getClass().getName() + "\n" + "    PluginPoint = " + this.pp + "\n" + "    handles = " + (this.handles == null ? "null" : "not null") + "\n" + "    parentTreeNodePath = " + this.parentTreeNodePath;
            return str;
        }
    }
}

