/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.monitor.jvm.JVMClassLoadingStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMCompilationStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMGCStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMMemoryStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMOSStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMRuntimeStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadInfoStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadSystemStatsProvider;
import org.glassfish.admin.monitor.jvm.ServerRuntimeStatsProvider;
import org.glassfish.api.Startup;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JVMStatsProviderBootstrap
implements Startup,
PostConstruct {
    private ServerRuntimeStatsProvider srtStatsProvider = new ServerRuntimeStatsProvider();
    private JVMClassLoadingStatsProvider clStatsProvider = new JVMClassLoadingStatsProvider();
    private JVMCompilationStatsProvider compileStatsProvider = new JVMCompilationStatsProvider();
    private JVMMemoryStatsProvider memoryStatsProvider = new JVMMemoryStatsProvider();
    private JVMOSStatsProvider osStatsProvider = new JVMOSStatsProvider();
    private JVMRuntimeStatsProvider runtimeStatsProvider = new JVMRuntimeStatsProvider();
    private JVMThreadSystemStatsProvider threadSysStatsProvider = new JVMThreadSystemStatsProvider();
    private List<JVMGCStatsProvider> jvmStatsProviderList = new ArrayList<JVMGCStatsProvider>();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String JVM = "jvm";

    public void postConstruct() {
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"runtime", (Object)this.srtStatsProvider);
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/class-loading-system", (Object)this.clStatsProvider);
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/compilation-system", (Object)this.compileStatsProvider);
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            JVMGCStatsProvider jvmStatsProvider = new JVMGCStatsProvider(gc.getName());
            this.jvmStatsProviderList.add(jvmStatsProvider);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/garbage-collectors/" + gc.getName()), (Object)jvmStatsProvider);
        }
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/memory", (Object)this.memoryStatsProvider);
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/operating-system", (Object)this.osStatsProvider);
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/runtime", (Object)this.runtimeStatsProvider);
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/thread-system", (Object)this.threadSysStatsProvider);
        for (ThreadInfo t : this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), 5)) {
            JVMThreadInfoStatsProvider threadInfoStatsProvider = new JVMThreadInfoStatsProvider(t);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/thread-system/thread-" + t.getThreadId()), (Object)threadInfoStatsProvider);
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

