/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsProviderRegistry {
    List<StatsProviderRegistryElement> regElements = new ArrayList<StatsProviderRegistryElement>();
    private Map<String, List<StatsProviderRegistryElement>> configToRegistryElementMap = new HashMap<String, List<StatsProviderRegistryElement>>();
    private Map<Object, StatsProviderRegistryElement> statsProviderToRegistryElementMap = new HashMap<Object, StatsProviderRegistryElement>();
    private Map<String, Boolean> configEnabledMap = new HashMap<String, Boolean>();
    private MonitoringRuntimeDataRegistry mrdr;
    private boolean isAMXReady = false;
    private boolean isMBeanEnabled = true;
    static final String[] defaultConfigLevels = new String[]{"LOW", "HIGH"};
    public static Map<String, Integer> configLevelsMap = new ConcurrentHashMap<String, Integer>();

    public StatsProviderRegistry(MonitoringRuntimeDataRegistry mrdr) {
        this.mrdr = mrdr;
        for (int i = 0; i < defaultConfigLevels.length; ++i) {
            configLevelsMap.put(defaultConfigLevels[i].toUpperCase(), i);
        }
    }

    public void registerStatsProvider(StatsProviderInfo spInfo) {
        String configLevelStr = spInfo.getConfigLevel();
        if (configLevelStr == null) {
            spInfo.setConfigLevel(defaultConfigLevels[defaultConfigLevels.length - 1]);
        }
        StatsProviderRegistryElement spre = new StatsProviderRegistryElement(spInfo);
        this.initialize(spre, spInfo.getConfigElement(), spInfo.getStatsProvider());
    }

    private void initialize(StatsProviderRegistryElement spre, String configStr, Object statsProvider) {
        if (this.configToRegistryElementMap.containsKey(configStr)) {
            List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configStr);
            spreList.add(spre);
        } else {
            ArrayList<StatsProviderRegistryElement> spreList = new ArrayList<StatsProviderRegistryElement>();
            spreList.add(spre);
            this.configToRegistryElementMap.put(configStr, spreList);
        }
        this.statsProviderToRegistryElementMap.put(statsProvider, spre);
    }

    public void unregisterStatsProvider(Object statsProvider) throws Exception {
        StatsProviderRegistryElement spre = this.statsProviderToRegistryElementMap.get(statsProvider);
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(spre.getConfigStr());
        if (spreList != null) {
            spreList.remove(spre);
            if (spreList.isEmpty()) {
                this.configToRegistryElementMap.remove(spre.getConfigStr());
            }
        }
        this.statsProviderToRegistryElementMap.remove(statsProvider);
        spre.setStatsProvider(null);
    }

    StatsProviderRegistryElement getStatsProviderRegistryElement(Object statsProvider) {
        return this.statsProviderToRegistryElementMap.get(statsProvider);
    }

    List<StatsProviderRegistryElement> getStatsProviderRegistryElement(String configElement) {
        return this.configToRegistryElementMap.get(configElement);
    }

    Collection<StatsProviderRegistryElement> getSpreList() {
        return this.statsProviderToRegistryElementMap.values();
    }

    Collection<String> getConfigElementList() {
        return this.configToRegistryElementMap.keySet();
    }

    void setAMXReady(boolean ready) {
        this.isAMXReady = ready;
    }

    boolean isAMXReady() {
        return this.isAMXReady;
    }

    void setMBeanEnabled(boolean enabled) {
        this.isMBeanEnabled = enabled;
    }

    boolean isMBeanEnabled() {
        return this.isMBeanEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatsProviderRegistryElement {
        String configStr;
        PluginPoint pp;
        String subTreePath;
        String parentTreeNodePath = null;
        List<String> childTreeNodeNames = null;
        Collection<ProbeClientMethodHandle> handles = null;
        Object statsProvider;
        String mbeanName = null;
        ManagedObjectManager mom = null;
        Method resetMethod = null;
        boolean isEnabled = false;
        int configLevel;

        public StatsProviderRegistryElement(StatsProviderInfo spInfo) {
            this.configStr = spInfo.getConfigElement();
            this.pp = spInfo.getPluginPoint();
            this.subTreePath = spInfo.getSubTreeRoot();
            this.statsProvider = spInfo.getStatsProvider();
            this.mbeanName = spInfo.getSubTreeRoot();
            String configLevelStr = spInfo.getConfigLevel();
            this.configLevel = configLevelsMap.get(configLevelStr.toUpperCase());
        }

        public String getConfigStr() {
            return this.configStr;
        }

        public PluginPoint getPluginPoint() {
            return this.pp;
        }

        public String getSubTreePath() {
            return this.subTreePath;
        }

        public List<String> getChildTreeNodeNames() {
            return this.childTreeNodeNames;
        }

        public String getParentTreeNodePath() {
            return this.parentTreeNodePath;
        }

        public Collection<ProbeClientMethodHandle> getHandles() {
            return this.handles;
        }

        public Object getStatsProvider() {
            return this.statsProvider;
        }

        public void setStatsProvider(Object statsProvider) {
            this.statsProvider = statsProvider;
        }

        public String getMBeanName() {
            return this.mbeanName;
        }

        public ManagedObjectManager getManagedObjectManager() {
            return this.mom;
        }

        public void setManagedObjectManager(ManagedObjectManager mom) {
            this.mom = mom;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isEnableAllowed(String userConfigLevelStr) {
            Integer userConfigLevel = configLevelsMap.get(userConfigLevelStr.toUpperCase());
            return userConfigLevel != null && userConfigLevel >= this.configLevel;
        }

        public void setParentTreeNodePath(String completePathName) {
            this.parentTreeNodePath = completePathName;
        }

        public void setChildNodeNames(List<String> childNodeNames) {
            this.childTreeNodeNames = childNodeNames;
        }

        public void setHandles(Collection<ProbeClientMethodHandle> handles) {
            this.handles = handles;
        }

        void setResetMethod(Method method) {
            this.resetMethod = method;
        }

        Method getResetMethod() {
            return this.resetMethod;
        }

        public String toString() {
            String str = "    configStr = " + this.configStr + "\n" + "    statsProvider = " + this.statsProvider.getClass().getName() + "\n" + "    PluginPoint = " + this.pp + "\n" + "    handles = " + (this.handles == null ? "null" : "not null") + "\n" + "    parentTreeNodePath = " + this.parentTreeNodePath;
            return str;
        }
    }
}

