/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.DataSourceDefinitionHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.logging.Level;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DataSourceDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    public Class<? extends Annotation> getAnnotationType() {
        return DataSourceDefinitions.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        DataSourceDefinitions defns = (DataSourceDefinitions)ainfo.getAnnotation();
        DataSourceDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (DataSourceDefinition defn : values) {
                String defnName = DataSourceDefinitionDescriptor.getJavaName(defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.datasourcedefinitionsduplicates", "@DataSourceDefinitions cannot have multiple definitions with same name : '{0}'", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                DataSourceDefinitionHandler handler = new DataSourceDefinitionHandler();
                handler.processAnnotation(defn, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.datasourcedefinitionsfailure", "failed to handle annotation [ {0} ] on class [ {1} ] due to the following exception : ", new Object[]{element.getAnnotation(), className});
            this.logger.log(Level.WARNING, localString, message);
        }
        return result;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

