/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.connector.LicenseNode;
import com.sun.enterprise.deployment.node.connector.OutBoundRANode;
import com.sun.enterprise.deployment.node.connector.RANode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorNode
extends BundleNode<ConnectorDescriptor> {
    private ConnectorDescriptor descriptor;
    public static final String VERSION_10 = "1.0";
    public static final String VERSION_15 = "1.5";
    public static final String VERSION_16 = "1.6";
    private String specVersion;
    public static final String PUBLIC_DTD_ID_10 = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";
    public static final String SYSTEM_ID_10 = "http://java.sun.com/dtd/connector_1_0.dtd";
    public static final String PUBLIC_DTD_ID_15 = "-//Sun Microsystems, Inc.//DTD Connector 1.5//EN";
    public static final String SYSTEM_ID_15 = "http://java.sun.com/dtd/connector_1_5.dtd";
    public static final String SCHEMA_ID_15 = "connector_1_5.xsd";
    public static final String PUBLIC_DTD_ID_16 = "-//Sun Microsystems, Inc.//DTD Connector 1.6//EN";
    public static final String SYSTEM_ID_16 = "http://java.sun.com/dtd/connector_1_6.dtd";
    public static final String SCHEMA_ID_16 = "connector_1_6.xsd";
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.6//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/connector_1_6.dtd";
    public static final String SCHEMA_ID = "connector_1_6.xsd";
    public static final String SPEC_VERSION = "1.6";
    private static final List<String> systemIDs = ConnectorNode.initSystemIDs();
    public static final XMLElement tag = new XMLElement("connector");

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add("connector_1_6.xsd");
        return Collections.unmodifiableList(systemIDs);
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Connector 1.6//EN", "http://java.sun.com/dtd/connector_1_6.dtd");
        publicIDToDTD.put(PUBLIC_DTD_ID_10, SYSTEM_ID_10);
        return tag.getQName();
    }

    public ConnectorNode() {
        this.registerElementHandler(new XMLElement("license"), LicenseNode.class, "setLicenseDescriptor");
    }

    @Override
    public ConnectorDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ConnectorDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    @Override
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        this.getDescriptor();
        if (this.descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals("version")) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
            return true;
        }
        return attributeName.getQName().equals("id");
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        this.getDescriptor();
        if (this.descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if ("spec-version".equals(element.getQName())) {
            this.descriptor.setSpecVersion(value);
            this.specVersion = value;
        } else if ("version".equals(element.getQName())) {
            this.descriptor.setResourceAdapterVersion(value);
        } else if ("module-name".equals(element.getQName())) {
            ConnectorDescriptor bundleDesc = this.getDescriptor();
            bundleDesc.getModuleDescriptor().setModuleName(value);
            bundleDesc.setModuleNameSet(true);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public boolean handlesElement(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            return false;
        }
        return super.handlesElement(element);
    }

    @Override
    public XMLNode getHandlerFor(XMLElement element) {
        if ("resourceadapter".equals(element.getQName())) {
            if (VERSION_10.equals(this.specVersion)) {
                OutBoundRANode outboundRANode = new OutBoundRANode(element);
                outboundRANode.setParentNode(this);
                outboundRANode.createConDefDescriptorFor10();
                return outboundRANode;
            }
            RANode raNode = new RANode(element);
            raNode.setParentNode(this);
            return raNode;
        }
        return super.getHandlerFor(element);
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
    }

    @Override
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("vendor-name", "setVendorName");
        table.put("eis-type", "setEisType");
        table.put("resourceadapter-version", "setResourceAdapterVersion");
        table.put("required-work-context", "addRequiredWorkContext");
        return table;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return "connector_1_6.xsd";
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Node writeDescriptor(Node parent, ConnectorDescriptor conDesc) {
        conDesc.setSpecVersion(VERSION_15);
        Node connectorNode = super.writeDescriptor(parent, conDesc);
        ConnectorNode.appendTextChild(connectorNode, "vendor-name", conDesc.getVendorName());
        ConnectorNode.appendTextChild(connectorNode, "eis-type", conDesc.getEisType());
        ConnectorNode.appendTextChild(connectorNode, "resourceadapter-version", conDesc.getResourceAdapterVersion());
        for (String className : conDesc.getRequiredWorkContexts()) {
            ConnectorNode.appendTextChild(connectorNode, "required-work-context", className);
        }
        LicenseNode licenseNode = new LicenseNode();
        connectorNode = licenseNode.writeDescriptor(connectorNode, conDesc);
        RANode raNode = new RANode();
        connectorNode = raNode.writeDescriptor(connectorNode, conDesc);
        return connectorNode;
    }

    @Override
    public String getSpecVersion() {
        return "1.6";
    }

    @Override
    protected String getSchemaURL() {
        return "http://java.sun.com/xml/ns/j2ee/" + this.getSystemID();
    }
}

