/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.ValidCommand;

public class HelpException
extends Exception {
    private String command = null;
    private boolean isShell = false;

    public HelpException() {
    }

    public HelpException(String commandName) {
        this.command = commandName;
    }

    public HelpException(String[] args) {
        if (args.length < 2) {
            this.command = null;
        } else {
            int next = 1;
            if (!args[next].startsWith("--")) {
                this.command = args[next++];
            }
            if (args.length > next && args[next].equals("--shell")) {
                this.isShell = true;
            }
        }
    }

    public String getHelpClassName() {
        CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        return cliDescriptorsReader.getHelpClass();
    }

    public String getCommandName() {
        return this.command;
    }

    public String getUsageText() {
        try {
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            ValidCommand validCommand = cliDescriptorsReader.getCommand(this.command);
            return validCommand.getUsageText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isShell() {
        return this.isShell;
    }
}

