/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidCommandsList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCommands {
    private Map<String, String> allCommandsMap = null;

    private SearchCommands() throws CommandValidationException {
        CLIDescriptorsReader cdr = CLIDescriptorsReader.getInstance();
        ValidCommandsList vcl = cdr.getCommandsList();
        Iterator commands = vcl.getCommands();
        this.allCommandsMap = new Hashtable<String, String>();
        while (commands.hasNext()) {
            ValidCommand command = (ValidCommand)commands.next();
            String usageText = command.getUsageText();
            if (usageText == null || usageText.length() <= 0) continue;
            this.allCommandsMap.put(command.getName(), command.getUsageText());
        }
    }

    public static String[] getAllCommands() throws CommandValidationException {
        return new SearchCommands().allCommands();
    }

    public static String[] getMatchedCommands(String pattern) throws CommandException, CommandValidationException {
        return new SearchCommands().findCommands(pattern);
    }

    public static String[] getMatchedCommands(String pattern, Map<String, String> moreCommands) throws CommandException, CommandValidationException {
        return new SearchCommands().findCommands(pattern, moreCommands);
    }

    private String[] allCommands() {
        Set<String> set = this.allCommandsMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    private String[] findCommands(String pattern, Map<String, String> moreCommands) throws CommandException {
        if (moreCommands != null) {
            this.allCommandsMap.putAll(moreCommands);
        }
        return this.findCommands(pattern);
    }

    private String[] findCommands(String pattern) throws CommandException {
        try {
            Vector<String> allCommandsList = new Vector<String>(this.allCommandsMap.keySet());
            Collections.sort(allCommandsList);
            Vector matchedCommands = new Vector();
            int ii = 0;
            while (ii + 1 < allCommandsList.size()) {
                if (((String)allCommandsList.get(ii)).matches(pattern)) {
                    matchedCommands.add(allCommandsList.get(ii));
                }
                ++ii;
            }
            return matchedCommands.toArray(new String[matchedCommands.size()]);
        }
        catch (PatternSyntaxException pse) {
            throw new CommandException("InvalidPattern", pse);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

