/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public final class LineTokenReplacer {
    private final TokenValue[] tokenArray;
    private final String charsetName;

    public LineTokenReplacer(TokenValueSet tokens) {
        this(tokens, null);
    }

    public LineTokenReplacer(TokenValueSet tokens, String charset) {
        Object[] tmp = tokens.toArray();
        int length = tmp.length;
        this.tokenArray = new TokenValue[length];
        System.arraycopy(tmp, 0, this.tokenArray, 0, length);
        this.charsetName = charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replace(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(inputFile));
                if (this.charsetName != null) {
                    FileOutputStream outputStream = new FileOutputStream(outputFile);
                    Charset charset = Charset.forName(this.charsetName);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, charset));
                } else {
                    writer = new BufferedWriter(new FileWriter(outputFile));
                }
                String lineContents = null;
                while ((lineContents = reader.readLine()) != null) {
                    String modifiedLine = this.replaceLine(lineContents);
                    writer.write(modifiedLine);
                    writer.newLine();
                }
                Object var8_8 = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (reader != null) {
            reader.close();
        }
        if (writer == null) return;
        writer.close();
        return;
    }

    public void replace(String inputFileName, String outputFileName) {
        this.replace(new File(inputFileName), new File(outputFileName));
    }

    private String replaceLine(String lineWithTokens) {
        String tokenFreeString = lineWithTokens;
        for (int i = 0; i < this.tokenArray.length; ++i) {
            TokenValue aPair = this.tokenArray[i];
            tokenFreeString = tokenFreeString.replace(aPair.delimitedToken, aPair.value);
        }
        return tokenFreeString;
    }
}

