/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsProbeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class RealmsManager {
    private final Hashtable<String, Realm> loadedRealms = new Hashtable();
    private volatile String defaultRealmName = "default";
    private final RealmsProbeProvider probeProvider = new RealmsProbeProvider();

    public boolean isValidRealm(String name) {
        if (name == null) {
            return false;
        }
        return this.loadedRealms.containsKey(name);
    }

    public Enumeration<String> getRealmNames() {
        return this.loadedRealms.keys();
    }

    Realm _getInstance(String name) {
        Realm retval = null;
        retval = this.loadedRealms.get(name);
        if (retval == null && "default".equals(name)) {
            retval = this.loadedRealms.get(this.getDefaultRealmName());
        }
        return retval;
    }

    public void removeFromLoadedRealms(String realmName) {
        Realm r = this.loadedRealms.remove(realmName);
        if (r != null) {
            this.probeProvider.realmRemovedEvent(realmName);
        }
    }

    void putIntoLoadedRealms(String realmName, Realm realm) {
        this.loadedRealms.put(realmName, realm);
        this.probeProvider.realmAddedEvent(realmName);
    }

    public Realm getFromLoadedRealms(String realmName) {
        return this.loadedRealms.get(realmName);
    }

    public synchronized String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public synchronized void setDefaultRealmName(String defaultRealmName) {
        this.defaultRealmName = defaultRealmName;
    }

    public List<String> getPredefinedAuthRealmClassNames() {
        Habitat habitat = Globals.getDefaultHabitat();
        Collection collection = habitat.getInhabitants(Realm.class);
        ArrayList<String> arr = new ArrayList<String>();
        for (Inhabitant it : collection) {
            arr.add(it.typeName());
        }
        return arr;
    }
}

