/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class UpgradeLogging
implements ConfigurationUpgrade,
PostConstruct {
    @Inject(name="server-config")
    Config config;
    @Inject
    LoggingConfigImpl logConfig;

    public void postConstruct() {
        LogService logService = this.config.getLogService();
        if (logService == null) {
            return;
        }
        try {
            RepositoryConfig rc = new RepositoryConfig();
            String configDir = rc.getRepositoryRoot() + File.separator + rc.getRepositoryName() + File.separator + rc.getInstanceName() + File.separator + "config";
            PEFileLayout layout = new PEFileLayout(rc);
            File src = new File(layout.getTemplatesDir(), "logging.properties");
            File dest = new File(configDir, "logging.properties");
            if (!dest.exists()) {
                FileUtils.copy((File)src, (File)dest);
            }
        }
        catch (IOException ioe) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading log-service. Could not create logging.properties file. ", ioe);
        }
        try {
            ModuleLogLevels mll = logService.getModuleLogLevels();
            Map logLevels = mll.getAllLogLevels();
            String file = logService.getFile();
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            if (file.contains(instanceRoot)) {
                file = file.replace(instanceRoot, "${com.sun.aas.instanceRoot}");
            }
            logLevels.put("file", file);
            logLevels.put("use-system-logging", logService.getUseSystemLogging());
            logLevels.put("log-handler", logService.getLogHandler());
            logLevels.put("log-filter", logService.getLogFilter());
            logLevels.put("log-to-console", logService.getLogToConsole());
            logLevels.put("log-rotation-limit-in-bytes", logService.getLogRotationLimitInBytes());
            logLevels.put("log-rotation-timelimit-in-minutes", logService.getLogRotationTimelimitInMinutes());
            logLevels.put("alarms", logService.getAlarms());
            logLevels.put("retain-error-statistics-for-hours", logService.getRetainErrorStatisticsForHours());
            final HashMap m = new HashMap(logLevels);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config c) throws PropertyVetoException, TransactionFailure {
                    try {
                        UpgradeLogging.this.logConfig.updateLoggingProperties(m);
                        c.setLogService(null);
                    }
                    catch (IOException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading log-service. Could not update logging.properties file. ", e);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.config);
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading log-service ", tf);
            throw new RuntimeException(tf);
        }
    }
}

