/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.cluster.InstanceCommandExecutor;
import com.sun.enterprise.v3.admin.cluster.Target;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);
    private FailurePolicy onFailure = FailurePolicy.Error;
    private FailurePolicy ifOffline = FailurePolicy.Warn;

    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        CommandModel model;
        try {
            CommandModelProvider c = (CommandModelProvider)command;
            model = c.getModel();
        }
        catch (ClassCastException e) {
            model = new CommandModelImpl(command.getClass());
        }
        Cluster clAnnotation = model.getClusteringAttributes();
        if (clAnnotation != null) {
            if (clAnnotation.ifFailure() != null) {
                this.onFailure = clAnnotation.ifFailure();
            }
            if (clAnnotation.ifOffline() != null) {
                this.ifOffline = clAnnotation.ifOffline();
            }
        }
        if (this.serverEnv.isDas()) {
            if (parameters.getOne((Object)"target") == null) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargetspecified", "A target was not specified in the command line; aborting further execution of CLI"));
                return this.getReturnValueFor(this.onFailure);
            }
            Target target = new Target((String)parameters.getOne((Object)"target"), this.domain);
            List<Server> instancesForReplication = target.getInstances();
            if (instancesForReplication.size() == 0) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Unable to find instances for target {0}", new Object[]{target}));
                return this.getReturnValueFor(this.onFailure);
            }
            return this.replicateCommand(commandName, instancesForReplication, context, parameters);
        }
        return ActionReport.ExitCode.SUCCESS;
    }

    private ActionReport.ExitCode replicateCommand(String commandName, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters) {
        ActionReport.ExitCode returnValue;
        block5: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            try {
                List<InstanceCommandExecutor> execList = this.getInstanceCommandList(commandName, instancesForReplication, context.getLogger());
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    try {
                        String result = rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command " + commandName + "executed successfully on server instance " + rac.getServer().getName() + ";" + result, new Object[]{commandName, rac.getServer().getName()}));
                    }
                    catch (CommandException cmdEx) {
                        aReport.setActionExitCode(this.getReturnValueFor(this.onFailure));
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command " + commandName + "failed on server instance " + rac.getServer().getName() + ":", new Object[]{commandName, rac.getServer().getName()}));
                        aReport.setFailureCause((Throwable)cmdEx);
                        if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) continue;
                        returnValue = this.getReturnValueFor(this.onFailure);
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(this.getReturnValueFor(this.onFailure));
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                aReport.setFailureCause((Throwable)ex);
                context.getLogger().severe(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) break block5;
                returnValue = this.getReturnValueFor(this.onFailure);
            }
        }
        return returnValue;
    }

    private List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        for (Server svr : servers) {
            String host = svr.getNodeAgentRef();
            NetworkListener adminListener = this.domain.getConfigs().getConfigByName(svr.getConfigRef()).getNetworkConfig().getNetworkListener("admin-listener");
            String portStr = adminListener.getPort();
            int port = 4848;
            List sprops = svr.getSystemProperty();
            for (SystemProperty p : sprops) {
                if (!"ASADMIN_LISTENER_PORT".equals(p.getName())) continue;
                port = Integer.parseInt(p.getValue());
                break;
            }
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }

    private ActionReport.ExitCode getReturnValueFor(FailurePolicy policy) {
        ActionReport.ExitCode retValue = ActionReport.ExitCode.FAILURE;
        switch (policy) {
            case Ignore: {
                retValue = ActionReport.ExitCode.SUCCESS;
                break;
            }
            case Error: {
                retValue = ActionReport.ExitCode.FAILURE;
                break;
            }
            case Warn: {
                retValue = ActionReport.ExitCode.WARNING;
            }
        }
        return retValue;
    }
}

