/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-local-instance")
@Scoped(value=PerLookup.class)
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    @Param(name="filesystemonly", optional=true, defaultValue="false")
    private boolean filesystemOnly = false;
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    public static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        if (this.configName != null && this.clusterName != null) {
            throw new CommandValidationException(strings.get("ConfigClusterConflict"));
        }
        super.validate();
        if (!this.rendezvousWithDAS()) {
            throw new CommandValidationException(strings.get("Unable to rendezvous with DAS on host={0}, port={1}, protocol={2}", new Object[]{this.DASHost, this.DASPort, this.DASProtocol}));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        int exitCode = -1;
        int exitCodeRegister = -1;
        if (!this.filesystemOnly) {
            exitCodeRegister = this.registerToDAS();
        }
        exitCode = exitCodeRegister == 0 ? super.executeCommand() : exitCodeRegister;
        return exitCode;
    }

    private boolean rendezvousWithDAS() {
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("uptime", this.DASHost, this.DASPort, this.dasIsSecure, "admin", null, logger.getLogger());
            rac.setConnectTimeout(10000);
            ParameterMap map = new ParameterMap();
            rac.executeCommand(map);
            return true;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private int registerToDAS() throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "create-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this.nodeAgent != null) {
            argsList.add("--nodeagent");
            argsList.add(this.nodeAgent);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("create-instance", this.programOpts, this.env);
        return rc.execute(argsArray);
    }
}

