/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.StartServerCommand;
import com.sun.enterprise.admin.cli.StartServerHelper;
import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.ObjectAnalyzer;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="start-local-instance")
@Scoped(value=PerLookup.class)
public class StartLocalInstanceCommand
extends LocalInstanceCommand
implements StartServerCommand {
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(name="instance_name", primary=true, optional=false)
    private String instanceName0;
    private StartServerHelper helper;
    private String localPassword;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartLocalInstanceCommand.class);
    private static final String MASTER_PASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private GFLauncherInfo info;
    private GFLauncher launcher;

    public RuntimeType getType() {
        return RuntimeType.INSTANCE;
    }

    protected void validate() throws CommandException, CommandValidationException {
        if (!StartLocalInstanceCommand.ok((String)this.instanceName0)) {
            throw new CommandValidationException(strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        logger.printDebugMessage(this.toString());
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv, this.debug);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            this.launcher.launch();
            if (this.verbose || this.upgrade) {
                while (this.launcher.getExitValue() == 10) {
                    logger.printMessage(strings.get("restart"));
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
                return this.launcher.getExitValue();
            }
            this.helper.waitForServer();
            this.helper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.launcher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.info = this.launcher.getInfo();
        this.info.setInstanceName(this.instanceName);
        this.info.setInstanceRootDir(this.instanceDir);
        this.info.setVerbose(this.verbose || this.upgrade);
        this.info.setDebug(this.debug);
        this.info.setUpgrade(this.upgrade);
        this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.programOpts.getProgramArguments());
        this.launcher.setup();
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }
}

