/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-instance")
@Scoped(value=PerLookup.class)
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopLocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    protected void initInstance() throws CommandException {
        if (this.isLocalInstance()) {
            super.initInstance();
        } else if (this.userArgInstanceName != null) {
            throw new CommandException(strings.get("StopInstance.noInstanceNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        String serverName = this.getServerDirs().getServerName();
        boolean isLocal = StopLocalInstanceCommand.ok((String)serverName);
        if (isLocal) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.instanceNotRunning();
            }
            int adminPort = this.getAdminPort(serverName);
            this.programOpts.setPort(adminPort);
            logger.printDebugMessage("StopInstance.stoppingMessage" + adminPort);
            this.programOpts.setInteractive(false);
            File serverDir = this.getServerDirs().getServerDir();
            if (!this.isThisServer(serverDir, "Instance-Root_value")) {
                return this.instanceNotRunning();
            }
            logger.printDebugMessage("It's the correct Instance");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.instanceNotRunning();
            }
            logger.printDebugMessage("Instance is running remotely");
            this.programOpts.setInteractive(false);
        }
        return this.doRemoteCommand();
    }

    private int instanceNotRunning() throws CommandException, CommandValidationException {
        logger.printWarning(strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private boolean isLocalInstance() {
        return this.programOpts.getHost().equals("localhost");
    }

    private final int doRemoteCommand() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand(this.getName(), this.programOpts, this.env);
        cmd.executeAndReturnOutput(new String[]{"stop-domain"});
        this.waitForDeath();
        return 0;
    }

    private void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(strings.get("StopInstance.waitForDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(strings.get("StopInstance.instanceNotDead", new Object[]{60}));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

