/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.AMXConfigLoader;
import org.glassfish.admin.amx.impl.config.AMXConfigStartupServiceMBean;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.util.TimingDelta;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Transactions;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@Service
public final class AMXConfigStartupService
implements PostConstruct,
PreDestroy,
AMXConfigStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private volatile PendingConfigBeans mPendingConfigBeans;
    @Inject
    private Transactions mTransactions;
    private volatile AMXConfigLoader mLoader;

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        if (this.mPendingConfigBeans == null) {
            throw new Error("AMXStartup: null mPendingConfigBeans");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, AMXConfigStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized AMXConfig Startup service in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("AMXConfigStartupService.preDestroy(): stopping AMX");
        this.unloadAMXMBeans();
    }

    public DomainRoot getDomainRoot() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName getDomainConfig() {
        return this.getDomainRoot().child(Domain.class).extra().objectName();
    }

    public Domain getDomainConfigProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getDomainConfig(), Domain.class);
    }

    public synchronized ObjectName loadAMXMBeans() {
        if (this.mLoader == null) {
            this.mLoader = new AMXConfigLoader(this.mMBeanServer, this.mPendingConfigBeans, this.mTransactions);
            this.mLoader.start();
        }
        return this.getDomainConfig();
    }

    public synchronized void unloadAMXMBeans() {
        Domain domainConfig = this.getDomainConfigProxy();
        if (domainConfig != null) {
            ImplUtil.unregisterAMXMBeans((AMXProxy)domainConfig);
        }
        this.mLoader = null;
    }
}

