/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.MasterPasswordImpl;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecuritySupportImpl
implements SecuritySupport {
    private static final String keyStoreProp = "javax.net.ssl.keyStore";
    private static final String trustStoreProp = "javax.net.ssl.trustStore";
    protected static final Logger _logger = LogDomains.getLogger(SecuritySupportImpl.class, (String)"javax.enterprise.system.core.security");
    protected static boolean initialized = false;
    protected static final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    protected static final List<KeyStore> trustStores = new ArrayList<KeyStore>();
    protected static final List<String> keyStorePasswords = new ArrayList<String>();
    protected static final List<String> tokenNames = new ArrayList<String>();
    private MasterPasswordImpl masterPasswordHelper = null;
    private static boolean instantiated = false;

    public SecuritySupportImpl() {
        this(true);
    }

    protected SecuritySupportImpl(boolean init) {
        if (init) {
            this.initJKS();
        }
    }

    protected void initJKS() {
        String keyStoreFileName = null;
        String trustStoreFileName = null;
        if (Util.isEmbeddedServer()) {
            try {
                keyStoreFileName = Util.writeConfigFileToTempDir("keystore.jks").getAbsolutePath();
                trustStoreFileName = Util.writeConfigFileToTempDir("cacerts.jks").getAbsolutePath();
            }
            catch (IOException ex) {
                _logger.log(Level.SEVERE, "Error obtaining keystore and truststore files for embedded server", ex);
            }
        } else {
            keyStoreFileName = System.getProperty(keyStoreProp);
            trustStoreFileName = System.getProperty(trustStoreProp);
        }
        char[] keyStorePass = null;
        char[] trustStorePass = null;
        if (!SecuritySupportImpl.isInstantiated()) {
            if (this.masterPasswordHelper == null && Globals.getDefaultHabitat() != null) {
                this.masterPasswordHelper = (MasterPasswordImpl)Globals.getDefaultHabitat().getByType(MasterPasswordImpl.class);
            }
            if (this.masterPasswordHelper instanceof MasterPasswordImpl) {
                trustStorePass = keyStorePass = this.masterPasswordHelper.getMasterPassword();
            }
        }
        if (keyStorePass == null) {
            keyStorePass = System.getProperty("javax.net.ssl.keyStorePassword", "changeit").toCharArray();
            trustStorePass = System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
        }
        if (!initialized) {
            SecuritySupportImpl.loadStores(null, null, keyStoreFileName, keyStorePass, SSLUtils.getKeyStoreType(), trustStoreFileName, trustStorePass, SSLUtils.getTrustStoreType());
            Arrays.fill(keyStorePass, ' ');
            Arrays.fill(trustStorePass, ' ');
            initialized = true;
        }
    }

    private static synchronized boolean isInstantiated() {
        if (!instantiated) {
            instantiated = true;
            return false;
        }
        return true;
    }

    protected static synchronized void loadStores(String tokenName, Provider provider, String keyStoreFile, char[] keyStorePass, String keyStoreType, String trustStoreFile, char[] trustStorePass, String trustStoreType) {
        try {
            KeyStore keyStore = SecuritySupportImpl.loadKS(keyStoreType, provider, keyStoreFile, keyStorePass);
            KeyStore trustStore = SecuritySupportImpl.loadKS(trustStoreType, provider, trustStoreFile, trustStorePass);
            keyStores.add(keyStore);
            trustStores.add(trustStore);
            keyStorePasswords.add(new String(keyStorePass));
            tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKS(String keyStoreType, Provider provider, String keyStoreFile, char[] keyStorePass) throws Exception {
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] passphrase = keyStorePass;
        FileInputStream istream = null;
        BufferedInputStream bstream = null;
        try {
            if (keyStoreFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = " + keyStoreFile + ", keystorePass = " + keyStorePass);
                }
                istream = new FileInputStream(keyStoreFile);
                bstream = new BufferedInputStream(istream);
            }
            ks.load(bstream, passphrase);
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        return ks;
    }

    public KeyStore[] getKeyStores() {
        return keyStores.toArray(new KeyStore[keyStores.size()]);
    }

    public KeyStore[] getTrustStores() {
        return trustStores.toArray(new KeyStore[trustStores.size()]);
    }

    public String[] getKeyStorePasswords() {
        SSLUtils.checkPermission("javax.net.ssl.keyStorePassword");
        return keyStorePasswords.toArray(new String[keyStorePasswords.size()]);
    }

    public String[] getTokenNames() {
        return tokenNames.toArray(new String[tokenNames.size()]);
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return trustStores.get(idx);
    }

    public String getKeyStorePassword(String token) {
        SSLUtils.checkPermission("javax.net.ssl.keyStorePassword");
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return keyStorePasswords.get(idx);
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = tokenNames.indexOf(token)) < 0 && _logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "token " + token + " is not found");
        }
        return idx;
    }

    public void synchronizeKeyFile(Object configContext, String fileRealmName) throws Exception {
    }

    public PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        SSLUtils.checkPermission("javax.net.ssl.keyStorePassword");
        Key key = keyStores.get(keystoreIndex).getKey(alias, keyStorePasswords.get(keystoreIndex).toCharArray());
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }
}

