/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.io.DomainDirs;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-domains")
@Scoped(value=PerLookup.class)
public final class ListDomainsCommand
extends LocalDomainCommand {
    @Param(name="domaindir", optional=true)
    private String domainDirParam = null;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);
    private String domainsRoot = null;

    protected void initDomain() throws CommandException {
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            DomainConfig domainConfig = new DomainConfig(null, this.getDomainsRoot());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            this.programOpts.setInteractive(false);
            if (domainsList.length > 0) {
                for (String dn : domainsList) {
                    String status = this.getStatus(dn);
                    String dname = strings.get("list.domains.Name");
                    logger.printMessage(dname + " " + dn + " " + status);
                }
            } else {
                logger.printDetailMessage(strings.get("NoDomainsToList"));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return 0;
    }

    protected String getDomainsRoot() throws CommandException {
        if (this.domainsRoot != null) {
            return this.domainsRoot;
        }
        try {
            File domainsDirFile;
            File file = domainsDirFile = ListDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
            if (!domainsDirFile.isDirectory()) {
                throw new CommandException(strings.get("InvalidDomainPath", new Object[]{domainsDirFile.toString()}));
            }
            this.domainsRoot = SmartFile.sanitize((String)domainsDirFile.getAbsolutePath());
            return this.domainsRoot;
        }
        catch (IOException ioe) {
            throw new CommandException(strings.get("InvalidDomainPath", new Object[]{ioe.getLocalizedMessage()}));
        }
    }

    private String getStatus(String dn) throws IOException, CommandException {
        try {
            GFLauncher launcher = GFLauncherFactory.getInstance((RuntimeType)RuntimeType.DAS);
            GFLauncherInfo li = launcher.getInfo();
            String parent = this.getDomainsRoot();
            if (parent != null) {
                li.setDomainParentDir(parent);
            }
            li.setDomainName(dn);
            launcher.setup();
            this.setServerDirs(new ServerDirs(li.getInstanceRootDir()));
            this.programOpts.setPort(li.getAnAdminPort());
            boolean status = this.isThisDAS(SmartFile.sanitize((File)li.getInstanceRootDir()));
            if (status) {
                try {
                    RemoteCommand cmd = new RemoteCommand("_get-restart-required", this.programOpts, this.env);
                    String restartRequired = cmd.executeAndReturnOutput(new String[]{"_get-restart-required"});
                    if (Boolean.parseBoolean(restartRequired.trim())) {
                        return strings.get("list.domains.StatusRestartRequired");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return strings.get("list.domains.StatusRunning");
            }
            return strings.get("list.domains.StatusNotRunning");
        }
        catch (GFLauncherException gf) {
            logger.printExceptionStackTrace((Throwable)gf);
            return strings.get("list.domains.StatusUnknown");
        }
        catch (MiniXmlParserException me) {
            logger.printExceptionStackTrace((Throwable)me);
            return strings.get("list.domains.StatusUnknown");
        }
    }
}

