/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandValidationException;

public abstract class BackupCommands
extends LocalDomainCommand {
    BackupRequest request;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupCommands.class);
    @Param(name="verbose", optional=true)
    boolean verbose;
    @Param(name="description", optional=true)
    String desc;
    @Param(name="domain_name", primary=true, optional=true)
    String domainName;

    protected void checkOptions() throws CommandValidationException {
        File domainFile;
        File domainsDirFile;
        if (this.verbose && this.programOpts.isTerse()) {
            throw new CommandValidationException(strings.get("NoVerboseAndTerseAtTheSameTime"));
        }
        if (this.domainDirParam == null || this.domainDirParam.length() <= 0) {
            this.domainDirParam = this.getDomainsDir().getPath();
        }
        if (!(domainsDirFile = new File(this.domainDirParam)).isDirectory()) {
            throw new CommandValidationException(strings.get("InvalidDomainPath", new Object[]{this.domainDirParam}));
        }
        if (this.domainName == null) {
            this.domainName = this.getDomainName();
        }
        if (!(domainFile = new File(domainsDirFile, this.domainName)).isDirectory() || !domainFile.canWrite()) {
            throw new CommandValidationException(strings.get("InvalidDirectory", new Object[]{domainFile.getPath()}));
        }
    }

    protected void prepareRequest() {
        this.request = new BackupRequest(this.domainDirParam, this.domainName, this.desc);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

