/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupManager;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="backup-domain")
@Scoped(value=PerLookup.class)
public final class BackupDomainCommand
extends BackupCommands {
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupDomainCommand.class);

    protected void validate() throws CommandException {
        super.validate();
        this.checkOptions();
        if (DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
            throw new CommandException(strings.get("DomainIsNotStopped", new Object[]{this.domainName}));
        }
        this.prepareRequest();
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException {
        try {
            BackupManager mgr = new BackupManager(this.request);
            logger.printMessage(mgr.backup());
        }
        catch (BackupWarningException bwe) {
            logger.printMessage(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException((Throwable)be);
        }
        return 0;
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

