/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployapi.ProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.RemoteDeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private static final String DEFAULT_SERVER_NAME = "server";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteDeploymentFacility.class);
    private static final String LIST_COMMAND = "list";
    private static final String LIST_SUB_COMPONENTS_COMMAND = "list-sub-components";
    private static final String GET_CLIENT_STUBS_COMMAND = "get-client-stubs";
    private static final String GET_COMMAND = "get";
    private boolean connected;
    private TargetImpl domain;
    private ServerConnectionIdentifier targetDAS;
    private Map<String, String> targetModuleWebURLs = new HashMap<String, String>();

    protected abstract DFCommandRunner getDFCommandRunner(String var1, Map<String, Object> var2, String[] var3) throws CommandException;

    protected DFProgressObject changeState(Target[] targets, String moduleID, String commandName, String successStatusKey, String successStatusDefaultMessage, String failureStatusKey, String failureStatusDefaultMessage) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString(successStatusKey, successStatusDefaultMessage, new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    protected abstract boolean doConnect();

    @Override
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        this.connected = true;
        this.targetDAS = targetDAS;
        this.domain = new TargetImpl(this, "domain", localStrings.getLocalString("enterprise.deployment.client.administrative_domain", "administrative-domain"));
        return this.doConnect();
    }

    protected abstract boolean doDisconnect();

    @Override
    public boolean disconnect() {
        this.connected = false;
        this.domain = null;
        this.targetDAS = null;
        return this.doDisconnect();
    }

    @Override
    public DFProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    @Override
    public Target createTarget(String name) {
        return new TargetImpl(this, name, "");
    }

    @Override
    public Target[] createTargets(String[] targets) {
        if (targets == null) {
            targets = new String[]{};
        }
        Target[] result = new TargetImpl[targets.length];
        int i = 0;
        for (String name : targets) {
            result[i++] = new TargetImpl(this, name, "");
        }
        return result;
    }

    protected String createTargetsParam(Target[] targets) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < targets.length; ++i) {
            sb.append(targets[i].getName());
            if (i == targets.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public DFProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DFProgressObject deploy(Target[] targets, ReadableArchive source, ReadableArchive deploymentPlan, Map deploymentOptions) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        File tempSourceFile = null;
        File tempPlanFile = null;
        if (source instanceof MemoryMappedArchive) {
            try {
                String type = (String)deploymentOptions.remove("type");
                tempSourceFile = this.writeMemoryMappedArchiveToTempFile((MemoryMappedArchive)source, this.getSuffixFromType(type));
                URI tempPlanURI = null;
                if (deploymentPlan != null && deploymentPlan instanceof MemoryMappedArchive) {
                    tempPlanFile = this.writeMemoryMappedArchiveToTempFile((MemoryMappedArchive)deploymentPlan, ".jar");
                    tempPlanURI = tempPlanFile.toURI();
                }
                DFProgressObject dFProgressObject = this.deploy(targets, tempSourceFile.toURI(), tempPlanURI, deploymentOptions);
                return dFProgressObject;
            }
            finally {
                if (tempSourceFile != null) {
                    tempSourceFile.delete();
                }
                if (tempPlanFile != null) {
                    tempPlanFile.delete();
                }
            }
        }
        if (deploymentPlan == null) {
            return this.deploy(targets, source.getURI(), null, deploymentOptions);
        }
        return this.deploy(targets, source.getURI(), deploymentPlan.getURI(), deploymentOptions);
    }

    private File writeMemoryMappedArchiveToTempFile(MemoryMappedArchive mma, String fileSuffix) throws IOException {
        int actual;
        File tempFile = File.createTempFile("jsr88-", fileSuffix);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
        int chunkSize = 32768;
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(mma.getByteArray()));
        for (long remaining = mma.getArchiveSize(); remaining != 0L; remaining -= (long)actual) {
            actual = remaining < (long)chunkSize ? (int)remaining : chunkSize;
            byte[] bytes = new byte[actual];
            try {
                bis.read(bytes);
                bos.write(bytes);
                continue;
            }
            catch (EOFException eof) {
                break;
            }
        }
        bos.flush();
        return tempFile;
    }

    @Override
    public DFProgressObject deploy(Target[] targets, URI source, URI deploymentPlan, Map deploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        deploymentOptions.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        if (source == null) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_specified", "Archive to be deployed is not specified at all."), this.domain);
            return po;
        }
        File tmpFile = new File(source.getSchemeSpecificPart());
        if (!tmpFile.exists()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_in_location", "Unable to find the archive to be deployed in specified location."), this.domain);
            return po;
        }
        if (!tmpFile.canRead()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_no_read_permission", "Archive to be deployed does not have read permission."), this.domain);
            return po;
        }
        boolean isDirectoryDeploy = tmpFile.isDirectory();
        try {
            if (deploymentPlan != null) {
                File dp = new File(deploymentPlan.getSchemeSpecificPart());
                if (!dp.exists()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_not_in_location", "Unable to find the deployment plan in specified location."), this.domain);
                    return po;
                }
                if (!dp.canRead()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_no_read_permission", "Deployment plan does not have read permission."), this.domain);
                    return po;
                }
                deploymentOptions.put("deploymentplan", dp.getAbsolutePath());
            }
            if (Boolean.valueOf((String)deploymentOptions.remove("redeploy")).booleanValue()) {
                String appName = (String)deploymentOptions.get("name");
                String enabledAttr = this.getAppRefEnabledAttr(targets[0].getName(), appName);
                deploymentOptions.put("enabled", enabledAttr);
            }
            DFCommandRunner commandRunner = this.getDFCommandRunner("deploy", deploymentOptions, new String[]{tmpFile.getAbsolutePath()});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            String moduleID = mainStatus.getProperty("name");
            po.setModuleID(moduleID);
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application", "Deployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0}", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "disable", "enterprise.deployment.client.disable_application", "Application {0} disabled successfully", "enterprise.deployment.client.disable_application_failed", "Attempt to disable application {0} failed");
    }

    @Override
    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        throw new UnsupportedOperationException("Not supported in v3");
    }

    @Override
    public DFProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "enable", "enterprise.deployment.client.enable_application", "Application {0} enabled successfully", "enterprise.deployment.client.enable_application_failed", "Attempt to enable application {0} failed");
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.client.disconnected_state", "Not connected to the Domain Admin Server"));
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public List<String> getSubModuleInfoForJ2EEApplication(String appName) throws IOException {
        this.ensureConnected();
        String commandName = LIST_SUB_COMPONENTS_COMMAND;
        String[] operands = new String[]{appName};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> subModuleInfoList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    if (subStage.getProperty("moduleInfo") == null) continue;
                    subModuleInfoList.add(subStage.getProperty("moduleInfo"));
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return subModuleInfoList;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    private String getAppRefEnabledAttr(String target, String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "servers.server." + target + ".application-ref." + moduleName + ".enabled";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            String enabledAttr = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                if (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    enabledAttr = this.getValueFromDottedNameGetResult(result);
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return enabledAttr;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public String getContextRoot(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "applications.application." + moduleName + ".context-root";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            String contextRoot = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                if (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    contextRoot = this.getValueFromDottedNameGetResult(result);
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return contextRoot;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public ModuleType getModuleType(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "applications.application." + moduleName + ".*";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> resultList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    resultList.add(subStage.getStageStatusMessage());
                }
                return this.getJavaEEModuleTypeFromResult(resultList);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public Target[] listTargets() throws IOException {
        this.ensureConnected();
        String commandName = LIST_COMMAND;
        String[] operands = new String[]{"servers.server"};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<Target> targets = new ArrayList<Target>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    String targetName = this.getValueFromDottedNameListResult(result);
                    targets.add(this.createTarget(targetName));
                }
                Target[] result = new Target[targets.size()];
                return targets.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public void getClientStubs(String location, String moduleID) throws IOException {
        this.ensureConnected();
        String commandName = GET_CLIENT_STUBS_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("appname", moduleID);
        String[] operands = new String[]{location};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() == DFDeploymentStatus.Status.FAILURE) {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public HostAndPort getHostAndPort(String target) throws IOException {
        return this.getHostAndPort(target, false);
    }

    @Override
    public HostAndPort getHostAndPort(String target, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, securityEnabled);
    }

    @Override
    public HostAndPort getVirtualServerHostAndPort(String target, String virtualServer, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, virtualServer, securityEnabled);
    }

    @Override
    public HostAndPort getHostAndPort(String target, String moduleId, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, moduleId, null, securityEnabled);
    }

    private HostAndPort getHostAndPort(String target, String moduleId, String virtualServer, boolean securityEnabled) throws IOException {
        this.ensureConnected();
        String commandName = "get-host-and-port";
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", target);
        if (moduleId != null) {
            commandParams.put("moduleId", moduleId);
        }
        if (virtualServer != null) {
            commandParams.put("virtualServer", virtualServer);
        }
        commandParams.put("securityEnabled", new Boolean(securityEnabled));
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            HostAndPort hap = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String hostPortStr = mainStatus.getStageStatusMessage();
                if (hostPortStr != null && !hostPortStr.trim().equals("")) {
                    hap = new HostAndPort(hostPortStr);
                }
                return hap;
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        return this.listAppRefs(targets, "all");
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets, String state) throws IOException {
        return this.listAppRefs(targets, state, null);
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets, String state, String type) throws IOException {
        Target[] targetImpls = this.prepareTargets(this.createTargets(targets));
        return this.listAppRefs(targetImpls, state, type);
    }

    @Override
    public TargetModuleID[] listAppRefs(Target[] targets, String state, String type) throws IOException {
        this.ensureConnected();
        String commandName = "list-app-refs";
        String targetsParam = this.createTargetsParam(targets);
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", targetsParam);
        commandParams.put("state", state);
        if (type != null) {
            commandParams.put("type", type);
        }
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String targetName = mainStatus.getStageStatusMessage();
                for (Target target : targets) {
                    if (!target.getName().equals(targetName)) continue;
                    Iterator appRefIter = mainStatus.getSubStages();
                    while (appRefIter.hasNext()) {
                        DFDeploymentStatus appRefSubStage = (DFDeploymentStatus)appRefIter.next();
                        String moduleID = appRefSubStage.getStageStatusMessage();
                        if (!(target instanceof TargetImpl)) continue;
                        TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                        targetModuleIDList.add(targetModuleID);
                    }
                }
                TargetModuleIDImpl[] result = new TargetModuleIDImpl[targetModuleIDList.size()];
                return targetModuleIDList.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    private Target[] prepareTargets(Target[] targets) {
        if (targets == null || targets.length == 0) {
            targets = new Target[]{this.targetForDefaultServer()};
        }
        if (targets.length > 1) {
            throw new UnsupportedOperationException("Multiple targets not supported in v3");
        }
        return targets;
    }

    private Target targetForDefaultServer() {
        TargetImpl t = new TargetImpl(this, DEFAULT_SERVER_NAME, localStrings.getLocalString("enterprise.deployment.client.default_server_description", "default server"));
        return t;
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, new HashMap());
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID, Map undeploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        undeploymentOptions.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner("undeploy", undeploymentOptions, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application", "Undeployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public String exportClientStubs(String appName, String destDir) throws IOException {
        this.getClientStubs(destDir, appName);
        return destDir + appName + "Client.jar";
    }

    @Override
    public DFDeploymentStatus waitFor(DFProgressObject po) {
        return po.waitFor();
    }

    @Override
    public String getWebURL(TargetModuleID tmid) {
        return this.targetModuleWebURLs.get(tmid.getModuleID());
    }

    @Override
    public void setWebURL(TargetModuleID tmid, String webURL) {
        this.targetModuleWebURLs.put(tmid.getModuleID(), webURL);
    }

    protected ServerConnectionIdentifier getTargetDAS() {
        return this.targetDAS;
    }

    private String getValueFromDottedNameListResult(String result) {
        if (result == null) {
            return null;
        }
        int index = result.lastIndexOf(".");
        return result.substring(index + 1);
    }

    private String getValueFromDottedNameGetResult(String result) {
        if (result == null) {
            return null;
        }
        int index = result.lastIndexOf("=");
        return result.substring(index + 1);
    }

    private ModuleType getJavaEEModuleTypeFromResult(List<String> resultList) {
        ArrayList<String> sniffersFound = new ArrayList<String>();
        for (String result : resultList) {
            if (result.endsWith("property.isComposite=true")) {
                return ModuleType.EAR;
            }
            if (result.endsWith("engine.web.sniffer=web")) {
                sniffersFound.add("web");
                continue;
            }
            if (result.endsWith("engine.ejb.sniffer=ejb")) {
                sniffersFound.add("ejb");
                continue;
            }
            if (result.endsWith("engine.connector.sniffer=connector")) {
                sniffersFound.add("rar");
                continue;
            }
            if (!result.endsWith("engine.appclient.sniffer=appclient")) continue;
            sniffersFound.add("car");
        }
        if (sniffersFound.contains("web")) {
            return ModuleType.WAR;
        }
        if (sniffersFound.contains("ejb")) {
            return ModuleType.EJB;
        }
        if (sniffersFound.contains("rar")) {
            return ModuleType.RAR;
        }
        if (sniffersFound.contains("car")) {
            return ModuleType.CAR;
        }
        return null;
    }

    private String getSuffixFromType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("war")) {
            return ".war";
        }
        if (type.equals("ejb")) {
            return ".jar";
        }
        if (type.equals("car")) {
            return ".car";
        }
        if (type.equals("rar")) {
            return ".rar";
        }
        if (type.equals("ear")) {
            return ".ear";
        }
        return null;
    }

    public static interface DFCommandRunner {
        public DFDeploymentStatus run() throws CommandException;
    }
}

