/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiArchiveHandler;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;

public abstract class OSGiDeploymentRequest {
    private static final Logger logger = Logger.getLogger(OSGiUndeploymentRequest.class.getPackage().getName());
    private ActionReport reporter;
    private Bundle b;
    private boolean dirDeployment;
    private Deployment deployer;
    private ArchiveFactory archiveFactory;
    private ServerEnvironmentImpl env;
    private ReadableArchive archive;
    private OSGiDeploymentContext dc;

    public OSGiDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        this.deployer = deployer;
        this.archiveFactory = archiveFactory;
        this.env = env;
        this.reporter = reporter;
        this.b = b;
    }

    public OSGiApplicationInfo execute() {
        try {
            this.prepare();
        }
        catch (Exception e) {
            this.reporter.failure(logger, "Failed while preparing to deploy bundle " + this.b, (Throwable)e);
            return null;
        }
        return this.deploy();
    }

    private void prepare() throws Exception {
        this.archive = new OSGiBundleArchive(this.b);
        DeployCommandParameters opsParams = this.getDeployParams(this.archive);
        this.dc = this.getDeploymentContextImpl(this.reporter, logger, this.archive, (OpsParams)opsParams, this.env, this.b);
        this.expandIfNeeded();
    }

    protected abstract OSGiDeploymentContext getDeploymentContextImpl(ActionReport var1, Logger var2, ReadableArchive var3, OpsParams var4, ServerEnvironmentImpl var5, Bundle var6) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiApplicationInfo deploy() {
        OSGiApplicationInfo oSGiApplicationInfo;
        block17: {
            ApplicationInfo appInfo;
            block15: {
                OSGiApplicationInfo oSGiApplicationInfo2;
                block16: {
                    appInfo = null;
                    try {
                        appInfo = this.deployer.deploy((ExtendedDeploymentContext)this.dc);
                        if (appInfo == null) break block15;
                        oSGiApplicationInfo2 = new OSGiApplicationInfo(appInfo, this.dirDeployment, this.b);
                        Object var4_4 = null;
                        if (this.dirDeployment || appInfo != null) break block16;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            Object var4_6 = null;
                            if (this.dirDeployment || appInfo != null) break block18;
                            try {
                                File dir = this.dc.getSourceDir();
                                assert (dir.isDirectory());
                                if (FileUtils.whack((File)dir)) {
                                    logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                                    break block18;
                                }
                                logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Unable to delete {0} ", new Object[]{dir});
                            }
                            catch (Exception e2) {
                                logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        File dir = this.dc.getSourceDir();
                        assert (dir.isDirectory());
                        if (FileUtils.whack((File)dir)) {
                            logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                        } else {
                            logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Unable to delete {0} ", new Object[]{dir});
                        }
                    }
                    catch (Exception e2) {
                        logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                    }
                }
                return oSGiApplicationInfo2;
            }
            logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "failed to deploy {0} for following reason: {1} ", new Object[]{this.b, this.reporter.getMessage()});
            oSGiApplicationInfo = null;
            Object var4_5 = null;
            if (this.dirDeployment || appInfo != null) break block17;
            try {
                File dir = this.dc.getSourceDir();
                assert (dir.isDirectory());
                if (FileUtils.whack((File)dir)) {
                    logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                } else {
                    logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Unable to delete {0} ", new Object[]{dir});
                }
            }
            catch (Exception e2) {
                logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
            }
        }
        return oSGiApplicationInfo;
    }

    private void expandIfNeeded() throws IOException {
        File file = OSGiDeploymentRequest.makeFile(this.dc.getSource());
        boolean bl = this.dirDeployment = file != null && file.isDirectory();
        if (this.dirDeployment) {
            logger.logp(Level.FINE, "OSGiDeploymentRequest", "expandIfNeeded", "Archive is already expanded at = {0}", new Object[]{file});
            this.archive = this.archiveFactory.openArchive(file);
            this.dc.setSource(this.archive);
            return;
        }
        File tmpFile = File.createTempFile("osgiapp", "");
        if (!tmpFile.delete()) {
            throw new IOException("Not able to expand " + this.archive.getName() + " in " + tmpFile);
        }
        tmpFile = new File(tmpFile.getAbsolutePath());
        tmpFile.deleteOnExit();
        if (!tmpFile.mkdirs()) {
            throw new IOException("Not able to expand " + this.archive.getName() + " in " + tmpFile);
        }
        WritableArchive targetArchive = this.archiveFactory.createArchive(tmpFile);
        new OSGiArchiveHandler().expand(this.archive, targetArchive, (DeploymentContext)this.dc);
        logger.logp(Level.INFO, "OSGiDeploymentRequest", "expand", "Expanded at {0}", new Object[]{targetArchive.getURI()});
        this.archive = this.archiveFactory.openArchive(tmpFile);
        this.dc.setSource(this.archive);
    }

    public static File makeFile(ReadableArchive a) {
        try {
            return new File(a.getURI());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DeployCommandParameters getDeployParams(ReadableArchive archive) throws Exception {
        DeployCommandParameters parameters = new DeployCommandParameters();
        parameters.name = archive.getName();
        parameters.enabled = Boolean.TRUE;
        parameters.origin = OpsParams.Origin.deploy;
        parameters.force = false;
        return parameters;
    }
}

