/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployapi.ProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private static final String DEFAULT_SERVER_NAME = "server";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractDeploymentFacility.class);
    private static final String LIST_COMMAND = "list";
    private static final String LIST_SUB_COMPONENTS_COMMAND = "list-sub-components";
    private static final String GET_CLIENT_STUBS_COMMAND = "get-client-stubs";
    private static final String GET_COMMAND = "get";
    private boolean connected;
    private TargetImpl domain;
    private ServerConnectionIdentifier targetDAS;
    private Map<String, String> targetModuleWebURLs = new HashMap<String, String>();

    protected abstract DFCommandRunner getDFCommandRunner(String var1, Map<String, Object> var2, String[] var3) throws CommandException;

    protected DFProgressObject changeState(Target[] targets, String moduleID, String commandName, String action) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
        try {
            for (Target target : targets) {
                HashMap<String, Object> commandParams = new HashMap<String, Object>();
                commandParams.put("target", target.getName());
                DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, new String[]{moduleID});
                DFDeploymentStatus ds = commandRunner.run();
                DFDeploymentStatus mainStatus = ds.getMainStatus();
                if (!po.checkStatusAndAddStage((TargetImpl)target, localStrings.getLocalString("enterprise.deployment.client.change_state", "{0} of {1} in target {2}", new Object[]{action, moduleID, target.getName()}), mainStatus)) {
                    return po;
                }
                TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                targetModuleIDList.add(targetModuleID);
            }
            TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targetModuleIDList.size()];
            targetModuleIDs = targetModuleIDList.toArray(targetModuleIDs);
            po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.change_state_all", "{0} of application in all targets", new Object[]{action}), (TargetImpl)targets[0], targetModuleIDs);
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.state_change_failed", "Attempt to change the state of the application {0} failed - {1}", new Object[]{moduleID, ioex.toString()}), (TargetImpl)targets[0]);
            return po;
        }
    }

    protected abstract boolean doConnect();

    @Override
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        this.connected = true;
        this.targetDAS = targetDAS;
        this.domain = new TargetImpl(this, "domain", localStrings.getLocalString("enterprise.deployment.client.administrative_domain", "administrative-domain"));
        return this.doConnect();
    }

    protected abstract boolean doDisconnect();

    @Override
    public boolean disconnect() {
        this.connected = false;
        this.domain = null;
        this.targetDAS = null;
        return this.doDisconnect();
    }

    @Override
    public DFProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        return this.changeAppRef(targets, moduleID, "create-application-ref", "Creation", options);
    }

    @Override
    public DFProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        return this.changeAppRef(targets, moduleID, "delete-application-ref", "Removal", options);
    }

    protected DFProgressObject changeAppRef(Target[] targets, String moduleID, String commandName, String action, Map options) {
        this.ensureConnected();
        Object commandExecutionException = null;
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
        try {
            for (Target target : targets) {
                options.put("target", target.getName());
                String[] operands = new String[]{moduleID};
                DFDeploymentStatus mainStatus = null;
                DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, options, operands);
                DFDeploymentStatus ds = commandRunner.run();
                mainStatus = ds.getMainStatus();
                if (!po.checkStatusAndAddStage((TargetImpl)target, localStrings.getLocalString("enterprise.deployment.client.create_reference", "Creation of reference for application in target {0}", new Object[]{target.getName()}), mainStatus)) {
                    return po;
                }
                TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                targetModuleIDList.add(targetModuleID);
            }
            TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targetModuleIDList.size()];
            targetModuleIDs = targetModuleIDList.toArray(targetModuleIDs);
            po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.change_reference_application", "{0} of application reference in all targets", new Object[]{action}), (TargetImpl)targets[0], targetModuleIDs);
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.change_reference_application_failed", "{0} of application reference failed - {1}", new Object[]{action, ioex.getMessage()}), (TargetImpl)targets[0]);
            return po;
        }
    }

    @Override
    public Target createTarget(String name) {
        return new TargetImpl(this, name, "");
    }

    @Override
    public Target[] createTargets(String[] targets) {
        if (targets == null) {
            targets = new String[]{};
        }
        Target[] result = new TargetImpl[targets.length];
        int i = 0;
        for (String name : targets) {
            result[i++] = new TargetImpl(this, name, "");
        }
        return result;
    }

    protected String createTargetsParam(Target[] targets) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < targets.length; ++i) {
            sb.append(targets[i].getName());
            if (i == targets.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DFProgressObject deploy(Target[] targets, ReadableArchive source, ReadableArchive deploymentPlan, Map deploymentOptions) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        File tempSourceFile = null;
        File tempPlanFile = null;
        if (source instanceof MemoryMappedArchive) {
            try {
                String type = (String)deploymentOptions.remove("type");
                tempSourceFile = this.writeMemoryMappedArchiveToTempFile((MemoryMappedArchive)source, this.getSuffixFromType(type));
                URI tempPlanURI = null;
                if (deploymentPlan != null && deploymentPlan instanceof MemoryMappedArchive) {
                    tempPlanFile = this.writeMemoryMappedArchiveToTempFile((MemoryMappedArchive)deploymentPlan, ".jar");
                    tempPlanURI = tempPlanFile.toURI();
                }
                DFProgressObject dFProgressObject = this.deploy(targets, tempSourceFile.toURI(), tempPlanURI, deploymentOptions);
                return dFProgressObject;
            }
            finally {
                if (tempSourceFile != null) {
                    tempSourceFile.delete();
                }
                if (tempPlanFile != null) {
                    tempPlanFile.delete();
                }
            }
        }
        if (deploymentPlan == null) {
            return this.deploy(targets, source.getURI(), null, deploymentOptions);
        }
        return this.deploy(targets, source.getURI(), deploymentPlan.getURI(), deploymentOptions);
    }

    private File writeMemoryMappedArchiveToTempFile(MemoryMappedArchive mma, String fileSuffix) throws IOException {
        int actual;
        File tempFile = File.createTempFile("jsr88-", fileSuffix);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
        int chunkSize = 32768;
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(mma.getByteArray()));
        for (long remaining = mma.getArchiveSize(); remaining != 0L; remaining -= (long)actual) {
            actual = remaining < (long)chunkSize ? (int)remaining : chunkSize;
            byte[] bytes = new byte[actual];
            try {
                bis.read(bytes);
                bos.write(bytes);
                continue;
            }
            catch (EOFException eof) {
                break;
            }
        }
        bos.flush();
        return tempFile;
    }

    @Override
    public DFProgressObject deploy(Target[] targets, URI source, URI deploymentPlan, Map deploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
        if (source == null) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_specified", "Archive to be deployed is not specified at all."), (TargetImpl)targets[0]);
            return po;
        }
        File tmpFile = new File(source.getSchemeSpecificPart());
        if (!tmpFile.exists()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_in_location", "Unable to find the archive to be deployed in specified location."), this.domain);
            return po;
        }
        if (!tmpFile.canRead()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_no_read_permission", "Archive to be deployed does not have read permission."), this.domain);
            return po;
        }
        boolean isDirectoryDeploy = tmpFile.isDirectory();
        try {
            int i;
            boolean isRedeploy;
            if (deploymentPlan != null) {
                File dp = new File(deploymentPlan.getSchemeSpecificPart());
                if (!dp.exists()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_not_in_location", "Unable to find the deployment plan in specified location."), this.domain);
                    return po;
                }
                if (!dp.canRead()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_no_read_permission", "Deployment plan does not have read permission."), this.domain);
                    return po;
                }
                deploymentOptions.put("deploymentplan", dp.getAbsolutePath());
            }
            if (isRedeploy = Boolean.valueOf((String)deploymentOptions.remove("redeploy")).booleanValue()) {
                String appName = (String)deploymentOptions.get("name");
                if (!this.isTargetsMatched(appName, targets)) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.specifyAllTargets", "Application {0} is already deployed on other targets. Please remove all references or specify all targets (or domain target if using asadmin command line) before attempting {1} operation", new Object[]{appName, "redeploy"}), this.domain);
                }
                String enabledAttr = this.getAppRefEnabledAttr(targets[0].getName(), appName);
                deploymentOptions.put("enabled", enabledAttr);
            }
            Target[] origTargets = targets;
            if (isRedeploy && targets.length > 1) {
                targets = this.createTargets(new String[]{"domain"});
            }
            deploymentOptions.put("target", targets[0].getName());
            DFCommandRunner commandRunner = this.getDFCommandRunner("deploy", deploymentOptions, new String[]{tmpFile.getAbsolutePath()});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (!po.checkStatusAndAddStage((TargetImpl)targets[0], localStrings.getLocalString("enterprise.deployment.client.deploy_to_first_target", "Deploying application to target {0}", new Object[]{targets[0].getName()}), mainStatus)) {
                return po;
            }
            String moduleID = mainStatus.getProperty("name");
            po.setModuleID(moduleID);
            HashMap<String, Object> createAppRefOptions = new HashMap<String, Object>();
            if (deploymentOptions.get("enabled") != null) {
                createAppRefOptions.put("enabled", deploymentOptions.get("enabled"));
            }
            if (deploymentOptions.get("virtualservers") != null) {
                createAppRefOptions.put("virtualservers", deploymentOptions.get("virtualservers"));
            }
            for (i = 1; i < targets.length; ++i) {
                createAppRefOptions.put("target", targets[i].getName());
                DFCommandRunner commandRunner2 = this.getDFCommandRunner("create-application-ref", createAppRefOptions, new String[]{moduleID});
                DFDeploymentStatus ds2 = commandRunner2.run();
                DFDeploymentStatus mainStatus2 = ds2.getMainStatus();
                if (po.checkStatusAndAddStage((TargetImpl)targets[i], "create app ref", mainStatus2)) continue;
                return po;
            }
            for (i = 0; i < origTargets.length; ++i) {
                TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)origTargets[i], moduleID);
                targetModuleIDList.add(targetModuleID);
            }
            TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targetModuleIDList.size()];
            targetModuleIDs = targetModuleIDList.toArray(targetModuleIDs);
            po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application", "Deployment of application {0}", new Object[]{moduleID}), (TargetImpl)targets[0], targetModuleIDs);
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0} ", new Object[]{ioex.toString()}), (TargetImpl)targets[0]);
            return po;
        }
    }

    @Override
    public DFProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "disable", "Disable");
    }

    @Override
    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        throw new UnsupportedOperationException("Not supported in v3");
    }

    @Override
    public DFProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "enable", "Enable");
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.client.disconnected_state", "Not connected to the Domain Admin Server"));
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public List<String> getSubModuleInfoForJ2EEApplication(String appName) throws IOException {
        this.ensureConnected();
        String commandName = LIST_SUB_COMPONENTS_COMMAND;
        String[] operands = new String[]{appName};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> subModuleInfoList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    if (subStage.getProperty("moduleInfo") == null) continue;
                    subModuleInfoList.add(subStage.getProperty("moduleInfo"));
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return subModuleInfoList;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    private String getAppRefEnabledAttr(String target, String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "servers.server." + target + ".application-ref." + moduleName + ".enabled";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            String enabledAttr = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                if (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    enabledAttr = this.getValueFromDottedNameGetResult(result);
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return enabledAttr;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public String getContextRoot(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "applications.application." + moduleName + ".context-root";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            String contextRoot = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                if (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    contextRoot = this.getValueFromDottedNameGetResult(result);
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return contextRoot;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public ModuleType getModuleType(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        String patternParam = "applications.application." + moduleName + ".*";
        String[] operands = new String[]{patternParam};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> resultList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    resultList.add(subStage.getStageStatusMessage());
                }
                return this.getJavaEEModuleTypeFromResult(resultList);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public Target[] listTargets() throws IOException {
        return this.listReferencedTargets("*");
    }

    @Override
    public Target[] listReferencedTargets(String appName) throws IOException {
        this.ensureConnected();
        String commandName = "_get-targets";
        String[] operands = new String[]{appName};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<Target> targets = new ArrayList<Target>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = mainStatus.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    String result = subStage.getStageStatusMessage();
                    targets.add(this.createTarget(result));
                }
                Target[] result = new Target[targets.size()];
                return targets.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public void getClientStubs(String location, String moduleID) throws IOException {
        this.ensureConnected();
        String commandName = GET_CLIENT_STUBS_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("appname", moduleID);
        String[] operands = new String[]{location};
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, operands);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() == DFDeploymentStatus.Status.FAILURE) {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public HostAndPort getHostAndPort(String target) throws IOException {
        return this.getHostAndPort(target, false);
    }

    @Override
    public HostAndPort getHostAndPort(String target, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, securityEnabled);
    }

    @Override
    public HostAndPort getVirtualServerHostAndPort(String target, String virtualServer, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, virtualServer, securityEnabled);
    }

    @Override
    public HostAndPort getHostAndPort(String target, String moduleId, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, moduleId, null, securityEnabled);
    }

    private HostAndPort getHostAndPort(String target, String moduleId, String virtualServer, boolean securityEnabled) throws IOException {
        this.ensureConnected();
        String commandName = "_get-host-and-port";
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", DEFAULT_SERVER_NAME);
        if (moduleId != null) {
            commandParams.put("moduleId", moduleId);
        }
        if (virtualServer != null) {
            commandParams.put("virtualServer", virtualServer);
        }
        commandParams.put("securityEnabled", new Boolean(securityEnabled));
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            HostAndPort hap = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String hostPortStr = mainStatus.getStageStatusMessage();
                if (hostPortStr != null && !hostPortStr.trim().equals("")) {
                    hap = new HostAndPort(hostPortStr);
                }
                return hap;
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        this.ensureConnected();
        ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
        IOException commandExecutionException = null;
        try {
            Target[] targetImpls;
            for (Target target : targetImpls = this.prepareTargets(this.createTargets(targets))) {
                String commandName = "list-application-refs";
                String[] operands = new String[]{target.getName()};
                HashMap<String, Object> commandParams = new HashMap<String, Object>();
                DFDeploymentStatus mainStatus = null;
                DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, operands);
                DFDeploymentStatus ds = commandRunner.run();
                mainStatus = ds.getMainStatus();
                if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                    Iterator appRefIter = mainStatus.getSubStages();
                    while (appRefIter.hasNext()) {
                        DFDeploymentStatus appRefSubStage = (DFDeploymentStatus)appRefIter.next();
                        String moduleID = appRefSubStage.getStageStatusMessage();
                        TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                        targetModuleIDList.add(targetModuleID);
                    }
                    continue;
                }
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
        TargetModuleIDImpl[] result = new TargetModuleIDImpl[targetModuleIDList.size()];
        return targetModuleIDList.toArray(result);
    }

    @Override
    public TargetModuleID[] _listAppRefs(String[] targets) throws IOException {
        return this._listAppRefs(targets, "all");
    }

    @Override
    public TargetModuleID[] _listAppRefs(String[] targets, String state) throws IOException {
        return this._listAppRefs(targets, state, null);
    }

    @Override
    public TargetModuleID[] _listAppRefs(String[] targets, String state, String type) throws IOException {
        Target[] targetImpls = this.prepareTargets(this.createTargets(targets));
        return this._listAppRefs(targetImpls, state, type);
    }

    @Override
    public TargetModuleID[] _listAppRefs(Target[] targets, String state, String type) throws IOException {
        this.ensureConnected();
        String commandName = "_list-app-refs";
        String targetsParam = this.createTargetsParam(targets);
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", targetsParam);
        commandParams.put("state", state);
        if (type != null) {
            commandParams.put("type", type);
        }
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String targetName = mainStatus.getStageStatusMessage();
                for (Target target : targets) {
                    if (!target.getName().equals(targetName)) continue;
                    Iterator appRefIter = mainStatus.getSubStages();
                    while (appRefIter.hasNext()) {
                        DFDeploymentStatus appRefSubStage = (DFDeploymentStatus)appRefIter.next();
                        String moduleID = appRefSubStage.getStageStatusMessage();
                        if (!(target instanceof TargetImpl)) continue;
                        TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                        targetModuleIDList.add(targetModuleID);
                    }
                }
                TargetModuleIDImpl[] result = new TargetModuleIDImpl[targetModuleIDList.size()];
                return targetModuleIDList.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    private Target[] prepareTargets(Target[] targets) {
        if (targets == null || targets.length == 0) {
            targets = new Target[]{this.targetForDefaultServer()};
        }
        return targets;
    }

    private Target targetForDefaultServer() {
        TargetImpl t = new TargetImpl(this, DEFAULT_SERVER_NAME, localStrings.getLocalString("enterprise.deployment.client.default_server_description", "default server"));
        return t;
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, new HashMap());
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID, Map undeploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
        try {
            if (!this.isTargetsMatched(moduleID, targets)) {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.specifyAllTargets", "Application {0} is already deployed on other targets. Please remove all references or specify all targets (or domain target if using asadmin command line) before attempting {1} operation", new Object[]{moduleID, "undeploy"}), this.domain);
            }
            HashMap<String, Object> deleteAppRefOptions = new HashMap<String, Object>();
            if (undeploymentOptions.get("cascade") != null) {
                deleteAppRefOptions.put("cascade", undeploymentOptions.get("cascade"));
            }
            for (int i = 0; i < targets.length - 1; ++i) {
                deleteAppRefOptions.put("target", targets[i].getName());
                DFCommandRunner commandRunner = this.getDFCommandRunner("delete-application-ref", deleteAppRefOptions, new String[]{moduleID});
                DFDeploymentStatus ds = commandRunner.run();
                DFDeploymentStatus mainStatus = ds.getMainStatus();
                if (!po.checkStatusAndAddStage((TargetImpl)targets[i], localStrings.getLocalString("enterprise.deployment.client.undeploy_remove_ref", "While undeploying, trying to remove reference for application in target {0}", new Object[]{targets[i].getName()}), mainStatus)) {
                    return po;
                }
                TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)targets[i], moduleID);
                targetModuleIDList.add(targetModuleID);
            }
            Target lastTarget = targets[targets.length - 1];
            undeploymentOptions.put("target", lastTarget.getName());
            DFCommandRunner commandRunner2 = this.getDFCommandRunner("undeploy", undeploymentOptions, new String[]{moduleID});
            DFDeploymentStatus ds2 = commandRunner2.run();
            DFDeploymentStatus mainStatus2 = ds2.getMainStatus();
            if (!po.checkStatusAndAddStage((TargetImpl)lastTarget, localStrings.getLocalString("enterprise.deployment.client.undeploy_from_target", "Trying to undeploy application from target {0}", new Object[]{lastTarget.getName()}), mainStatus2)) {
                return po;
            }
            TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targetModuleIDList.size()];
            targetModuleIDs = targetModuleIDList.toArray(targetModuleIDs);
            po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application", "Undeployment of application {0}", new Object[]{moduleID}), (TargetImpl)targets[0], targetModuleIDs);
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0}", new Object[]{ioex.toString()}), (TargetImpl)targets[0]);
            return po;
        }
    }

    @Override
    public String exportClientStubs(String appName, String destDir) throws IOException {
        this.getClientStubs(destDir, appName);
        return destDir + appName + "Client.jar";
    }

    @Override
    public DFDeploymentStatus waitFor(DFProgressObject po) {
        return po.waitFor();
    }

    @Override
    public String getWebURL(TargetModuleID tmid) {
        return this.targetModuleWebURLs.get(tmid.getModuleID());
    }

    @Override
    public void setWebURL(TargetModuleID tmid, String webURL) {
        this.targetModuleWebURLs.put(tmid.getModuleID(), webURL);
    }

    protected ServerConnectionIdentifier getTargetDAS() {
        return this.targetDAS;
    }

    private String getValueFromDottedNameListResult(String result) {
        if (result == null) {
            return null;
        }
        int index = result.lastIndexOf(".");
        return result.substring(index + 1);
    }

    private String getValueFromDottedNameGetResult(String result) {
        if (result == null) {
            return null;
        }
        int index = result.lastIndexOf("=");
        return result.substring(index + 1);
    }

    private ModuleType getJavaEEModuleTypeFromResult(List<String> resultList) {
        ArrayList<String> sniffersFound = new ArrayList<String>();
        for (String result : resultList) {
            if (result.endsWith("property.isComposite=true")) {
                return ModuleType.EAR;
            }
            if (result.endsWith("engine.web.sniffer=web")) {
                sniffersFound.add("web");
                continue;
            }
            if (result.endsWith("engine.ejb.sniffer=ejb")) {
                sniffersFound.add("ejb");
                continue;
            }
            if (result.endsWith("engine.connector.sniffer=connector")) {
                sniffersFound.add("rar");
                continue;
            }
            if (!result.endsWith("engine.appclient.sniffer=appclient")) continue;
            sniffersFound.add("car");
        }
        if (sniffersFound.contains("web")) {
            return ModuleType.WAR;
        }
        if (sniffersFound.contains("ejb")) {
            return ModuleType.EJB;
        }
        if (sniffersFound.contains("rar")) {
            return ModuleType.RAR;
        }
        if (sniffersFound.contains("car")) {
            return ModuleType.CAR;
        }
        return null;
    }

    private String getSuffixFromType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("war")) {
            return ".war";
        }
        if (type.equals("ejb")) {
            return ".jar";
        }
        if (type.equals("car")) {
            return ".car";
        }
        if (type.equals("rar")) {
            return ".rar";
        }
        if (type.equals("ear")) {
            return ".ear";
        }
        return null;
    }

    private boolean isTargetsMatched(String appName, Target[] targets) throws IOException {
        Target[] referencedTargets = this.listReferencedTargets(appName);
        if (targets.length != referencedTargets.length) {
            return false;
        }
        ArrayList<String> referencedTargetNames = new ArrayList<String>();
        for (Target target : referencedTargets) {
            referencedTargetNames.add(target.getName());
        }
        for (Target target : targets) {
            referencedTargetNames.remove(target.getName());
        }
        return referencedTargetNames.size() == 0;
    }

    public static interface DFCommandRunner {
        public DFDeploymentStatus run() throws CommandException;
    }
}

