/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.EntrepriseBeansRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.node.runtime.common.SecurityRoleMappingNode;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.glassfish.security.common.Group;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBundleRuntimeNode
extends RuntimeBundleNode<EjbBundleDescriptor> {
    protected EjbBundleDescriptor descriptor = null;

    public EjbBundleRuntimeNode(EjbBundleDescriptor descriptor) {
        super(descriptor);
        this.descriptor = descriptor;
        this.registerElementHandler(new XMLElement("security-role-mapping"), SecurityRoleMappingNode.class);
        this.registerElementHandler(new XMLElement("enterprise-beans"), EntrepriseBeansRuntimeNode.class);
    }

    public EjbBundleRuntimeNode() {
        super(null);
    }

    @Override
    public String getDocType() {
        return "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN";
    }

    @Override
    public String getSystemID() {
        return "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd";
    }

    @Override
    public List<String> getSystemIDs() {
        return null;
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return new XMLElement("sun-ejb-jar");
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.1 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-1.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd");
        if (!EjbBundleRuntimeNode.restrictDTDDeclarations()) {
            publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_1-0.dtd");
        }
        return "sun-ejb-jar";
    }

    @Override
    public EjbBundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (element.getQName().equals("compatibility")) {
            this.descriptor.setCompatibility(value);
        } else if (element.getQName().equals("disable-nonportable-jndi-names")) {
            this.descriptor.setDisableNonportableJndiNames(value);
        } else if (element.getQName().equals("keep-state")) {
            this.descriptor.setKeepState(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof SecurityRoleMapping) {
            SecurityRoleMapping roleMap = (SecurityRoleMapping)newDescriptor;
            this.descriptor.addSecurityRoleMapping(roleMap);
            Application app = this.descriptor.getApplication();
            if (app != null) {
                Role role = new Role(roleMap.getRoleName());
                SecurityRoleMapper rm = app.getRoleMapper();
                if (rm != null) {
                    List<PrincipalNameDescriptor> principals = roleMap.getPrincipalNames();
                    for (int i = 0; i < principals.size(); ++i) {
                        rm.assignRole(principals.get(i).getPrincipal(), role, this.descriptor);
                    }
                    List<String> groups = roleMap.getGroupNames();
                    for (int i = 0; i < groups.size(); ++i) {
                        rm.assignRole((Principal)new Group(groups.get(i)), role, this.descriptor);
                    }
                }
            }
        }
    }

    @Override
    public Node writeDescriptor(Node parent, EjbBundleDescriptor bundleDescriptor) {
        Node ejbs = super.writeDescriptor(parent, bundleDescriptor);
        List<SecurityRoleMapping> roleMappings = bundleDescriptor.getSecurityRoleMappings();
        for (int i = 0; i < roleMappings.size(); ++i) {
            SecurityRoleMappingNode srmn = new SecurityRoleMappingNode();
            srmn.writeDescriptor(ejbs, "security-role-mapping", roleMappings.get(i));
        }
        EntrepriseBeansRuntimeNode ejbsNode = new EntrepriseBeansRuntimeNode();
        ejbsNode.writeDescriptor(ejbs, "enterprise-beans", bundleDescriptor);
        EjbBundleRuntimeNode.appendTextChild(ejbs, "compatibility", bundleDescriptor.getCompatibility());
        Boolean djndi = bundleDescriptor.getDisableNonportableJndiNames();
        if (djndi != null) {
            EjbBundleRuntimeNode.appendTextChild(ejbs, "disable-nonportable-jndi-names", String.valueOf(djndi));
        }
        EjbBundleRuntimeNode.appendTextChild(ejbs, "keep-state", String.valueOf(bundleDescriptor.getKeepState()));
        return ejbs;
    }
}

