/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.intf.config.AuthRealm;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.intf.config.SecurityService;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RealmsImpl
extends AMXImplBase {
    private volatile boolean realmsLoaded = false;
    private static final String ADMIN_REALM = "admin-realm";
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";

    public RealmsImpl(ObjectName containerObjectName) {
        super(containerObjectName, Realms.class);
    }

    public static RealmsManager getRealmsManager() {
        RealmsManager mgr = (RealmsManager)Globals.getDefaultHabitat().getComponent(RealmsManager.class);
        return mgr;
    }

    private SecurityService getSecurityService() {
        Domain domainConfig = (Domain)this.getDomainRootProxy().child(Domain.class);
        Config config = (Config)domainConfig.getConfigs().getConfig().values().iterator().next();
        return config.getSecurityService();
    }

    private Map<String, AuthRealm> getAuthRealms() {
        return this.getSecurityService().getAuthRealm();
    }

    private Set<String> getConfiguredRealmNames() {
        return this.getAuthRealms().keySet();
    }

    private synchronized void loadRealms() {
        if (this.realmsLoaded) {
            Set loaded = SetUtil.newStringSet((String[])this._getRealmNames());
            if (((Object)this.getConfiguredRealmNames()).equals(loaded)) {
                return;
            }
            this.realmsLoaded = false;
        }
        this._loadRealms();
    }

    private void _loadRealms() {
        if (this.realmsLoaded) {
            throw new IllegalStateException();
        }
        Map<String, AuthRealm> authRealmConfigs = this.getAuthRealms();
        ArrayList<String> goodRealms = new ArrayList<String>();
        for (AuthRealm authRealm : authRealmConfigs.values()) {
            Map propConfigs = authRealm.childrenMap(Property.class);
            Properties props = new Properties();
            for (Property p : propConfigs.values()) {
                String value = p.resolveAttribute("Value");
                props.setProperty(p.getName(), value);
            }
            try {
                Realm.instantiate((String)authRealm.getName(), (String)authRealm.getClassname(), (Properties)props);
                goodRealms.add(authRealm.getName());
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't instantiate realm: " + StringUtil.quote((Object)authRealm), e);
            }
        }
        if (goodRealms.size() != 0) {
            String goodRealm = (String)goodRealms.iterator().next();
            try {
                String defaultRealm = this.getSecurityService().getDefaultRealm();
                Realm r = Realm.getInstance((String)defaultRealm);
                Realm.setDefaultRealm((String)defaultRealm);
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't get realm " + StringUtil.quote((Object)goodRealm), e);
                Realm.setDefaultRealm((String)((String)goodRealms.iterator().next()));
            }
        }
        this.realmsLoaded = true;
    }

    private String[] _getRealmNames() {
        List items = ListUtil.newList((Enumeration)RealmsImpl.getRealmsManager().getRealmNames());
        return (String[])CollectionUtil.toArray((Collection)items, String.class);
    }

    public String[] getRealmNames() {
        try {
            this.loadRealms();
            return this._getRealmNames();
        }
        catch (Exception e) {
            ImplUtil.getLogger().log(Level.WARNING, "getRealmNames(): Can't get realm names ", e);
            return new String[0];
        }
    }

    public String[] getPredefinedAuthRealmClassNames() {
        List items = RealmsImpl.getRealmsManager().getPredefinedAuthRealmClassNames();
        return (String[])CollectionUtil.toArray((Collection)items, String.class);
    }

    public String getDefaultRealmName() {
        return RealmsImpl.getRealmsManager().getDefaultRealmName();
    }

    public void setDefaultRealmName(String realmName) {
        RealmsImpl.getRealmsManager().setDefaultRealmName(realmName);
    }

    private Realm getRealm(String realmName) {
        this.loadRealms();
        Realm realm = RealmsImpl.getRealmsManager().getFromLoadedRealms(realmName);
        if (realm == null) {
            throw new IllegalArgumentException("No such realm: " + realmName);
        }
        return realm;
    }

    public void addUser(String realmName, String user, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.addUser(user, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUser(String realmName, String existingUser, String newUser, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.updateUser(existingUser, newUser, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String realmName, String user) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.removeUser(user);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsUserManagement(String realmName) {
        return this.getRealm(realmName).supportsUserManagement();
    }

    private void checkSupportsUserManagement(String realmName) {
        if (!this.supportsUserManagement(realmName)) {
            throw new IllegalStateException("Realm " + realmName + " does not support user management");
        }
    }

    public String[] getUserNames(String realmName) {
        try {
            List names = ListUtil.newList((Enumeration)this.getRealm(realmName).getUserNames());
            return (String[])CollectionUtil.toArray((Collection)names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName) {
        try {
            List names = ListUtil.newList((Enumeration)this.getRealm(realmName).getGroupNames());
            return (String[])CollectionUtil.toArray((Collection)names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName, String user) {
        try {
            return (String[])CollectionUtil.toArray((Collection)ListUtil.newList((Enumeration)this.getRealm(realmName).getGroupNames(user)), String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getUserAttributes(String realmName, String username) {
        try {
            User user = this.getRealm(realmName).getUser(username);
            HashMap<String, Object> m = new HashMap<String, Object>();
            List attrNames = ListUtil.newList((Enumeration)user.getAttributeNames());
            for (String attrName : attrNames) {
                m.put(attrName, user.getAttribute(attrName));
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAnonymousUser() {
        DomainRoot domainRoot = this.getDomainRootProxy();
        Domain domainConfig = (Domain)domainRoot.child(Domain.class);
        Map configs = domainConfig.getConfigs().childrenMap(Config.class);
        AuthRealm adminFileAuthRealm = null;
        block2: for (Config config : configs.values()) {
            if (config.getSecurityService() == null) continue;
            for (AuthRealm auth : config.getSecurityService().childrenMap(AuthRealm.class).values()) {
                if (!auth.getName().equals(ADMIN_REALM)) continue;
                adminFileAuthRealm = auth;
                continue block2;
            }
        }
        if (adminFileAuthRealm == null) {
            throw new IllegalStateException("Cannot find admin realm");
        }
        String fileRealmClassName = adminFileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals(FILE_REALM_CLASSNAME)) {
            return null;
        }
        Map props = adminFileAuthRealm.childrenMap(Property.class);
        Property keyfileProp = (Property)props.get("file");
        if (keyfileProp == null) {
            throw new IllegalStateException("Cannot find property 'file'");
        }
        String keyFile = keyfileProp.resolveAttribute("Value");
        if (keyFile == null) {
            throw new IllegalStateException("Cannot find key file");
        }
        String user = null;
        String[] usernames = this.getUserNames(adminFileAuthRealm.getName());
        if (usernames.length == 1) {
            try {
                InjectedValues.getInstance().getHabitat().getByType(SecurityLifecycle.class);
                LoginContextDriver.login((String)usernames[0], (char[])new char[0], (String)ADMIN_REALM);
                user = usernames[0];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return user;
    }
}

