/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.AppClientGroupFacadeGenerator;
import org.glassfish.appclient.server.core.ApplicationSignedJARManager;
import org.glassfish.appclient.server.core.jws.JWSAdapterManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAppClientDeployerHelper
extends AppClientDeployerHelper {
    private static final String LIBRARY_SECURITY_PROPERTY_NAME = "library.security";
    private static final String LIBRARY_JARS_PROPERTY_NAME = "library.jars";
    private static final String LIBRARY_JNLP_PATH_PROPERTY_NAME = "library.jnlp.path";
    private static final String LIBRARY_DOCUMENT_TEMPLATE = "/org/glassfish/appclient/server/core/jws/templates/libraryJarsDocumentTemplate.jnlp";
    private StringBuilder classPathForFacade = new StringBuilder();
    private StringBuilder PUScanTargetsForFacade = new StringBuilder();
    private final URI earURI;
    private final ASJarSigner jarSigner;
    private ApplicationSignedJARManager signedJARManager;
    private StringBuilder libExtensionElementsForMainDocument = null;
    private static Logger logger = LogDomains.getLogger(NestedAppClientDeployerHelper.class, (String)"javax.enterprise.system.container.appclient");
    private final Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads = null;
    private static final String EAR_LEVEL_DOWNLOADS_KEY = "earLevelDownloads";
    private final Habitat habitat;
    private final AppClientGroupFacadeGenerator groupFacadeGenerator;
    private final boolean isDirectoryDeployed;
    private static final Pattern submoduleURIPattern = Pattern.compile("(.*)__([wcrj]ar)$");

    NestedAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader, Application application, Habitat habitat, ASJarSigner jarSigner) throws IOException {
        super(dc, bundleDesc, archivist, gfClientModuleClassLoader, application, habitat);
        this.habitat = habitat;
        this.groupFacadeGenerator = (AppClientGroupFacadeGenerator)habitat.getComponent(AppClientGroupFacadeGenerator.class);
        this.jarSigner = jarSigner;
        this.isDirectoryDeployed = Boolean.valueOf(dc.getAppProps().getProperty("directory-deployed"));
        this.earURI = dc.getSource().getParentArchive().getURI();
        this.processDependencies();
    }

    @Override
    protected void prepareJARs() throws IOException, URISyntaxException {
        super.prepareJARs();
        if (((ProcessEnvironment)this.habitat.getComponent(ProcessEnvironment.class)).getProcessType().isEmbedded()) {
            return;
        }
        this.groupFacadeGenerator.run(this);
    }

    @Override
    public FixedContent fixedContentWithinEAR(String uriString) {
        return new FixedContent(new File(this.earDirUserURI(this.dc()).resolve(uriString)));
    }

    public String appLibraryExtensions() {
        return this.libExtensionElementsForMainDocument == null ? "" : this.libExtensionElementsForMainDocument.toString();
    }

    @Override
    public Map<String, Map<URI, StaticContent>> signingAliasToJar() {
        return this.signedJARManager.aliasToContent();
    }

    @Override
    public void createAndAddLibraryJNLPs(AppClientDeployerHelper helper, TokenHelper tHelper, Map<String, DynamicContent> dynamicContent) throws IOException {
        this.libExtensionElementsForMainDocument = new StringBuilder();
        for (Map.Entry<String, Map<URI, StaticContent>> aliasToContentEntry : this.signingAliasToJar().entrySet()) {
            String alias = aliasToContentEntry.getKey();
            Map<URI, StaticContent> libURIs = aliasToContentEntry.getValue();
            tHelper.setProperty(LIBRARY_SECURITY_PROPERTY_NAME, this.librarySecurity(alias));
            tHelper.setProperty(LIBRARY_JNLP_PATH_PROPERTY_NAME, this.libJNLPRelPath(alias));
            StringBuilder libJarElements = new StringBuilder();
            for (Map.Entry<URI, StaticContent> entry : libURIs.entrySet()) {
                URI uri = entry.getKey();
                libJarElements.append("<jar href=\"" + this.libJARRelPath(uri) + "\"/>");
            }
            tHelper.setProperty(LIBRARY_JARS_PROPERTY_NAME, libJarElements.toString());
            JavaWebStartInfo.createAndAddDynamicContent(tHelper, dynamicContent, this.libJNLPRelPath(alias), LIBRARY_DOCUMENT_TEMPLATE);
            this.libExtensionElementsForMainDocument.append(this.extensionElement(alias, this.libJNLPRelPath(alias)));
        }
        tHelper.setProperty("app.library.extension", this.libExtensionElementsForMainDocument.toString());
    }

    @Override
    public Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads() {
        if (this.earLevelDownloads == null) {
            this.earLevelDownloads = (Set)this.dc().getTransientAppMetaData(EAR_LEVEL_DOWNLOADS_KEY, HashSet.class);
            if (this.earLevelDownloads == null) {
                this.earLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
                this.dc().addTransientAppMetaData(EAR_LEVEL_DOWNLOADS_KEY, this.earLevelDownloads);
            }
        }
        return this.earLevelDownloads;
    }

    @Override
    public File rootForSignedFilesInApp() {
        return new File(this.dc().getScratchDir("xml").getParentFile(), "signed/");
    }

    @Override
    public ApplicationSignedJARManager signedJARManager() {
        return this.signedJARManager;
    }

    private String libJARRelPath(URI absURI) {
        return JavaWebStartInfo.relativeURIForProvidedOrGeneratedAppFile(this.dc(), absURI, this).toASCIIString();
    }

    private String extensionElement(String alias, String libURIText) {
        return "<extension name=\"libJars" + (alias == null ? "" : "-" + alias) + "\" href=\"" + libURIText + "\"/>";
    }

    private String librarySecurity(String alias) {
        return alias == null ? "" : "<security><all-permissions/></security>";
    }

    private String libJNLPRelPath(String alias) {
        return "___lib/client-libs" + (alias == null ? "" : "-" + alias) + ".jnlp";
    }

    private void processDependencies() throws IOException {
        this.signedJARManager = new ApplicationSignedJARManager(JWSAdapterManager.signingAlias(this.dc()), this.jarSigner, this.habitat, this.dc(), this, this.earURI, this.earDirUserURI(this.dc()));
        URI appClientURI = URI.create(Util.getURIName((URI)this.appClientUserURI(this.dc())));
        this.classPathForFacade.append(appClientURI);
        URI groupFacadeURIRelativeToFacade = this.facadeUserURI(this.dc()).relativize(this.relativeURIToGroupFacade());
        this.classPathForFacade.append(" ").append(groupFacadeURIRelativeToFacade.toASCIIString());
        this.clientLevelDownloads.add(new DownloadableArtifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
        HashSet<URI> dependencyURIsProcessed = new HashSet<URI>();
        URI appClientURIWithinEAR = URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
        Artifact appClientJARArtifact = this.newArtifact(appClientURIWithinEAR);
        appClientJARArtifact.processArtifact(dependencyURIsProcessed, this.clientLevelDownloads(), this.earLevelDownloads());
        this.addLibraryJARs(this.classPathForFacade, this.PUScanTargetsForFacade, dependencyURIsProcessed);
        if (DeploymentUtils.useV2Compatibility((DeploymentContext)this.dc()) && !this.appClientDesc().getApplication().isVirtual()) {
            this.addEJBJARs(this.classPathForFacade, dependencyURIsProcessed);
            this.addTopLevelJARs(this.classPathForFacade, this.PUScanTargetsForFacade, dependencyURIsProcessed);
        }
    }

    private void addEJBJARs(StringBuilder cpForFacade, Set<URI> dependencyURIsProcessed) throws IOException {
        Application app = this.appClientDesc().getApplication();
        for (ModuleDescriptor<BundleDescriptor> md : app.getModuleDescriptorsByType(XModuleType.EJB)) {
            this.addJar(cpForFacade, null, new File(new File(this.earURI), md.getArchiveUri()).toURI(), dependencyURIsProcessed);
        }
    }

    private void addTopLevelJARs(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed) throws IOException {
        final HashSet<URI> submoduleURIs = new HashSet<URI>();
        for (ModuleDescriptor<BundleDescriptor> md : this.appClientDesc().getApplication().getModules()) {
            submoduleURIs.add(URI.create(md.getArchiveUri()));
        }
        this.addJARsFromDir(cpForFacade, puScanTargets, dependencyURIsProcessed, new File(this.earURI), new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && !pathname.isDirectory() && !submoduleURIs.contains(NestedAppClientDeployerHelper.this.earURI.relativize(pathname.toURI()));
            }
        });
    }

    private void addJARsFromDir(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed, File dirContainingJARs, FileFilter filter) throws IOException {
        if (dirContainingJARs.exists() && dirContainingJARs.isDirectory()) {
            for (File jar : dirContainingJARs.listFiles(filter)) {
                this.addJar(cpForFacade, puScanTargets, jar.toURI(), dependencyURIsProcessed);
            }
        }
    }

    private void addLibraryJARs(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed) throws IOException {
        String libDir = this.appClientDesc().getApplication().getLibraryDirectory();
        if (libDir != null) {
            this.addJARsFromDir(cpForFacade, puScanTargets, dependencyURIsProcessed, new File(new File(this.earURI), libDir), new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar") && !pathname.isDirectory();
                }
            });
        }
    }

    private void addJar(StringBuilder cpForFacade, StringBuilder puScanTargets, URI jarURI, Set<URI> dependencyURIsProcessed) throws IOException {
        Artifact jarArtifact;
        URI jarURIForFacade = this.earURI.relativize(jarURI);
        URI fileURIForJAR = URI.create("file:" + jarURI.getRawSchemeSpecificPart());
        if (dependencyURIsProcessed.contains(fileURIForJAR)) {
            return;
        }
        if (cpForFacade.length() > 0) {
            cpForFacade.append(' ');
        }
        cpForFacade.append(jarURIForFacade.toASCIIString());
        if (puScanTargets != null) {
            if (puScanTargets.length() > 0) {
                puScanTargets.append(' ');
            }
            puScanTargets.append(jarURIForFacade.toASCIIString());
        }
        if ((jarArtifact = this.newArtifact(this.earURI, jarURIForFacade)) != null) {
            jarArtifact.processArtifact(dependencyURIsProcessed, this.earLevelDownloads(), this.earLevelDownloads());
        }
    }

    private boolean isSubmodule(URI candidateURI) {
        for (ModuleDescriptor<BundleDescriptor> desc : this.appClientDesc().getApplication().getModules()) {
            if (!URI.create(desc.getArchiveUri()).equals(candidateURI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.relativeFacadeURI(dc));
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads() throws IOException {
        return this.clientLevelDownloads;
    }

    @Override
    protected String facadeClassPath() {
        return this.classPathForFacade.toString();
    }

    @Override
    protected String PUScanTargets() {
        return this.PUScanTargetsForFacade.toString();
    }

    @Override
    protected void addGroupFacadeToEARDownloads() {
        DownloadableArtifacts.FullAndPartURIs earFacadeDownload = (DownloadableArtifacts.FullAndPartURIs)this.dc().getTransientAppMetaData("earFacadeDownload", DownloadableArtifacts.FullAndPartURIs.class);
        this.earLevelDownloads.add(earFacadeDownload);
    }

    @Override
    public URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/" + this.relativeFacadeURI(dc));
    }

    @Override
    public URI groupFacadeUserURI(DeploymentContext dc) {
        return this.relativeGroupFacadeURI(dc);
    }

    @Override
    public URI groupFacadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml").getParentFile();
        return genXMLDir.toURI().resolve(this.relativeGroupFacadeURI(dc));
    }

    private URI relativeGroupFacadeURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client.jar");
    }

    private URI relativeFacadeURI(DeploymentContext dc) {
        return this.moduleURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.moduleNameOnly() + "Client.jar";
    }

    @Override
    public URI appClientUserURI(DeploymentContext dc) {
        return this.earDirUserURI(dc).resolve(this.moduleURI());
    }

    @Override
    public URI appClientUserURIForFacade(DeploymentContext dc) {
        return URI.create(Util.getURIName((URI)this.appClientUserURI(dc)));
    }

    private URI earDirUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/");
    }

    @Override
    public URI appClientServerURI(DeploymentContext dc) {
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        Matcher m = submoduleURIPattern.matcher(appClientURIWithinEAR);
        File userProvidedJarFile = new File(new File(this.earURI), appClientURIWithinEAR);
        URI result = m.matches() ? new File(dc.getScratchDir("xml"), m.group(1) + "." + m.group(2)).toURI() : (!userProvidedJarFile.exists() ? new File(dc.getScratchDir("xml"), appClientURIWithinEAR).toURI() : userProvidedJarFile.toURI());
        return result;
    }

    @Override
    public URI appClientServerOriginalAnchor(DeploymentContext dc) {
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        File userProvidedClientLocation = new File(new File(this.earURI), appClientURIWithinEAR);
        return userProvidedClientLocation.toURI();
    }

    @Override
    public URI appClientURIWithinApp(DeploymentContext dc) {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    @Override
    public URI URIWithinAppDir(DeploymentContext dc, URI absoluteURI) {
        return this.earURI.relativize(absoluteURI);
    }

    @Override
    public String pathToAppclientWithinApp(DeploymentContext dc) {
        return this.appClientDesc().getModuleDescriptor().getArchiveUri();
    }

    private URI moduleURI() {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private String moduleNameAndType() {
        return Util.getURIName((URI)this.moduleURI());
    }

    private String moduleNameOnly() {
        String nameAndType = this.moduleNameAndType();
        return nameAndType.substring(0, nameAndType.lastIndexOf(".jar"));
    }

    private URI ensureFileSchemedURI(URI uri) throws URISyntaxException {
        URI result = uri;
        if (uri.getScheme().equals("jar")) {
            result = new URI("file", uri.getRawSchemeSpecificPart(), null);
        }
        return result;
    }

    private Artifact newArtifact(Artifact referencingArtifact, URI referencedURI) throws IOException {
        return this.newArtifact(referencingArtifact.canonicalURIWithinEAR(), referencedURI);
    }

    private Artifact newArtifact(URI referencingURI, URI referencedURI) throws IOException {
        return this.newArtifact(referencingURI.resolve(referencedURI).normalize());
    }

    private Artifact newArtifact(URI canonicalArtifactURIWithinEAR) throws IOException {
        RealArtifact result = null;
        if (this.isSubmodule(canonicalArtifactURIWithinEAR) && this.isDirectoryDeployed) {
            result = new VirtualJARArtifact(canonicalArtifactURIWithinEAR);
        } else {
            try {
                File artifactFile = new File(this.ensureFileSchemedURI(this.earURI.resolve(canonicalArtifactURIWithinEAR)));
                if (artifactFile.exists()) {
                    result = artifactFile.isDirectory() ? new DirectoryArtifact(artifactFile) : new JARArtifact(artifactFile);
                } else {
                    logger.fine("Attempt to create artifact with URI " + canonicalArtifactURIWithinEAR.toASCIIString() + " which translates to the file " + artifactFile.getAbsolutePath() + "  but no such file exists.");
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JARArtifact
    extends RealArtifact {
        JARArtifact(File artifactFile) {
            super(artifactFile);
        }

        @Override
        void processArtifact(Set<URI> artifactURIsProcessed, Collection<DownloadableArtifacts.FullAndPartURIs> downloadsForThisArtifact, Collection<DownloadableArtifacts.FullAndPartURIs> downloadsForReferencedArtifacts) throws IOException {
            Manifest jarManifest;
            URI fileURI = this.physicalFile().toURI();
            URI uriWithinAnchor = NestedAppClientDeployerHelper.this.earDirUserURI(NestedAppClientDeployerHelper.this.dc()).resolve(this.canonicalURIWithinEAR());
            DownloadableArtifacts.FullAndPartURIs fileDependency = new DownloadableArtifacts.FullAndPartURIs(fileURI, uriWithinAnchor);
            downloadsForReferencedArtifacts.add(fileDependency);
            NestedAppClientDeployerHelper.this.signedJARManager.addJAR(uriWithinAnchor, fileURI);
            this.recordArtifactAsProcessed(artifactURIsProcessed, downloadsForThisArtifact);
            try {
                JarFile dependentJar = new JarFile(this.physicalFile());
                jarManifest = dependentJar.getManifest();
                dependentJar.close();
                if (jarManifest == null) {
                    logger.log(Level.WARNING, "enterprise.deployment.appclient.jws.nomf", fileURI.toASCIIString());
                    return;
                }
            }
            catch (IOException ex) {
                return;
            }
            Attributes mainAttrs = jarManifest.getMainAttributes();
            String jarClassPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
            if (jarClassPath != null) {
                for (String elt : jarClassPath.split(" ")) {
                    URI eltURI;
                    Artifact classPathArtifact;
                    if (elt.trim().length() <= 0 || (classPathArtifact = NestedAppClientDeployerHelper.this.newArtifact(this, eltURI = URI.create(elt))) == null) continue;
                    classPathArtifact.processArtifact(artifactURIsProcessed, downloadsForReferencedArtifacts, downloadsForReferencedArtifacts);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryArtifact
    extends RealArtifact {
        DirectoryArtifact(File dirFile) {
            super(dirFile);
        }

        @Override
        void processArtifact(Set<URI> artifactURIsProcessed, Collection<DownloadableArtifacts.FullAndPartURIs> downloadsForThisArtifact, Collection<DownloadableArtifacts.FullAndPartURIs> downloadsForReferencedArtifacts) throws IOException {
            artifactURIsProcessed.add(this.canonicalURIWithinEAR());
            for (File f : this.physicalFile().listFiles()) {
                if (f.isDirectory()) {
                    Artifact nestedDirArtifact = NestedAppClientDeployerHelper.this.newArtifact(this, f.toURI());
                    if (nestedDirArtifact == null) continue;
                    nestedDirArtifact.processArtifact(artifactURIsProcessed, downloadsForReferencedArtifacts, downloadsForReferencedArtifacts);
                    continue;
                }
                URI fileURI = f.toURI();
                if (f.getName().endsWith(".jar")) {
                    fileURI = NestedAppClientDeployerHelper.this.signedJARManager.addJAR(fileURI);
                }
                DownloadableArtifacts.FullAndPartURIs fileDependency = new DownloadableArtifacts.FullAndPartURIs(fileURI, NestedAppClientDeployerHelper.this.earDirUserURI(NestedAppClientDeployerHelper.this.dc()).resolve(NestedAppClientDeployerHelper.this.earURI.relativize(fileURI)));
                downloadsForReferencedArtifacts.add(fileDependency);
            }
        }
    }

    private class VirtualJARArtifact
    extends JARArtifact {
        private final URI virtualURI;

        VirtualJARArtifact(URI virtualURI) throws IOException {
            super(NestedAppClientDeployerHelper.this.JAROfExpandedSubmodule(virtualURI));
            this.virtualURI = virtualURI;
        }

        URI canonicalURIWithinEAR() {
            return this.virtualURI;
        }
    }

    private abstract class RealArtifact
    extends Artifact {
        private final URI uriWithinEAR;

        RealArtifact(File artifactFile) {
            super(artifactFile);
            this.uriWithinEAR = NestedAppClientDeployerHelper.this.earURI.relativize(artifactFile.toURI());
        }

        URI canonicalURIWithinEAR() {
            return this.uriWithinEAR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Artifact {
        private final File physicalFile;

        abstract URI canonicalURIWithinEAR();

        abstract void processArtifact(Set<URI> var1, Collection<DownloadableArtifacts.FullAndPartURIs> var2, Collection<DownloadableArtifacts.FullAndPartURIs> var3) throws IOException;

        private Artifact(File physicalFile) {
            this.physicalFile = physicalFile;
        }

        DownloadableArtifacts.FullAndPartURIs downloadInfo() {
            return new DownloadableArtifacts.FullAndPartURIs(this.physicalFile.toURI(), NestedAppClientDeployerHelper.this.earDirUserURI(NestedAppClientDeployerHelper.this.dc()).resolve(this.canonicalURIWithinEAR()));
        }

        File physicalFile() {
            return this.physicalFile;
        }

        void recordArtifactAsProcessed(Set<URI> artifactURIsProcessed, Collection<DownloadableArtifacts.FullAndPartURIs> downloadsForThisArtifact) {
            artifactURIsProcessed.add(this.canonicalURIWithinEAR());
            downloadsForThisArtifact.add(this.downloadInfo());
        }
    }
}

