/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.config.support.CommandTarget;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor,
PostConstruct {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private InstanceState instanceState;
    @Inject
    private Target targetService;
    @Inject
    private Habitat habitat;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);
    private RemoteInstanceCommandHelper helper;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        CommandModel model;
        try {
            CommandModelProvider c = (CommandModelProvider)command;
            model = c.getModel();
        }
        catch (ClassCastException e) {
            model = new CommandModelImpl(command.getClass());
        }
        Cluster clAnnotation = model.getClusteringAttributes();
        ArrayList<RuntimeType> runtimeTypes = new ArrayList<RuntimeType>();
        if (clAnnotation == null) {
            runtimeTypes.add(RuntimeType.DAS);
            runtimeTypes.add(RuntimeType.INSTANCE);
        } else if (clAnnotation.value().length == 0) {
            runtimeTypes.add(RuntimeType.DAS);
            runtimeTypes.add(RuntimeType.INSTANCE);
        } else {
            for (RuntimeType t : clAnnotation.value()) {
                runtimeTypes.add(t);
            }
        }
        String targetName = (String)parameters.getOne((Object)"target");
        if (targetName == null) {
            targetName = "server";
        }
        if (!CommandTarget.DAS.isValid(this.habitat, targetName) && !CommandTarget.DOMAIN.isValid(this.habitat, targetName)) {
            List instancesForReplication;
            String dynRecfg;
            if (this.targetService.isCluster(targetName) && Boolean.FALSE.equals(Boolean.valueOf(dynRecfg = this.targetService.getClusterConfig(targetName).getDynamicReconfigurationEnabled()))) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.dynrecfgdisabled", "WARNING : The command was not replicated to all cluster instances because the dynamic-reconfig-enabled flag is set to false for cluster {0}", new Object[]{targetName}));
                for (Server s : this.targetService.getInstances(targetName)) {
                    this.instanceState.setState(s.getName(), InstanceState.StateType.RESTART_REQUIRED);
                }
                return ActionReport.ExitCode.WARNING;
            }
            List list = instancesForReplication = runtimeTypes.contains(RuntimeType.ALL) ? this.targetService.getAllInstances() : this.targetService.getInstances(targetName);
            if (instancesForReplication.size() == 0) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Did not find any suitable instances for target {0}; command executed on DAS only", new Object[]{targetName}));
                return ActionReport.ExitCode.SUCCESS;
            }
            return ClusterOperationUtil.replicateCommand((String)commandName, (FailurePolicy)(clAnnotation == null ? FailurePolicy.Error : clAnnotation.ifFailure()), (FailurePolicy)(clAnnotation == null ? FailurePolicy.Warn : clAnnotation.ifOffline()), (List)instancesForReplication, (AdminCommandContext)context, (ParameterMap)parameters, (Habitat)this.habitat);
        }
        return ActionReport.ExitCode.SUCCESS;
    }
}

