/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.deployment.admin.DeployCommand;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.deployment.common.VersioningDeploymentSyntaxException;
import org.glassfish.deployment.common.VersioningDeploymentUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="get-client-stubs")
@I18n(value="get.client.stubs")
@Scoped(value=PerLookup.class)
public class GetClientStubsCommand
implements AdminCommand {
    private static final String APPNAME = "appname";
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(GetClientStubsCommand.class);
    @Inject
    private DownloadableArtifacts downloadableArtifacts;
    @Inject
    private Applications apps;
    @Param(name="appname", optional=false)
    private String appname = null;
    @Param(primary=true)
    private String localDir;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        try {
            VersioningDeploymentUtil.checkIdentifier((String)this.appname);
        }
        catch (VersioningDeploymentSyntaxException ex) {
            report.failure(logger, ex.getMessage());
            return;
        }
        Application matchingApp = null;
        for (Application app : this.apps.getApplications()) {
            if (!app.getName().equals(this.appname)) continue;
            matchingApp = app;
            break;
        }
        if (matchingApp == null) {
            report.failure(logger, localStrings.getLocalString(this.getClass(), "get-client-stubs.noSuchApp", "Application {0} was not found", new Object[]{this.appname}));
            return;
        }
        try {
            DeployCommand.retrieveArtifacts((AdminCommandContext)context, (String)this.appname, (String)this.localDir, (DownloadableArtifacts)this.downloadableArtifacts);
        }
        catch (Exception e) {
            report.setFailureCause((Throwable)e);
            report.failure(logger, localStrings.getLocalString(this.getClass(), "get-client-stubs.errorPrepDownloadedFiles", "Error preparing for download"), (Throwable)e);
            return;
        }
    }
}

