/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.v3.admin.cluster.ServerSynchronizer;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Payload;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="generate-sync-bundle")
@Scoped(value=PerLookup.class)
@I18n(value="generate-sync-bundle")
public class GenerateSyncBundle
implements AdminCommand,
PostConstruct {
    @Param(optional=false)
    private String instanceName;
    @Param(optional=false, primary=true)
    String localFilePath;
    @Inject(optional=true)
    private Servers servers;
    @Inject
    private ServerSynchronizer serverSynchronizer;
    private ActionReport report;
    private File tempFile;
    private File localFile;
    private Logger logger;
    private Payload.Outbound payload;
    private Server instance;
    private SyncRequest syncRequest = new SyncRequest();
    private static final String[] ALL_DIRS = new String[]{"config", "applications", "lib", "docroot"};

    public final void postConstruct() {
        try {
            this.tempFile = File.createTempFile("GlassFishSyncBundle.", ".zip");
            this.tempFile.deleteOnExit();
        }
        catch (Exception e) {
            this.tempFile = null;
        }
    }

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.logger = context.getLogger();
        this.payload = PayloadImpl.Outbound.newInstance();
        try {
            if (!this.isValid()) {
                return;
            }
            this.syncRequest = new SyncRequest();
            this.syncRequest.instance = this.instanceName;
            if (!this.sync()) {
                return;
            }
            this.write();
            this.pumpItOut(context);
        }
        catch (Exception e) {
            this.setError("BAD WRITE!!!!");
            return;
        }
    }

    private void pumpItOut(AdminCommandContext context) throws IOException {
        Properties props = new Properties();
        File parent = this.localFile.getParentFile();
        props.setProperty("file-xfer-root", parent.getPath().replace('\\', '/'));
        URI parentURI = parent.toURI();
        context.getOutboundPayload().attachFile("application/octet-stream", parentURI.relativize(this.localFile.toURI()), "sync-bundle", props, this.tempFile);
    }

    private boolean sync() throws IOException {
        String[] arr$ = ALL_DIRS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String dir;
            this.syncRequest.dir = dir = arr$[i$];
            if (this.syncOne()) continue;
            return false;
        }
        return !this.hasError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.tempFile);
            this.payload.writeTo((OutputStream)out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private boolean syncOne() throws IOException {
        this.serverSynchronizer.synchronize(this.instance, this.syncRequest, this.payload, this.report, this.logger);
        return !this.hasError();
    }

    private boolean isValid() {
        if (this.servers != null) {
            this.instance = this.servers.getServer(this.instanceName);
        }
        if (this.instance == null) {
            this.setError(Strings.get("sync.unknown.instance", this.instanceName));
            return false;
        }
        if (this.tempFile == null) {
            this.setError(Strings.get("sync.bad_temp_file"));
            return false;
        }
        File f = new File(this.localFilePath);
        if (!f.isAbsolute()) {
            this.setError(Strings.get("sync.no_relative_path"));
            return false;
        }
        this.localFile = SmartFile.sanitize((File)new File(this.localFilePath));
        return true;
    }

    private void setError(String msg) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(msg);
    }

    private boolean hasError() {
        return this.report.getActionExitCode() != ActionReport.ExitCode.SUCCESS;
    }
}

