/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.StopServer;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="stop-instance")
@Scoped(value=PerLookup.class)
@I18n(value="stop.instance.command")
@Cluster(value={RuntimeType.DAS})
public class StopInstanceCommand
extends StopServer
implements AdminCommand,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    private ModulesRegistry registry;
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=true, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private String errorMessage = null;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        if (this.env.isDas()) {
            this.callInstance();
        } else {
            this.errorMessage = Strings.get("stop.instance.notDas", this.env.getRuntimeType().toString());
        }
        if (this.errorMessage != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(this.errorMessage);
        } else {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            this.report.setMessage(Strings.get("stop.instance.success", this.instanceName));
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    private void callInstance() {
        try {
            if (!StringUtils.ok((String)this.instanceName)) {
                this.errorMessage = Strings.get("stop.instance.noInstanceName");
                return;
            }
            Server instance = this.helper.getServer(this.instanceName);
            if (instance == null) {
                this.errorMessage = Strings.get("stop.instance.noSuchInstance", this.instanceName);
                return;
            }
            String host = this.helper.getHost(instance);
            if (host == null) {
                this.errorMessage = Strings.get("stop.instance.noHost", this.instanceName);
                return;
            }
            int port = this.helper.getAdminPort(instance);
            if (port < 0) {
                this.errorMessage = Strings.get("stop.instance.noPort", this.instanceName);
                return;
            }
            RemoteAdminCommand rac = new RemoteAdminCommand("_stop-instance", this.helper.getHost(instance), this.helper.getAdminPort(instance), false, "admin", null, this.logger);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            this.errorMessage = Strings.get("stop.instance.racError", this.instanceName);
        }
    }
}

